/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.reports.consumers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.admin.model.beans.ManagedRepository;
import org.apache.archiva.checksum.ChecksumAlgorithm;
import org.apache.archiva.checksum.ChecksummedFile;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.ConfigurationNames;
import org.apache.archiva.configuration.FileTypes;
import org.apache.archiva.consumers.AbstractMonitoredConsumer;
import org.apache.archiva.consumers.ConsumerException;
import org.apache.archiva.consumers.KnownRepositoryContentConsumer;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.facets.RepositoryProblemFacet;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.RepositorySessionFactory;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.redback.components.registry.Registry;
import org.apache.archiva.redback.components.registry.RegistryListener;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="knownRepositoryContentConsumer#duplicate-artifacts")
@Scope(value="prototype")
public class DuplicateArtifactsConsumer
extends AbstractMonitoredConsumer
implements KnownRepositoryContentConsumer,
RegistryListener {
    private Logger log = LoggerFactory.getLogger(DuplicateArtifactsConsumer.class);
    private String id = "duplicate-artifacts";
    private String description = "Check for Duplicate Artifacts via SHA1 Checksums";
    @Inject
    private ArchivaConfiguration configuration;
    @Inject
    private FileTypes filetypes;
    @Inject
    private RepositorySessionFactory repositorySessionFactory;
    private List<String> includes = new ArrayList<String>();
    private File repositoryDir;
    private String repoId;
    @Inject
    @Named(value="repositoryPathTranslator#maven2")
    private RepositoryPathTranslator pathTranslator;
    private RepositorySession repositorySession;

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return Collections.emptyList();
    }

    public void beginScan(ManagedRepository repo, Date whenGathered) throws ConsumerException {
        this.repoId = repo.getId();
        this.repositoryDir = new File(repo.getLocation());
        this.repositorySession = this.repositorySessionFactory.createSession();
    }

    public void beginScan(ManagedRepository repo, Date whenGathered, boolean executeOnEntireRepo) throws ConsumerException {
        this.beginScan(repo, whenGathered);
    }

    public void processFile(String path) throws ConsumerException {
        Collection results;
        String checksumSha1;
        File artifactFile = new File(this.repositoryDir, path);
        ChecksummedFile checksummedFile = new ChecksummedFile(artifactFile);
        try {
            checksumSha1 = checksummedFile.calculateChecksum(ChecksumAlgorithm.SHA1);
        }
        catch (IOException e) {
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        MetadataRepository metadataRepository = this.repositorySession.getRepository();
        try {
            results = metadataRepository.getArtifactsByChecksum(this.repoId, checksumSha1);
        }
        catch (MetadataRepositoryException e) {
            this.repositorySession.close();
            throw new ConsumerException(e.getMessage(), (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            ArtifactMetadata originalArtifact;
            try {
                originalArtifact = this.pathTranslator.getArtifactForPath(this.repoId, path);
            }
            catch (Exception e) {
                this.log.warn("Not reporting problem for invalid artifact in checksum check: {}", (Object)e.getMessage());
                return;
            }
            for (ArtifactMetadata dupArtifact : results) {
                String id = path.substring(path.lastIndexOf(47) + 1);
                if (dupArtifact.getId().equals(id) && dupArtifact.getNamespace().equals(originalArtifact.getNamespace()) && dupArtifact.getProject().equals(originalArtifact.getProject()) && dupArtifact.getVersion().equals(originalArtifact.getVersion())) {
                    this.log.debug("Not counting duplicate for artifact {} for path {}", (Object)dupArtifact, (Object)path);
                    continue;
                }
                RepositoryProblemFacet problem = new RepositoryProblemFacet();
                problem.setRepositoryId(this.repoId);
                problem.setNamespace(originalArtifact.getNamespace());
                problem.setProject(originalArtifact.getProject());
                problem.setVersion(originalArtifact.getVersion());
                problem.setId(id);
                problem.setMessage("Duplicate Artifact Detected: " + path + " <--> " + this.pathTranslator.toPath(dupArtifact.getNamespace(), dupArtifact.getProject(), dupArtifact.getVersion(), dupArtifact.getId()));
                problem.setProblem("duplicate-artifact");
                try {
                    metadataRepository.addMetadataFacet(this.repoId, (MetadataFacet)problem);
                }
                catch (MetadataRepositoryException e) {
                    throw new ConsumerException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void processFile(String path, boolean executeOnEntireRepo) throws ConsumerException {
        this.processFile(path);
    }

    public void completeScan() {
        this.repositorySession.close();
    }

    public void completeScan(boolean executeOnEntireRepo) {
        this.completeScan();
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (ConfigurationNames.isRepositoryScanning((String)propertyName)) {
            this.initIncludes();
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }

    private void initIncludes() {
        this.includes.clear();
        this.includes.addAll(this.filetypes.getFileTypePatterns("artifacts"));
    }

    @PostConstruct
    public void initialize() {
        this.initIncludes();
        this.configuration.addChangeListener((RegistryListener)this);
    }
}

