/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.reports;

import org.apache.archiva.metadata.model.MetadataFacet;
import org.apache.archiva.metadata.model.ProjectVersionMetadata;
import org.apache.archiva.metadata.model.facets.RepositoryProblemFacet;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.RepositorySession;
import org.apache.archiva.metadata.repository.storage.RepositoryStorageMetadataException;
import org.apache.archiva.repository.events.RepositoryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositoryListener#problem-reports")
public class RepositoryProblemEventListener
implements RepositoryListener {
    private Logger log = LoggerFactory.getLogger(RepositoryProblemEventListener.class);

    public void deleteArtifact(MetadataRepository metadataRepository, String repositoryId, String namespace, String project, String version, String id) {
        String name = RepositoryProblemFacet.createName((String)namespace, (String)project, (String)version, (String)id);
        try {
            metadataRepository.removeMetadataFacet(repositoryId, "org.apache.archiva.reports", name);
        }
        catch (MetadataRepositoryException e) {
            this.log.warn("Unable to remove metadata facet as part of delete event: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void addArtifact(RepositorySession session, String repoId, String namespace, String projectId, ProjectVersionMetadata metadata) {
        String name = RepositoryProblemFacet.createName((String)namespace, (String)projectId, (String)metadata.getId(), null);
        try {
            MetadataRepository metadataRepository = session.getRepository();
            metadataRepository.removeMetadataFacet(repoId, "org.apache.archiva.reports", name);
            session.markDirty();
        }
        catch (MetadataRepositoryException e) {
            this.log.warn("Unable to remove repository problem facets for the version being corrected in the repository: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void addArtifactProblem(RepositorySession session, String repoId, String namespace, String projectId, String projectVersion, RepositoryStorageMetadataException exception) {
        RepositoryProblemFacet problem = new RepositoryProblemFacet();
        problem.setMessage(exception.getMessage());
        problem.setProject(projectId);
        problem.setNamespace(namespace);
        problem.setRepositoryId(repoId);
        problem.setVersion(projectVersion);
        problem.setProblem(exception.getId());
        try {
            session.getRepository().addMetadataFacet(repoId, (MetadataFacet)problem);
            session.markDirty();
        }
        catch (MetadataRepositoryException e) {
            this.log.warn("Unable to add repository problem facets for the version being removed: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

