/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.security;

import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.archiva.redback.authentication.AuthenticationException;
import org.apache.archiva.redback.authentication.AuthenticationResult;
import org.apache.archiva.redback.authorization.AuthorizationException;
import org.apache.archiva.redback.authorization.AuthorizationResult;
import org.apache.archiva.redback.authorization.UnauthorizedException;
import org.apache.archiva.redback.policy.AccountLockedException;
import org.apache.archiva.redback.policy.MustChangePasswordException;
import org.apache.archiva.redback.system.DefaultSecuritySession;
import org.apache.archiva.redback.system.SecuritySession;
import org.apache.archiva.redback.system.SecuritySystem;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.security.ServletAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="servletAuthenticator")
public class ArchivaServletAuthenticator
implements ServletAuthenticator {
    private Logger log = LoggerFactory.getLogger(ArchivaServletAuthenticator.class);
    @Inject
    private SecuritySystem securitySystem;

    @Override
    public boolean isAuthenticated(HttpServletRequest request, AuthenticationResult result) throws AuthenticationException, AccountLockedException, MustChangePasswordException {
        if (result != null && !result.isAuthenticated()) {
            throw new AuthenticationException("User Credentials Invalid");
        }
        return true;
    }

    @Override
    public boolean isAuthorized(HttpServletRequest request, SecuritySession securitySession, String repositoryId, String permission) throws AuthorizationException, UnauthorizedException {
        AuthorizationResult authzResult = this.securitySystem.authorize(securitySession, permission, repositoryId);
        if (!authzResult.isAuthorized()) {
            if (authzResult.getException() != null) {
                this.log.info("Authorization Denied [ip={},permission={},repo={}] : {}", new Object[]{request.getRemoteAddr(), permission, repositoryId, authzResult.getException().getMessage()});
                throw new UnauthorizedException("Access denied for repository " + repositoryId);
            }
            throw new UnauthorizedException("User account is locked");
        }
        return true;
    }

    @Override
    public boolean isAuthorized(String principal, String repoId, String permission) throws UnauthorizedException {
        try {
            User user = this.securitySystem.getUserManager().findUser(principal);
            if (user == null) {
                throw new UnauthorizedException("The security system had an internal error - please check your system logs");
            }
            if (user.isLocked()) {
                throw new UnauthorizedException("User account is locked.");
            }
            AuthenticationResult authn = new AuthenticationResult(true, principal, null);
            DefaultSecuritySession securitySession = new DefaultSecuritySession(authn, user);
            return this.securitySystem.isAuthorized((SecuritySession)securitySession, permission, repoId);
        }
        catch (UserNotFoundException e) {
            throw new UnauthorizedException(e.getMessage(), (Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new UnauthorizedException(e.getMessage(), (Throwable)e);
        }
        catch (UserManagerException e) {
            throw new UnauthorizedException(e.getMessage(), (Throwable)e);
        }
    }

    public SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    public void setSecuritySystem(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }
}

