/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.model.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.archiva.admin.model.beans.CacheConfiguration;
import org.apache.archiva.admin.model.beans.LdapConfiguration;
import org.apache.archiva.admin.model.beans.LdapGroupMapping;
import org.apache.archiva.admin.model.beans.PropertyEntry;

@XmlRootElement(name="redbackRuntimeConfiguration")
public class RedbackRuntimeConfiguration
implements Serializable {
    private List<String> userManagerImpls = new ArrayList<String>();
    private List<String> rbacManagerImpls = new ArrayList<String>();
    private LdapConfiguration ldapConfiguration;
    private boolean migratedFromRedbackConfiguration = false;
    private Map<String, String> configurationProperties;
    private List<PropertyEntry> configurationPropertiesEntries;
    private boolean useUsersCache = true;
    private CacheConfiguration usersCacheConfiguration;
    private List<LdapGroupMapping> ldapGroupMappings;

    public List<String> getUserManagerImpls() {
        return this.userManagerImpls;
    }

    public void setUserManagerImpls(List<String> userManagerImpls) {
        this.userManagerImpls = userManagerImpls;
    }

    public LdapConfiguration getLdapConfiguration() {
        return this.ldapConfiguration;
    }

    public void setLdapConfiguration(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public boolean isMigratedFromRedbackConfiguration() {
        return this.migratedFromRedbackConfiguration;
    }

    public void setMigratedFromRedbackConfiguration(boolean migratedFromRedbackConfiguration) {
        this.migratedFromRedbackConfiguration = migratedFromRedbackConfiguration;
    }

    public Map<String, String> getConfigurationProperties() {
        if (this.configurationProperties == null) {
            this.configurationProperties = new HashMap<String, String>();
        }
        return this.configurationProperties;
    }

    public void setConfigurationProperties(Map<String, String> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public List<PropertyEntry> getConfigurationPropertiesEntries() {
        this.configurationPropertiesEntries = new ArrayList<PropertyEntry>(this.getConfigurationProperties().size());
        for (Map.Entry<String, String> entry : this.getConfigurationProperties().entrySet()) {
            this.configurationPropertiesEntries.add(new PropertyEntry(entry.getKey(), entry.getValue()));
        }
        Collections.sort(this.configurationPropertiesEntries);
        return this.configurationPropertiesEntries;
    }

    public void setConfigurationPropertiesEntries(List<PropertyEntry> configurationPropertiesEntries) {
        this.configurationPropertiesEntries = configurationPropertiesEntries;
        if (configurationPropertiesEntries != null) {
            this.configurationProperties = new HashMap<String, String>(configurationPropertiesEntries.size());
            for (PropertyEntry propertyEntry : configurationPropertiesEntries) {
                this.configurationProperties.put(propertyEntry.getKey(), propertyEntry.getValue());
            }
        }
    }

    public boolean isUseUsersCache() {
        return this.useUsersCache;
    }

    public void setUseUsersCache(boolean useUsersCache) {
        this.useUsersCache = useUsersCache;
    }

    public CacheConfiguration getUsersCacheConfiguration() {
        return this.usersCacheConfiguration;
    }

    public void setUsersCacheConfiguration(CacheConfiguration usersCacheConfiguration) {
        this.usersCacheConfiguration = usersCacheConfiguration;
    }

    public List<String> getRbacManagerImpls() {
        return this.rbacManagerImpls;
    }

    public void setRbacManagerImpls(List<String> rbacManagerImpls) {
        this.rbacManagerImpls = rbacManagerImpls;
    }

    public List<LdapGroupMapping> getLdapGroupMappings() {
        return this.ldapGroupMappings;
    }

    public void setLdapGroupMappings(List<LdapGroupMapping> ldapGroupMappings) {
        this.ldapGroupMappings = ldapGroupMappings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RedbackRuntimeConfiguration");
        sb.append("{userManagerImpls=").append(this.userManagerImpls);
        sb.append(", rbacManagerImpls=").append(this.rbacManagerImpls);
        sb.append(", ldapConfiguration=").append(this.ldapConfiguration);
        sb.append(", migratedFromRedbackConfiguration=").append(this.migratedFromRedbackConfiguration);
        sb.append(", configurationProperties=").append(this.configurationProperties);
        sb.append(", configurationPropertiesEntries=").append(this.configurationPropertiesEntries);
        sb.append(", useUsersCache=").append(this.useUsersCache);
        sb.append(", usersCacheConfiguration=").append(this.usersCacheConfiguration);
        sb.append('}');
        return sb.toString();
    }
}

