/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.model.beans;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.archiva.admin.model.beans.AbstractRepository;

@XmlRootElement(name="managedRepository")
public class ManagedRepository
extends AbstractRepository
implements Serializable {
    private String location;
    private boolean snapshots = false;
    private boolean releases = true;
    private boolean blockRedeployments = false;
    private String cronExpression = "0 0 * * * ?";
    private ManagedRepository stagingRepository;
    private boolean scanned = true;
    private int daysOlder = 100;
    private int retentionCount = 2;
    private boolean deleteReleasedSnapshots;
    private boolean stageRepoNeeded;
    private boolean resetStats;
    private boolean skipPackedIndexCreation;

    public ManagedRepository() {
    }

    public ManagedRepository(String id, String name, String location, String layout, boolean snapshots, boolean releases, boolean blockRedeployments, String cronExpression, String indexDir, boolean scanned, int daysOlder, int retentionCount, boolean deleteReleasedSnapshots, boolean stageRepoNeeded) {
        super(id, name, layout);
        this.location = location;
        this.snapshots = snapshots;
        this.releases = releases;
        this.blockRedeployments = blockRedeployments;
        this.setCronExpression(cronExpression);
        this.setIndexDirectory(indexDir);
        this.scanned = scanned;
        this.daysOlder = daysOlder;
        this.retentionCount = retentionCount;
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
        this.stageRepoNeeded = stageRepoNeeded;
    }

    public ManagedRepository(String id, String name, String location, String layout, boolean snapshots, boolean releases, boolean blockRedeployments, String cronExpression, String indexDir, boolean scanned, int daysOlder, int retentionCount, boolean deleteReleasedSnapshots, boolean stageRepoNeeded, String description, boolean skipPackedIndexCreation) {
        this(id, name, location, layout, snapshots, releases, blockRedeployments, cronExpression, indexDir, scanned, daysOlder, retentionCount, deleteReleasedSnapshots, stageRepoNeeded);
        this.setDescription(description);
        this.setSkipPackedIndexCreation(skipPackedIndexCreation);
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isReleases() {
        return this.releases;
    }

    public boolean isSnapshots() {
        return this.snapshots;
    }

    public void setReleases(boolean releases) {
        this.releases = releases;
    }

    public void setSnapshots(boolean snapshots) {
        this.snapshots = snapshots;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean isBlockRedeployments() {
        return this.blockRedeployments;
    }

    public void setBlockRedeployments(boolean blockRedeployments) {
        this.blockRedeployments = blockRedeployments;
    }

    public ManagedRepository getStagingRepository() {
        return this.stagingRepository;
    }

    public void setStagingRepository(ManagedRepository stagingRepository) {
        this.stagingRepository = stagingRepository;
    }

    public boolean isScanned() {
        return this.scanned;
    }

    public void setScanned(boolean scanned) {
        this.scanned = scanned;
    }

    public int getDaysOlder() {
        return this.daysOlder;
    }

    public void setDaysOlder(int daysOlder) {
        this.daysOlder = daysOlder;
    }

    public int getRetentionCount() {
        return this.retentionCount;
    }

    public void setRetentionCount(int retentionCount) {
        this.retentionCount = retentionCount;
    }

    public boolean isDeleteReleasedSnapshots() {
        return this.deleteReleasedSnapshots;
    }

    public void setDeleteReleasedSnapshots(boolean deleteReleasedSnapshots) {
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
    }

    public boolean isStageRepoNeeded() {
        return this.stageRepoNeeded;
    }

    public void setStageRepoNeeded(boolean stageRepoNeeded) {
        this.stageRepoNeeded = stageRepoNeeded;
    }

    public boolean isResetStats() {
        return this.resetStats;
    }

    public void setResetStats(boolean resetStats) {
        this.resetStats = resetStats;
    }

    public boolean isSkipPackedIndexCreation() {
        return this.skipPackedIndexCreation;
    }

    public void setSkipPackedIndexCreation(boolean skipPackedIndexCreation) {
        this.skipPackedIndexCreation = skipPackedIndexCreation;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("ManagedRepository");
        sb.append("{location='").append(this.location).append('\'');
        sb.append(", snapshots=").append(this.snapshots);
        sb.append(", releases=").append(this.releases);
        sb.append(", blockRedeployments=").append(this.blockRedeployments);
        sb.append(", cronExpression='").append(this.cronExpression).append('\'');
        sb.append(", stagingRepository=").append(this.stagingRepository);
        sb.append(", scanned=").append(this.scanned);
        sb.append(", daysOlder=").append(this.daysOlder);
        sb.append(", retentionCount=").append(this.retentionCount);
        sb.append(", deleteReleasedSnapshots=").append(this.deleteReleasedSnapshots);
        sb.append(", stageRepoNeeded=").append(this.stageRepoNeeded);
        sb.append(", resetStats=").append(this.resetStats);
        sb.append(", skipPackedIndexCreation=").append(this.skipPackedIndexCreation);
        sb.append('}');
        return sb.toString();
    }
}

