/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.admin.model.beans;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="legacyArtifactPath")
public class LegacyArtifactPath
implements Serializable {
    private String path;
    private String artifact;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type;

    public LegacyArtifactPath() {
    }

    public LegacyArtifactPath(String path, String artifact) {
        this.path = path;
        this.artifact = artifact;
        this.initValues(this.artifact);
    }

    private void initValues(String artifact) {
        String[] splitted = artifact.split(":");
        if (splitted.length < 4) {
            throw new IllegalArgumentException("artifact value '" + artifact + "' is not correct");
        }
        this.groupId = splitted[0];
        this.artifactId = splitted[1];
        this.version = splitted[2];
        String classifier = splitted.length >= 4 ? splitted[3] : null;
        this.classifier = classifier.length() > 0 ? classifier : null;
        String type = splitted.length >= 5 ? splitted[4] : null;
        this.type = type.length() > 0 ? artifact.split(":")[4] : null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public void setArtifact(String artifact) {
        this.artifact = artifact;
        this.initValues(this.artifact);
    }

    public boolean match(String path) {
        return path.equals(this.path);
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegacyArtifactPath that = (LegacyArtifactPath)o;
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        return this.path != null ? 37 + this.path.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LegacyArtifactPath");
        sb.append("{path='").append(this.path).append('\'');
        sb.append(", artifact='").append(this.artifact).append('\'');
        sb.append(", groupId='").append(this.groupId).append('\'');
        sb.append(", artifactId='").append(this.artifactId).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", classifier='").append(this.classifier).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

