/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.stagerepository.merge;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.archiva.common.utils.VersionComparator;
import org.apache.archiva.common.utils.VersionUtil;
import org.apache.archiva.configuration.ArchivaConfiguration;
import org.apache.archiva.configuration.Configuration;
import org.apache.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.archiva.maven2.metadata.MavenMetadataReader;
import org.apache.archiva.metadata.model.ArtifactMetadata;
import org.apache.archiva.metadata.repository.MetadataRepository;
import org.apache.archiva.metadata.repository.MetadataRepositoryException;
import org.apache.archiva.metadata.repository.filter.Filter;
import org.apache.archiva.metadata.repository.storage.RepositoryPathTranslator;
import org.apache.archiva.model.ArchivaRepositoryMetadata;
import org.apache.archiva.repository.RepositoryException;
import org.apache.archiva.repository.metadata.RepositoryMetadataException;
import org.apache.archiva.repository.metadata.RepositoryMetadataWriter;
import org.apache.archiva.stagerepository.merge.RepositoryMerger;
import org.apache.archiva.stagerepository.merge.RepositoryMergerException;
import org.apache.archiva.xml.XMLException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="repositoryMerger#maven2")
public class Maven2RepositoryMerger
implements RepositoryMerger {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ArchivaConfiguration configuration;
    private RepositoryPathTranslator pathTranslator;
    private static final String METADATA_FILENAME = "maven-metadata.xml";

    @Inject
    public Maven2RepositoryMerger(@Named(value="archivaConfiguration#default") ArchivaConfiguration archivaConfiguration, @Named(value="repositoryPathTranslator#maven2") RepositoryPathTranslator repositoryPathTranslator) {
        this.configuration = archivaConfiguration;
        this.pathTranslator = repositoryPathTranslator;
    }

    public void setConfiguration(ArchivaConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void merge(MetadataRepository metadataRepository, String sourceRepoId, String targetRepoId) throws RepositoryMergerException {
        try {
            List artifactsInSourceRepo = metadataRepository.getArtifacts(sourceRepoId);
            for (ArtifactMetadata artifactMetadata : artifactsInSourceRepo) {
                artifactMetadata.setRepositoryId(targetRepoId);
                this.createFolderStructure(sourceRepoId, targetRepoId, artifactMetadata);
            }
        }
        catch (MetadataRepositoryException e) {
            throw new RepositoryMergerException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RepositoryMergerException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new RepositoryMergerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void merge(MetadataRepository metadataRepository, String sourceRepoId, String targetRepoId, Filter<ArtifactMetadata> filter) throws RepositoryMergerException {
        try {
            List sourceArtifacts = metadataRepository.getArtifacts(sourceRepoId);
            for (ArtifactMetadata metadata : sourceArtifacts) {
                if (!filter.accept((Object)metadata)) continue;
                this.createFolderStructure(sourceRepoId, targetRepoId, metadata);
            }
        }
        catch (MetadataRepositoryException e) {
            throw new RepositoryMergerException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RepositoryMergerException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new RepositoryMergerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void createFolderStructure(String sourceRepoId, String targetRepoId, ArtifactMetadata artifactMetadata) throws IOException, RepositoryException {
        Configuration config = this.configuration.getConfiguration();
        ManagedRepositoryConfiguration targetRepoConfig = config.findManagedRepositoryById(targetRepoId);
        ManagedRepositoryConfiguration sourceRepoConfig = config.findManagedRepositoryById(sourceRepoId);
        Date lastUpdatedTimestamp = Calendar.getInstance().getTime();
        TimeZone timezone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd.HHmmss");
        fmt.setTimeZone(timezone);
        String timestamp = fmt.format(lastUpdatedTimestamp);
        String targetRepoPath = targetRepoConfig.getLocation();
        String sourceRepoPath = sourceRepoConfig.getLocation();
        String artifactPath = this.pathTranslator.toPath(artifactMetadata.getNamespace(), artifactMetadata.getProject(), artifactMetadata.getProjectVersion(), artifactMetadata.getId());
        File sourceArtifactFile = new File(sourceRepoPath, artifactPath);
        File targetArtifactFile = new File(targetRepoPath, artifactPath);
        this.log.debug("artifactPath {}", (Object)artifactPath);
        int lastIndex = artifactPath.lastIndexOf(47);
        File targetFile = new File(targetRepoPath, artifactPath.substring(0, lastIndex));
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        this.copyFile(sourceArtifactFile, targetArtifactFile);
        String index = artifactPath.substring(lastIndex + 1);
        int last = index.lastIndexOf(46);
        File sourcePomFile = new File(sourceRepoPath, artifactPath.substring(0, lastIndex) + "/" + artifactPath.substring(lastIndex + 1).substring(0, last) + ".pom");
        File targetPomFile = new File(targetRepoPath, artifactPath.substring(0, lastIndex) + "/" + artifactPath.substring(lastIndex + 1).substring(0, last) + ".pom");
        if (!targetPomFile.exists() && sourcePomFile.exists()) {
            this.copyFile(sourcePomFile, targetPomFile);
        }
        if (!config.getRepositoryScanning().getKnownContentConsumers().contains("metadata-updater")) {
            String projectDirectoryInSourceRepo;
            File projectMetadataFileInSourceRepo;
            File versionMetaDataFileInSourceRepo = this.pathTranslator.toFile(new File(sourceRepoPath), artifactMetadata.getNamespace(), artifactMetadata.getProject(), artifactMetadata.getVersion(), METADATA_FILENAME);
            if (versionMetaDataFileInSourceRepo.exists()) {
                String relativePathToVersionMetadataFile = versionMetaDataFileInSourceRepo.getAbsolutePath().split(Pattern.quote(sourceRepoPath))[1];
                File versionMetaDataFileInTargetRepo = new File(targetRepoPath, relativePathToVersionMetadataFile);
                if (!versionMetaDataFileInTargetRepo.exists()) {
                    this.copyFile(versionMetaDataFileInSourceRepo, versionMetaDataFileInTargetRepo);
                } else {
                    this.updateVersionMetadata(versionMetaDataFileInTargetRepo, artifactMetadata, lastUpdatedTimestamp);
                }
            }
            if ((projectMetadataFileInSourceRepo = new File(projectDirectoryInSourceRepo = new File(versionMetaDataFileInSourceRepo.getParent()).getParent(), METADATA_FILENAME)).exists()) {
                String relativePathToProjectMetadataFile = projectMetadataFileInSourceRepo.getAbsolutePath().split(Pattern.quote(sourceRepoPath))[1];
                File projectMetadataFileInTargetRepo = new File(targetRepoPath, relativePathToProjectMetadataFile);
                if (!projectMetadataFileInTargetRepo.exists()) {
                    this.copyFile(projectMetadataFileInSourceRepo, projectMetadataFileInTargetRepo);
                } else {
                    this.updateProjectMetadata(projectMetadataFileInTargetRepo, artifactMetadata, lastUpdatedTimestamp, timestamp);
                }
            }
        }
    }

    private void copyFile(File sourceFile, File targetFile) throws IOException {
        FileUtils.copyFile((File)sourceFile, (File)targetFile);
    }

    private void updateProjectMetadata(File projectMetaDataFileIntargetRepo, ArtifactMetadata artifactMetadata, Date lastUpdatedTimestamp, String timestamp) throws RepositoryMetadataException {
        ArrayList availableVersions = new ArrayList();
        String latestVersion = artifactMetadata.getProjectVersion();
        ArchivaRepositoryMetadata projectMetadata = this.getMetadata(projectMetaDataFileIntargetRepo);
        if (projectMetaDataFileIntargetRepo.exists()) {
            availableVersions = (ArrayList)projectMetadata.getAvailableVersions();
            Collections.sort(availableVersions, VersionComparator.getInstance());
            if (!availableVersions.contains(artifactMetadata.getVersion())) {
                availableVersions.add(artifactMetadata.getVersion());
            }
            latestVersion = (String)availableVersions.get(availableVersions.size() - 1);
        } else {
            availableVersions.add(artifactMetadata.getProjectVersion());
            projectMetadata.setGroupId(artifactMetadata.getNamespace());
            projectMetadata.setArtifactId(artifactMetadata.getProject());
        }
        if (projectMetadata.getGroupId() == null) {
            projectMetadata.setGroupId(artifactMetadata.getNamespace());
        }
        if (projectMetadata.getArtifactId() == null) {
            projectMetadata.setArtifactId(artifactMetadata.getProject());
        }
        projectMetadata.setLatestVersion(latestVersion);
        projectMetadata.setAvailableVersions((List)availableVersions);
        projectMetadata.setLastUpdated(timestamp);
        projectMetadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        if (!VersionUtil.isSnapshot((String)artifactMetadata.getVersion())) {
            projectMetadata.setReleasedVersion(latestVersion);
        }
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)projectMetadata, (File)projectMetaDataFileIntargetRepo);
    }

    private void updateVersionMetadata(File versionMetaDataFileInTargetRepo, ArtifactMetadata artifactMetadata, Date lastUpdatedTimestamp) throws RepositoryMetadataException {
        ArchivaRepositoryMetadata versionMetadata = this.getMetadata(versionMetaDataFileInTargetRepo);
        if (!versionMetaDataFileInTargetRepo.exists()) {
            versionMetadata.setGroupId(artifactMetadata.getNamespace());
            versionMetadata.setArtifactId(artifactMetadata.getProject());
            versionMetadata.setVersion(artifactMetadata.getProjectVersion());
        }
        versionMetadata.setLastUpdatedTimestamp(lastUpdatedTimestamp);
        RepositoryMetadataWriter.write((ArchivaRepositoryMetadata)versionMetadata, (File)versionMetaDataFileInTargetRepo);
    }

    private ArchivaRepositoryMetadata getMetadata(File metadataFile) throws RepositoryMetadataException {
        ArchivaRepositoryMetadata metadata = new ArchivaRepositoryMetadata();
        if (metadataFile.exists()) {
            try {
                metadata = MavenMetadataReader.read((File)metadataFile);
            }
            catch (XMLException e) {
                throw new RepositoryMetadataException(e.getMessage(), (Throwable)e);
            }
        }
        return metadata;
    }

    @Override
    public List<ArtifactMetadata> getConflictingArtifacts(MetadataRepository metadataRepository, String sourceRepo, String targetRepo) throws RepositoryMergerException {
        try {
            List targetArtifacts = metadataRepository.getArtifacts(targetRepo);
            List sourceArtifacts = metadataRepository.getArtifacts(sourceRepo);
            ArrayList<ArtifactMetadata> conflictsArtifacts = new ArrayList<ArtifactMetadata>();
            for (ArtifactMetadata targetArtifact : targetArtifacts) {
                for (ArtifactMetadata sourceArtifact : sourceArtifacts) {
                    if (!this.isEquals(targetArtifact, sourceArtifact) || conflictsArtifacts.contains(sourceArtifact)) continue;
                    conflictsArtifacts.add(sourceArtifact);
                }
            }
            sourceArtifacts.removeAll(conflictsArtifacts);
            return conflictsArtifacts;
        }
        catch (MetadataRepositoryException e) {
            throw new RepositoryMergerException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private boolean isEquals(ArtifactMetadata sourceArtifact, ArtifactMetadata targetArtifact) {
        boolean isSame = false;
        if (sourceArtifact.getNamespace().equals(targetArtifact.getNamespace()) && sourceArtifact.getProject().equals(targetArtifact.getProject()) && sourceArtifact.getId().equals(targetArtifact.getId()) && sourceArtifact.getProjectVersion().equals(targetArtifact.getProjectVersion())) {
            isSame = true;
        }
        return isSame;
    }
}

