/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.ldap.ctl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.user.LdapUser;
import org.apache.archiva.redback.common.ldap.user.LdapUserMapper;
import org.apache.archiva.redback.common.ldap.user.UserMapper;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.policy.PasswordEncoder;
import org.apache.archiva.redback.policy.encoders.SHA1PasswordEncoder;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.ldap.LdapUserQuery;
import org.apache.archiva.redback.users.ldap.ctl.LdapController;
import org.apache.archiva.redback.users.ldap.ctl.LdapControllerException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultLdapController
implements LdapController {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    @Named(value="userMapper#ldap")
    private UserMapper mapper;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration userConf;
    private boolean writableLdap = false;
    private PasswordEncoder passwordEncoder;
    private String baseDn;
    private String groupsDn;
    private String ldapGroupClass = "groupOfUniqueNames";

    @Override
    @PostConstruct
    public void initialize() {
        this.writableLdap = this.userConf.getBoolean("ldap.config.writable", this.writableLdap);
        this.baseDn = this.userConf.getConcatenatedList("ldap.config.base.dn", null);
        this.passwordEncoder = new SHA1PasswordEncoder();
        this.groupsDn = this.userConf.getConcatenatedList("ldap.config.groups.base.dn", this.groupsDn);
        this.ldapGroupClass = this.userConf.getString("ldap.config.groups.class", this.ldapGroupClass);
    }

    @Override
    public void removeUser(String principal, DirContext context) throws LdapControllerException {
    }

    @Override
    public void updateUser(User user, DirContext context) throws LdapControllerException, MappingException {
    }

    @Override
    public boolean userExists(String key, DirContext context) throws LdapControllerException {
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.searchUsers(key, context);
            boolean bl = results.hasMoreElements();
            return bl;
        }
        catch (NamingException e) {
            throw new LdapControllerException("Error searching for the existence of user: " + key, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn("Error closing search results", (Throwable)e);
                }
            }
        }
    }

    protected NamingEnumeration<SearchResult> searchUsers(String key, DirContext context) throws NamingException {
        LdapUserQuery query = new LdapUserQuery();
        query.setUsername(key);
        return this.searchUsers(context, null, query);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context) throws NamingException {
        return this.searchUsers(context, null, null);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context, String[] returnAttributes) throws NamingException {
        return this.searchUsers(context, returnAttributes, null);
    }

    protected NamingEnumeration<SearchResult> searchUsers(DirContext context, String[] returnAttributes, LdapUserQuery query) throws NamingException {
        if (query == null) {
            query = new LdapUserQuery();
        }
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(this.mapper.getReturningAttributes());
        ctls.setCountLimit(((LdapUserMapper)this.mapper).getMaxResultCount());
        String finalFilter = "(&(objectClass=" + this.mapper.getUserObjectClass() + ")" + (this.mapper.getUserFilter() != null ? this.mapper.getUserFilter() : "") + (query.getLdapFilter(this.mapper) + ")");
        this.log.debug("Searching for users with filter: '{}' from base dn: {}", (Object)finalFilter, (Object)this.mapper.getUserBaseDn());
        return context.search(this.mapper.getUserBaseDn(), finalFilter, ctls);
    }

    @Override
    public Collection<User> getUsers(DirContext context) throws LdapControllerException, MappingException {
        NamingEnumeration<SearchResult> results = null;
        try {
            LinkedHashSet<User> result;
            results = this.searchUsers(context, null, null);
            LinkedHashSet<LdapUser> users = new LinkedHashSet<LdapUser>();
            while (results.hasMoreElements()) {
                result = (SearchResult)results.nextElement();
                users.add(this.mapper.getUser(((SearchResult)((Object)result)).getAttributes()));
            }
            result = users;
            return result;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapControllerException(message, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<User> getUsersByQuery(LdapUserQuery query, DirContext context) throws LdapControllerException, MappingException {
        NamingEnumeration<SearchResult> results = null;
        try {
            LinkedList<User> result;
            results = this.searchUsers(context, null, query);
            LinkedList<LdapUser> users = new LinkedList<LdapUser>();
            while (results.hasMoreElements()) {
                result = (SearchResult)results.nextElement();
                users.add(this.mapper.getUser(((SearchResult)((Object)result)).getAttributes()));
            }
            result = users;
            return result;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve ldap information for users.";
            throw new LdapControllerException(message, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void createUser(User user, DirContext context, boolean encodePasswordIfChanged) throws LdapControllerException, MappingException {
        if (user == null) {
            return;
        }
        if (user.getUsername().equals("guest")) {
            this.log.warn("skip user '{}' creation");
            return;
        }
        boolean userExists = this.userExists(user.getUsername(), context);
        if (userExists) {
            this.log.debug("user '{}' exists skip creation", (Object)user.getUsername());
            return;
        }
        if (this.writableLdap) {
            try {
                this.bindUserObject(context, user);
                this.log.info("user {} created in ldap", (Object)user.getUsername());
            }
            catch (NamingException e) {
                throw new LdapControllerException(e.getMessage(), e);
            }
        }
    }

    private void bindUserObject(DirContext context, User user) throws NamingException {
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("inetOrgPerson");
        objectClass.add("person");
        objectClass.add("organizationalperson");
        attributes.put(objectClass);
        attributes.put("cn", user.getUsername());
        attributes.put("sn", "foo");
        if (StringUtils.isNotEmpty((String)user.getEmail())) {
            attributes.put("mail", user.getEmail());
        }
        if (this.userConf.getBoolean("ldap.bind.authenticator.allowEmptyPasswords", false) && StringUtils.isNotEmpty((String)user.getPassword())) {
            attributes.put("userPassword", this.passwordEncoder.encodePassword(user.getPassword()));
        }
        attributes.put("givenName", "foo");
        context.createSubcontext("cn=" + user.getUsername() + "," + this.getBaseDn(), (Attributes)attributes);
    }

    @Override
    public LdapUser getUser(String username, DirContext context) throws LdapControllerException, MappingException {
        this.log.debug("Searching for user: {}", (Object)username);
        LdapUserQuery query = new LdapUserQuery();
        query.setUsername(username);
        NamingEnumeration<SearchResult> result = null;
        try {
            result = this.searchUsers(context, null, query);
            if (result.hasMoreElements()) {
                SearchResult next = (SearchResult)result.nextElement();
                this.log.info("Found user: {}", (Object)username);
                LdapUser ldapUser = this.mapper.getUser(next.getAttributes());
                return ldapUser;
            }
            LdapUser next = null;
            return next;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve information for user: " + username;
            throw new LdapControllerException(message, e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Map<String, Collection<String>> findUsersWithRoles(DirContext dirContext) throws LdapControllerException {
        HashMap<String, Collection<String>> usersWithRoles = new HashMap<String, Collection<String>>();
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setDerefLinkFlag(true);
            searchControls.setSearchScope(2);
            String filter = "objectClass=" + this.getLdapGroupClass();
            namingEnumeration = dirContext.search(this.getGroupsDn(), filter, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String groupName = searchResult.getName();
                groupName = StringUtils.substringAfter((String)groupName, (String)"=");
                Attribute uniqueMemberAttr = searchResult.getAttributes().get("uniquemember");
                if (uniqueMemberAttr != null) {
                    NamingEnumeration<?> allMembersEnum = uniqueMemberAttr.getAll();
                    while (allMembersEnum.hasMore()) {
                        String userName = (String)allMembersEnum.next();
                        userName = StringUtils.substringAfter((String)userName, (String)"=");
                        HashSet<String> roles = (HashSet<String>)usersWithRoles.get(userName = StringUtils.substringBefore((String)userName, (String)","));
                        if (roles == null) {
                            roles = new HashSet<String>();
                        }
                        roles.add(groupName);
                        usersWithRoles.put(userName, roles);
                    }
                }
                this.log.debug("found groupName: '{}' with users: {}", (Object)groupName);
            }
            HashMap<String, Collection<String>> hashMap = usersWithRoles;
            return hashMap;
        }
        catch (NamingException e) {
            throw new LdapControllerException(e.getMessage(), e);
        }
        finally {
            if (namingEnumeration != null) {
                try {
                    namingEnumeration.close();
                }
                catch (NamingException e) {
                    this.log.warn("failed to close search results", (Throwable)e);
                }
            }
        }
    }

    public UserMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(UserMapper mapper) {
        this.mapper = mapper;
    }

    public UserConfiguration getUserConf() {
        return this.userConf;
    }

    public void setUserConf(UserConfiguration userConf) {
        this.userConf = userConf;
    }

    public boolean isWritableLdap() {
        return this.writableLdap;
    }

    public void setWritableLdap(boolean writableLdap) {
        this.writableLdap = writableLdap;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public String getGroupsDn() {
        return this.groupsDn;
    }

    public void setGroupsDn(String groupsDn) {
        this.groupsDn = groupsDn;
    }

    public String getLdapGroupClass() {
        return this.ldapGroupClass;
    }

    public void setLdapGroupClass(String ldapGroupClass) {
        this.ldapGroupClass = ldapGroupClass;
    }
}

