/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.directory.DirContext;
import org.apache.archiva.redback.common.ldap.MappingException;
import org.apache.archiva.redback.common.ldap.connection.LdapConnection;
import org.apache.archiva.redback.common.ldap.connection.LdapConnectionFactory;
import org.apache.archiva.redback.common.ldap.connection.LdapException;
import org.apache.archiva.redback.common.ldap.user.LdapUser;
import org.apache.archiva.redback.common.ldap.user.UserMapper;
import org.apache.archiva.redback.configuration.UserConfiguration;
import org.apache.archiva.redback.users.AbstractUserManager;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.apache.archiva.redback.users.UserQuery;
import org.apache.archiva.redback.users.ldap.LdapUserQuery;
import org.apache.archiva.redback.users.ldap.ctl.LdapController;
import org.apache.archiva.redback.users.ldap.ctl.LdapControllerException;
import org.apache.archiva.redback.users.ldap.service.LdapCacheService;
import org.springframework.stereotype.Service;

@Service(value="userManager#ldap")
public class LdapUserManager
extends AbstractUserManager
implements UserManager {
    @Inject
    @Named(value="ldapConnectionFactory#configurable")
    private LdapConnectionFactory connectionFactory;
    @Inject
    private LdapController controller;
    @Inject
    @Named(value="userMapper#ldap")
    private UserMapper mapper;
    @Inject
    @Named(value="userConfiguration#default")
    private UserConfiguration userConf;
    @Inject
    private LdapCacheService ldapCacheService;
    private User guestUser;
    private boolean writableLdap = false;

    @PostConstruct
    public void initialize() {
        this.writableLdap = this.userConf.getBoolean("ldap.config.writable", this.writableLdap);
        this.controller.initialize();
    }

    public boolean isReadOnly() {
        return !this.writableLdap;
    }

    public User addUser(User user) throws UserManagerException {
        try {
            return this.addUser(user, true);
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
    }

    public void addUserUnchecked(User user) throws UserManagerException {
        try {
            this.addUser(user, false);
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User addUser(User user, boolean checked) throws LdapException {
        if (user == null) {
            return null;
        }
        if (this.isReadOnly() && "guest".equals(user.getUsername())) {
            this.guestUser = user;
            return this.guestUser;
        }
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            this.controller.createUser(user, context, checked);
        }
        catch (LdapControllerException e) {
            this.log.error("Error mapping user: {} to LDAP attributes.", (Object)user.getUsername(), (Object)e);
        }
        catch (MappingException e) {
            this.log.error("Error mapping user: {} to LDAP attributes.", (Object)user.getUsername(), (Object)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
        return user;
    }

    public User createUser(String username, String fullName, String emailAddress) {
        return this.mapper.newUserInstance(username, fullName, emailAddress);
    }

    public UserQuery createUserQuery() {
        return new LdapUserQuery();
    }

    public void deleteUser(String username) throws UserNotFoundException, UserManagerException {
        if (username != null) {
            this.clearFromCache(username);
        }
        LdapConnection ldapConnection = null;
        try {
            ldapConnection = this.getLdapConnection();
            DirContext context = ldapConnection.getDirContext();
            this.controller.removeUser(username, context);
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to delete user: {}", (Object)username, (Object)e);
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public void eraseDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUser(String username, boolean useCache) throws UserNotFoundException, UserManagerException {
        LdapUser ldapUser;
        if (username == null) {
            throw new UserNotFoundException("Unable to find user based on null username.");
        }
        if (useCache && (ldapUser = this.ldapCacheService.getUser(username)) != null) {
            this.log.debug("User {} found in cache.", (Object)username);
            return ldapUser;
        }
        LdapConnection ldapConnection = null;
        try {
            ldapConnection = this.getLdapConnection();
            DirContext context = ldapConnection.getDirContext();
            LdapUser user = this.controller.getUser(username, context);
            if (user == null) {
                throw new UserNotFoundException("user with name " + username + " not found ");
            }
            this.log.debug("Adding user {} to cache..", (Object)username);
            this.ldapCacheService.addUser(user);
            LdapUser ldapUser2 = user;
            return ldapUser2;
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to find user: {}", (Object)username, (Object)e);
            User user = null;
            return user;
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
        catch (MappingException e) {
            this.log.error("Failed to map user: {}", (Object)username, (Object)e);
            User user = null;
            return user;
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public User findUser(String username) throws UserNotFoundException, UserManagerException {
        return this.findUser(username, true);
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) throws UserManagerException {
        LdapUserQuery query = new LdapUserQuery();
        query.setEmail(emailKey);
        query.setOrderBy("email");
        query.setAscending(orderAscending);
        return this.findUsersByQuery((UserQuery)query);
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) throws UserManagerException {
        LdapUserQuery query = new LdapUserQuery();
        query.setFullName(fullNameKey);
        query.setOrderBy("fullname");
        query.setAscending(orderAscending);
        return this.findUsersByQuery((UserQuery)query);
    }

    public List<User> findUsersByQuery(UserQuery query) throws UserManagerException {
        if (query == null) {
            return Collections.emptyList();
        }
        LdapConnection ldapConnection = null;
        try {
            ldapConnection = this.getLdapConnection();
            DirContext context = ldapConnection.getDirContext();
            List<User> list = this.controller.getUsersByQuery((LdapUserQuery)query, context);
            return list;
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to find user", (Throwable)e);
            List<User> list = null;
            return list;
        }
        catch (MappingException e) {
            this.log.error("Failed to map user", (Throwable)e);
            List<User> list = null;
            return list;
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) throws UserManagerException {
        LdapUserQuery query = new LdapUserQuery();
        query.setUsername(usernameKey);
        query.setOrderBy("username");
        query.setAscending(orderAscending);
        return this.findUsersByQuery((UserQuery)query);
    }

    public String getId() {
        return "ldap";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers() {
        LdapConnection ldapConnection = null;
        try {
            ldapConnection = this.getLdapConnection();
            DirContext context = ldapConnection.getDirContext();
            ArrayList<User> users = new ArrayList<User>(this.controller.getUsers(context));
            try {
                User u = this.getGuestUser();
                if (u != null) {
                    users.add(u);
                }
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
        return Collections.emptyList();
    }

    public List<User> getUsers(boolean orderAscending) {
        return this.getUsers();
    }

    public User updateUser(User user) throws UserNotFoundException, UserManagerException {
        return this.updateUser(user, false);
    }

    public User updateUser(User user, boolean passwordChangeRequired) throws UserNotFoundException, UserManagerException {
        if (user != null) {
            this.clearFromCache(user.getUsername());
        }
        LdapConnection ldapConnection = null;
        try {
            ldapConnection = this.getLdapConnection();
            DirContext context = ldapConnection.getDirContext();
            this.controller.updateUser(user, context);
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to update user: {}", (Object)user.getUsername(), (Object)e);
        }
        catch (MappingException e) {
            this.log.error("Failed to update user: {}", (Object)user.getUsername(), (Object)e);
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
        return user;
    }

    public boolean userExists(String principal) throws UserManagerException {
        if (principal == null) {
            return false;
        }
        LdapUser ldapUser = this.ldapCacheService.getUser(principal);
        if (ldapUser != null) {
            this.log.debug("User {} found in cache.", (Object)principal);
            return true;
        }
        LdapConnection ldapConnection = null;
        try {
            ldapConnection = this.getLdapConnection();
            DirContext context = ldapConnection.getDirContext();
            boolean bl = this.controller.userExists(principal, context);
            return bl;
        }
        catch (LdapControllerException e) {
            this.log.warn("Failed to search for user: {}", (Object)principal, (Object)e);
            boolean bl = false;
            return bl;
        }
        catch (LdapException e) {
            throw new UserManagerException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    private LdapConnection getLdapConnection() throws LdapException {
        try {
            return this.connectionFactory.getConnection();
        }
        catch (LdapException e) {
            this.log.warn("failed to get a ldap connection {}", (Object)e.getMessage(), (Object)e);
            throw new LdapException("failed to get a ldap connection " + e.getMessage(), (Throwable)e);
        }
    }

    private void closeLdapConnection(LdapConnection ldapConnection) {
        if (ldapConnection != null) {
            ldapConnection.close();
        }
    }

    private void clearFromCache(String username) {
        this.log.debug("Removing user {} from cache..", (Object)username);
        this.ldapCacheService.removeUser(username);
        this.log.debug("Removing userDn for user {} from cache..", (Object)username);
        this.ldapCacheService.removeLdapUserDn(username);
    }

    public boolean isFinalImplementation() {
        return true;
    }

    public String getDescriptionKey() {
        return "archiva.redback.usermanager.ldap";
    }
}

