/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.jdo.JDODataStoreException;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class SQLWarnings {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");

    public static void log(SQLWarning warning) {
        while (warning != null) {
            JPOXLogger.GENERAL.warn("SQL warning: " + warning);
            warning = warning.getNextWarning();
        }
    }

    public static void log(Connection conn) {
        try {
            SQLWarnings.log(conn.getWarnings());
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("SQLWarnings.ErrorObtainingWarningsFromConnection", conn), (Throwable)e);
        }
    }

    public static void log(Statement stmt) {
        try {
            SQLWarnings.log(stmt.getWarnings());
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("SQLWarnings.ErrorObtainingWarningsFromStatement", stmt), (Throwable)e);
        }
    }

    public static void log(ResultSet rs) {
        try {
            SQLWarnings.log(rs.getWarnings());
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("SQLWarnings.ErrorObtainingWarningsFromResultSet", rs), (Throwable)e);
        }
    }
}

