/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class ReadWriteLock {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private static final int WAIT_LOG_INTERVAL = 5000;
    private ThreadLocal readLocksByThread = new ThreadLocal(){

        public Object initialValue() {
            return new Count();
        }
    };
    private int readLocks = 0;
    private int writeLocks = 0;
    private Thread writeLockedBy = null;

    public synchronized void readLock() throws InterruptedException {
        Thread me = Thread.currentThread();
        Count myReadLocks = (Count)this.readLocksByThread.get();
        if (this.writeLockedBy != me) {
            while (this.writeLocks > 0) {
                this.wait(5000L);
                if (this.writeLocks <= 0 || !JPOXLogger.GENERAL.isDebugEnabled()) continue;
                JPOXLogger.GENERAL.debug(LOCALISER.msg("ReadWriteLock.WaitingForReadLock", this), new InterruptedException());
            }
        }
        ++this.readLocks;
        ++myReadLocks.value;
    }

    public synchronized void writeLock() throws InterruptedException {
        Thread me = Thread.currentThread();
        Count myReadLocks = (Count)this.readLocksByThread.get();
        if (myReadLocks.value > 0) {
            throw new IllegalStateException(LOCALISER.msg("ReadWriteLock.AlreadyHoldsReadLock"));
        }
        if (this.writeLockedBy != me) {
            while (this.writeLocks > 0 || this.readLocks > 0) {
                this.wait(5000L);
                if (this.writeLocks <= 0 && this.readLocks <= 0 || !JPOXLogger.GENERAL.isDebugEnabled()) continue;
                JPOXLogger.GENERAL.debug(LOCALISER.msg("ReadWriteLock.WaitingForWriteLock", this), new InterruptedException());
            }
            this.writeLockedBy = me;
        }
        ++this.writeLocks;
    }

    public synchronized void unlock() {
        Thread me = Thread.currentThread();
        Count myReadLocks = (Count)this.readLocksByThread.get();
        if (myReadLocks.value > 0) {
            --myReadLocks.value;
            --this.readLocks;
        } else if (this.writeLockedBy == me && this.writeLocks > 0 && --this.writeLocks == 0) {
            this.writeLockedBy = null;
        }
        this.notifyAll();
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString());
        s.append(": readLocks = ").append(this.readLocks).append(", writeLocks = ").append(this.writeLocks).append(", writeLockedBy = ").append(this.writeLockedBy);
        return s.toString();
    }

    private static class Count {
        public int value = 0;

        private Count() {
        }
    }
}

