/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class FailoverUtils {
    public static Connection getConnection(DataSource[] ds, boolean failOnError) throws SQLException {
        if (ds == null) {
            return null;
        }
        for (int i = 0; i < ds.length; ++i) {
            try {
                return ds[i].getConnection();
            }
            catch (SQLException e) {
                if (!failOnError && i != ds.length - 1) continue;
                throw e;
            }
        }
        return null;
    }

    public static Connection getConnection(DataSource[] ds, String user, String password, boolean failOnError) throws SQLException {
        if (ds == null) {
            return null;
        }
        for (int i = 0; i < ds.length; ++i) {
            try {
                return ds[i].getConnection(user, password);
            }
            catch (SQLException e) {
                if (!failOnError && i != ds.length - 1) continue;
                throw e;
            }
        }
        return null;
    }
}

