/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class ClassUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$javax$jdo$PersistenceManager;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static Object newInstance(Class type, Class[] parameterTypes, Object[] parameters) {
        Object obj;
        try {
            Constructor ctor = type.getConstructor(parameterTypes);
            obj = ctor.newInstance(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new JDOFatalInternalException(LOCALISER.msg("NewInstance.ClassMissingConstructorError", type.getName(), Arrays.asList(parameterTypes).toString() + " " + Arrays.asList(type.getConstructors()).toString()), (Throwable[])new Exception[]{e});
        }
        catch (IllegalAccessException e) {
            throw new JDOFatalInternalException(LOCALISER.msg("NewInstance.ClassAccessError", type.getName()), (Throwable[])new Exception[]{e});
        }
        catch (InstantiationException e) {
            throw new JDOFatalInternalException(LOCALISER.msg("NewInstance.ClassInstantiationError", type.getName()), (Throwable[])new Exception[]{e});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new JDOFatalInternalException(LOCALISER.msg("NewInstance.ConstructorError", type.getName(), t));
        }
        return obj;
    }

    public static Constructor getConstructorWithArguments(Class cls, Class[] types) {
        block8: {
            try {
                Constructor<?>[] constructors = cls.getConstructors();
                if (constructors == null) break block8;
                for (int i = 0; i < constructors.length; ++i) {
                    Class<?>[] ctrParams = constructors[i].getParameterTypes();
                    boolean ctrIsValid = true;
                    if (ctrParams != null && ctrParams.length == types.length) {
                        for (int j = 0; j < ctrParams.length; ++j) {
                            Class primType = ClassUtils.getPrimitiveTypeForType(types[j]);
                            if (types[j] == null && ctrParams[j].isPrimitive()) {
                                ctrIsValid = false;
                            } else {
                                if (types[j] == null || ctrParams[j] == types[j] || primType != null && (primType == null || ctrParams[j] == primType)) continue;
                                ctrIsValid = false;
                            }
                            break;
                        }
                    } else {
                        ctrIsValid = false;
                    }
                    if (!ctrIsValid) continue;
                    return constructors[i];
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getMethodWithArgument(Class cls, String methodName, Class argType) {
        Class primitive;
        Method m = ClassUtils.getMethodForClass(cls, methodName, new Class[]{argType});
        if (m == null && (primitive = ClassUtils.getPrimitiveTypeForType(argType)) != null) {
            m = ClassUtils.getMethodForClass(cls, methodName, new Class[]{primitive});
        }
        return m;
    }

    public static Method getMethodForClass(Class cls, String methodName, Class[] argtypes) {
        try {
            return cls.getDeclaredMethod(methodName, argtypes);
        }
        catch (NoSuchMethodException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getMethodForClass(cls.getSuperclass(), methodName, argtypes);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPersistenceCapableClass(ClassLoader loader, String className) {
        try {
            Class<?> cls = loader.loadClass(className);
            return ClassUtils.isPersistenceCapableClass(cls);
        }
        catch (ClassNotFoundException cnfe) {
            JPOXLogger.GENERAL.error(cnfe.getMessage());
            return false;
        }
    }

    public static boolean isPersistenceCapableClass(Class cls) {
        if (cls == null) {
            return false;
        }
        return (class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = ClassUtils.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(cls);
    }

    public static boolean hasJDO2JarInClasspath() {
        Class pc = class$javax$jdo$PersistenceManager == null ? (class$javax$jdo$PersistenceManager = ClassUtils.class$("javax.jdo.PersistenceManager")) : class$javax$jdo$PersistenceManager;
        boolean found = false;
        Method[] methods = pc.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals("detachCopy")) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean isPersistenceCapable(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof PersistenceCapable;
    }

    public static boolean isDetachable(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Detachable;
    }

    public static Boolean booleanValueOf(boolean value) {
        if (value) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getClassnameForFilename(String filename, String rootfilename) {
        String file_separator;
        if (filename == null) {
            return null;
        }
        String classname = filename;
        if (rootfilename != null) {
            classname = classname.substring(rootfilename.length());
        }
        if ((classname = classname.substring(0, classname.length() - 6)).indexOf(file_separator = System.getProperty("file.separator")) == 0) {
            classname = classname.substring(file_separator.length());
        }
        classname = StringUtils.replaceAll(classname, file_separator, ".");
        return classname;
    }

    public static Collection getClassFilesForDirectory(File dir, boolean normal_classes, boolean inner_classes) {
        if (dir == null) {
            return null;
        }
        HashSet<File> classes = new HashSet<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    if (!files[i].getName().endsWith(".class")) continue;
                    boolean is_inner_class = ClassUtils.isInnerClass(files[i].getName());
                    if ((!normal_classes || is_inner_class) && (!inner_classes || !is_inner_class)) continue;
                    classes.add(files[i]);
                    continue;
                }
                Collection child_classes = ClassUtils.getClassFilesForDirectory(files[i], normal_classes, inner_classes);
                if (child_classes == null || child_classes.size() <= 0) continue;
                classes.addAll(child_classes);
            }
        }
        return classes;
    }

    public static String[] getClassNamesForJarFile(String jarFileName) {
        try {
            JarFile jar = new JarFile(jarFileName);
            Enumeration<JarEntry> jarEntries = jar.entries();
            HashSet<String> classes = new HashSet<String>();
            String file_separator = System.getProperty("file.separator");
            while (jarEntries.hasMoreElements()) {
                String entry = jarEntries.nextElement().getName();
                if (!entry.endsWith(".class") || ClassUtils.isInnerClass(entry)) continue;
                String className = entry.substring(0, entry.length() - 6);
                className = StringUtils.replaceAll(className, file_separator, ".");
                classes.add(className);
            }
            return classes.toArray(new String[classes.size()]);
        }
        catch (IOException ioe) {
            JPOXLogger.GENERAL.warn("Error opening the jar file " + jarFileName + " : " + ioe.getMessage());
            return null;
        }
    }

    public static String[] getClassNamesForJarFile(URL jarFileURL) {
        File jarFile = new File(jarFileURL.getFile());
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> jarEntries = jar.entries();
            HashSet<String> classes = new HashSet<String>();
            String file_separator = System.getProperty("file.separator");
            while (jarEntries.hasMoreElements()) {
                String entry = jarEntries.nextElement().getName();
                if (!entry.endsWith(".class") || ClassUtils.isInnerClass(entry)) continue;
                String className = entry.substring(0, entry.length() - 6);
                className = StringUtils.replaceAll(className, file_separator, ".");
                classes.add(className);
            }
            return classes.toArray(new String[classes.size()]);
        }
        catch (IOException ioe) {
            JPOXLogger.GENERAL.warn("Error opening the jar file " + jarFileURL.getFile() + " : " + ioe.getMessage());
            return null;
        }
    }

    public static boolean isInnerClass(String class_name) {
        if (class_name == null) {
            return false;
        }
        return class_name.indexOf(36) >= 0;
    }

    public static boolean hasDefaultConstructor(Class the_class) {
        if (the_class == null) {
            return false;
        }
        try {
            the_class.getDeclaredConstructor(null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Collection getSuperclasses(Class the_class) {
        ArrayList superclasses = new ArrayList();
        Class c = the_class;
        boolean more_superclasses = true;
        while (more_superclasses) {
            Class superclass = c.getSuperclass();
            if (superclass != null) {
                superclasses.add(superclass);
                c = superclass;
                continue;
            }
            more_superclasses = false;
        }
        return superclasses;
    }

    public static Collection getSuperinterfaces(Class the_class) {
        ArrayList superintfs = new ArrayList();
        Class c = the_class;
        Class<?>[] superinterfaces = c.getInterfaces();
        if (superinterfaces != null) {
            for (int i = 0; i < superinterfaces.length; ++i) {
                if (superintfs.contains(superinterfaces[i])) continue;
                superintfs.add(superinterfaces[i]);
                superintfs.addAll(ClassUtils.getSuperinterfaces(superinterfaces[i]));
            }
        }
        return superintfs;
    }

    public static Field getFieldForClass(Class cls, String fieldName) {
        try {
            return cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (cls.getSuperclass() != null) {
                return ClassUtils.getFieldForClass(cls.getSuperclass(), fieldName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getWrapperTypeNameForPrimitiveTypeName(String typeName) {
        if (typeName.equals("boolean")) {
            return ClassNameConstants.JAVA_LANG_BOOLEAN;
        }
        if (typeName.equals("byte")) {
            return ClassNameConstants.JAVA_LANG_BYTE;
        }
        if (typeName.equals("char")) {
            return ClassNameConstants.JAVA_LANG_CHARACTER;
        }
        if (typeName.equals("double")) {
            return ClassNameConstants.JAVA_LANG_DOUBLE;
        }
        if (typeName.equals("float")) {
            return ClassNameConstants.JAVA_LANG_FLOAT;
        }
        if (typeName.equals("int")) {
            return ClassNameConstants.JAVA_LANG_INTEGER;
        }
        if (typeName.equals("long")) {
            return ClassNameConstants.JAVA_LANG_LONG;
        }
        if (typeName.equals("short")) {
            return ClassNameConstants.JAVA_LANG_SHORT;
        }
        return typeName;
    }

    public static Class getWrapperTypeForPrimitiveType(Class type) {
        if (type == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (type == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (type == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (type == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (type == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (type == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (type == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (type == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        return null;
    }

    public static Class getPrimitiveTypeForType(Class type) {
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return Boolean.TYPE;
        }
        if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return Byte.TYPE;
        }
        if (type == (class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character)) {
            return Character.TYPE;
        }
        if (type == (class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (type == (class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (type == (class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        if (type == (class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short)) {
            return Short.TYPE;
        }
        return null;
    }

    public static boolean isPrimitiveWrapperType(String typeName) {
        return typeName.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || typeName.equals(ClassNameConstants.JAVA_LANG_BYTE) || typeName.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || typeName.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || typeName.equals(ClassNameConstants.JAVA_LANG_FLOAT) || typeName.equals(ClassNameConstants.JAVA_LANG_INTEGER) || typeName.equals(ClassNameConstants.JAVA_LANG_LONG) || typeName.equals(ClassNameConstants.JAVA_LANG_SHORT);
    }

    public static boolean typesAreCompatible(Class cls1, String clsName2, ClassLoaderResolver clr) {
        if (clr.isAssignableFrom(cls1, clsName2)) {
            return true;
        }
        if (cls1.isPrimitive()) {
            return clr.isAssignableFrom(ClassUtils.getWrapperTypeForPrimitiveType(cls1), clsName2);
        }
        if (ClassUtils.isPrimitiveWrapperType(cls1.getName())) {
            return clr.isAssignableFrom(ClassUtils.getPrimitiveTypeForType(cls1), clsName2);
        }
        return false;
    }

    public static boolean typesAreCompatible(Class cls1, Class cls2) {
        if (cls1.isAssignableFrom(cls2)) {
            return true;
        }
        if (cls1.isPrimitive()) {
            return ClassUtils.getWrapperTypeForPrimitiveType(cls1).isAssignableFrom(cls2);
        }
        return false;
    }

    public static String createFullClassName(String pkg_name, String cls_name) {
        if (StringUtils.isWhitespace(cls_name)) {
            throw new IllegalArgumentException("Class name not specified");
        }
        if (StringUtils.isWhitespace(pkg_name)) {
            return cls_name;
        }
        if (cls_name.indexOf(46) >= 0) {
            return cls_name;
        }
        return pkg_name + "." + cls_name;
    }

    public static String getJavaLangClassForType(String type) {
        String baseType = null;
        baseType = type.lastIndexOf(46) < 0 ? type : type.substring(type.lastIndexOf(46) + 1);
        if (baseType.equals("String") || baseType.equals("Object") || baseType.equals("Boolean") || baseType.equals("Byte") || baseType.equals("Character") || baseType.equals("Double") || baseType.equals("Float") || baseType.equals("Integer") || baseType.equals("Long") || baseType.equals("Short") || baseType.equals("Number") || baseType.equals("StringBuffer")) {
            return "java.lang." + baseType;
        }
        return type;
    }

    public static boolean classesAreDescendents(ClassLoaderResolver clr, String class_name_1, String class_name_2) {
        Class class_1 = clr.classForName(class_name_1);
        Class class_2 = clr.classForName(class_name_2);
        if (class_1 == null || class_2 == null) {
            return false;
        }
        return class_1.isAssignableFrom(class_2) || class_2.isAssignableFrom(class_1);
    }

    public static void dumpClassInformation(Class cls) {
        int i;
        JPOXLogger.GENERAL.info("----------------------------------------");
        JPOXLogger.GENERAL.info("Class Information for class " + cls.getName());
        Collection superclasses = ClassUtils.getSuperclasses(cls);
        Iterator superclass_iter = superclasses.iterator();
        while (superclass_iter.hasNext()) {
            Class superclass = (Class)superclass_iter.next();
            JPOXLogger.GENERAL.info("    Superclass : " + superclass.getName());
        }
        Class<?>[] interfaces = cls.getInterfaces();
        if (interfaces != null) {
            for (int i2 = 0; i2 < interfaces.length; ++i2) {
                JPOXLogger.GENERAL.info("    Interface : " + interfaces[i2].getName());
            }
        }
        try {
            Method[] methods = cls.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                JPOXLogger.GENERAL.info("    Method : " + methods[i].toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Field[] fields = cls.getDeclaredFields();
            for (i = 0; i < fields.length; ++i) {
                JPOXLogger.GENERAL.info("    Field : " + fields[i].toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        JPOXLogger.GENERAL.info("----------------------------------------");
    }

    public static String getJavaBeanGetterName(String fieldName, boolean isBoolean) {
        if (fieldName == null) {
            return null;
        }
        String prefix = isBoolean ? "is" : "get";
        String name = fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        return prefix + name;
    }

    public static String getJavaBeanSetterName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String prefix = "set";
        String name = fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
        return prefix + name;
    }

    public static String getFieldNameForJavaBeanGetter(String methodName) {
        if (methodName == null) {
            return null;
        }
        if (methodName.startsWith("get")) {
            if (methodName.length() < 4) {
                return null;
            }
            return methodName.toLowerCase().charAt(3) + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            if (methodName.length() < 3) {
                return null;
            }
            return methodName.toLowerCase().charAt(2) + methodName.substring(3);
        }
        return null;
    }

    public static String getClassNameForFileURL(final URL fileURL) throws ClassNotFoundException {
        ClassLoader loader = new ClassLoader(){

            protected Class findClass(String name) throws ClassNotFoundException {
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(fileURL.openStream());
                    ByteArrayOutputStream byteStr = new ByteArrayOutputStream();
                    int byt = -1;
                    while ((byt = ((InputStream)in).read()) != -1) {
                        byteStr.write(byt);
                    }
                    byte[] byteArr = byteStr.toByteArray();
                    Class<?> clazz = this.defineClass(null, byteArr, 0, byteArr.length);
                    return clazz;
                }
                catch (RuntimeException rex) {
                    throw rex;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ClassNotFoundException(name);
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
            }
        };
        Class<?> cls = loader.loadClass("garbage");
        return cls != null ? cls.getName() : null;
    }

    public static String getPackageNameForClass(Class cls) {
        if (cls.getPackage() != null) {
            return cls.getPackage().getName();
        }
        int separator = cls.getName().lastIndexOf(46);
        return cls.getName().substring(0, separator);
    }

    public static String getClassNameForClass(Class cls) {
        if (cls.getPackage() == null) {
            return cls.getName();
        }
        int separator = cls.getName().lastIndexOf(46);
        return cls.getName().substring(separator + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

