/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXMLEntityResolver
implements EntityResolver {
    protected static Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected HashMap publicIdEntities = new HashMap();
    protected HashMap systemIdEntities = new HashMap();

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            String internalEntity;
            if (publicId != null && (internalEntity = (String)this.publicIdEntities.get(publicId)) != null) {
                return this.getLocalInputSource(publicId, systemId, internalEntity);
            }
            if (systemId != null) {
                internalEntity = (String)this.systemIdEntities.get(systemId);
                if (internalEntity != null) {
                    return this.getLocalInputSource(publicId, systemId, internalEntity);
                }
                if (systemId.startsWith("file://")) {
                    String localPath = systemId.substring(7);
                    File file = new File(localPath);
                    if (file.exists()) {
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("XMLEntity.ResolveEntityRemote", publicId, systemId));
                        }
                        FileInputStream in = new FileInputStream(file);
                        return new InputSource(in);
                    }
                    return null;
                }
                if (systemId.startsWith("file:")) {
                    return this.getLocalInputSource(publicId, systemId, systemId.substring(5));
                }
                if (systemId.startsWith("http:")) {
                    try {
                        if (JPOXLogger.METADATA.isDebugEnabled()) {
                            JPOXLogger.METADATA.debug(LOCALISER.msg("XMLEntity.ResolveEntityRemote", publicId, systemId));
                        }
                        URL url = new URL(systemId);
                        InputStream url_stream = url.openStream();
                        return new InputSource(url_stream);
                    }
                    catch (Exception e) {
                        JPOXLogger.METADATA.error(e);
                    }
                }
            }
            JPOXLogger.METADATA.error(LOCALISER.msg("XMLEntity.ResolveEntityNotFound", publicId, systemId));
            return null;
        }
        catch (Exception e) {
            JPOXLogger.METADATA.error(LOCALISER.msg("XMLEntity.ResolveEntityFailed", publicId, systemId), e);
            throw new SAXException(e.getMessage(), e);
        }
    }

    protected InputSource getLocalInputSource(String publicId, String systemId, String localPath) throws FileNotFoundException {
        InputStream in;
        if (JPOXLogger.METADATA.isDebugEnabled()) {
            JPOXLogger.METADATA.debug(LOCALISER.msg("XMLEntity.ResolveEntityLocal", publicId, systemId, localPath));
        }
        if ((in = this.getClass().getResourceAsStream(localPath)) == null) {
            JPOXLogger.METADATA.fatal("local resource \"" + localPath + "\" does not exist!!!");
            throw new FileNotFoundException("Unable to load resource: " + localPath);
        }
        return new InputSource(new InputStreamReader(in));
    }
}

