/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.typeinfo;

import java.sql.ResultSet;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class MySQLTypeInfo
extends TypeInfo {
    public MySQLTypeInfo(ResultSet rs) {
        super(rs);
        if (this.typeName.equalsIgnoreCase("FLOAT")) {
            this.dataType = (short)6;
        } else if (this.typeName.equalsIgnoreCase("CHAR")) {
            this.typeName = "CHAR(M) BINARY";
            this.createParams = "";
        } else if (this.typeName.equalsIgnoreCase("VARCHAR")) {
            this.typeName = "VARCHAR(M) BINARY";
            this.createParams = "";
        } else if (this.typeName.equalsIgnoreCase("LONG VARCHAR") || this.typeName.equalsIgnoreCase("BLOB") || this.typeName.equalsIgnoreCase("MEDIUMBLOB") || this.typeName.equalsIgnoreCase("LONGBLOB") || this.typeName.equalsIgnoreCase("MEDIUMTEXT") || this.typeName.equalsIgnoreCase("LONGTEXT") || this.typeName.equalsIgnoreCase("TEXT")) {
            this.allowsPrecisionSpec = false;
        }
    }

    public boolean isCompatibleWith(ColumnInfo colInfo) {
        if (super.isCompatibleWith(colInfo)) {
            return true;
        }
        if (MySQLTypeInfo.isStringType(this.dataType) && MySQLTypeInfo.isStringType(colInfo.getDataType())) {
            return true;
        }
        if (this.dataType == -7) {
            return colInfo.getDataType() == -6 && colInfo.getColumnSize() == 1;
        }
        if (this.dataType == 2004 && colInfo.getDataType() == -4 || this.dataType == -4 && colInfo.getDataType() == 2004) {
            return true;
        }
        return this.dataType == 2005 && colInfo.getDataType() == -1 || this.dataType == -1 && colInfo.getDataType() == 2005;
    }

    private static boolean isStringType(int type) {
        switch (type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }
}

