/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ForeignKeyAction;
import org.jpox.metadata.ForeignKeyMetaData;
import org.jpox.metadata.IndexMetaData;
import org.jpox.metadata.UniqueMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Index;

public class TableUtils {
    public static Collection getForeignKeysForReferenceField(JavaTypeMapping fieldMapping, AbstractPropertyMetaData fmd, boolean autoMode, StoreManager storeMgr, ClassLoaderResolver clr) {
        ReferenceMapping refMapping = (ReferenceMapping)fieldMapping;
        JavaTypeMapping[] refJavaTypeMappings = refMapping.getJavaTypeMapping();
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        for (int i = 0; i < refJavaTypeMappings.length; ++i) {
            ForeignKeyMetaData fkmd;
            DatastoreClass referencedTable;
            JavaTypeMapping implMapping = refJavaTypeMappings[i];
            if (storeMgr.getMetaDataManager().getMetaDataForClass(implMapping.getType(), clr) == null || implMapping.getNumberOfDatastoreFields() <= 0 || (referencedTable = storeMgr.getDatastoreClass(implMapping.getType(), clr)) == null || ((fkmd = fmd.getForeignKeyMetaData()) == null || fkmd.getDeleteAction() == ForeignKeyAction.NONE) && !autoMode) continue;
            ForeignKey fk = new ForeignKey(implMapping, storeMgr.getDatastoreAdapter(), referencedTable, true);
            fk.setForMetaData(fkmd);
            fks.add(fk);
        }
        return fks;
    }

    public static ForeignKey getForeignKeyForPCField(JavaTypeMapping fieldMapping, AbstractPropertyMetaData fmd, boolean autoMode, StoreManager storeMgr, ClassLoaderResolver clr) {
        ForeignKeyMetaData fkmd;
        DatastoreClass referencedTable = storeMgr.getDatastoreClass(fmd.getTypeName(), clr);
        if (referencedTable != null && ((fkmd = fmd.getForeignKeyMetaData()) != null && fkmd.getDeleteAction() != ForeignKeyAction.NONE || autoMode)) {
            ForeignKey fk = new ForeignKey(fieldMapping, storeMgr.getDatastoreAdapter(), referencedTable, true);
            fk.setForMetaData(fkmd);
            return fk;
        }
        return null;
    }

    public static Index getIndexForField(DatastoreContainerObject table, IndexMetaData imd, JavaTypeMapping fieldMapping) {
        boolean unique = false;
        if (imd.isUnique() != null && imd.isUnique().booleanValue()) {
            unique = true;
        }
        Index index = new Index(table, unique, imd.getValueForExtension("extended-setting"));
        if (imd.getName() != null) {
            IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
            DatastoreIdentifier idxId = idFactory.newIdentifier(3, imd.getName());
            index.setName(((Object)idxId).toString());
        }
        int countFields = fieldMapping.getNumberOfDatastoreFields();
        for (int j = 0; j < countFields; ++j) {
            index.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
        }
        return index;
    }

    public static CandidateKey getCandidateKeyForField(DatastoreContainerObject table, UniqueMetaData umd, JavaTypeMapping fieldMapping) {
        CandidateKey ck = new CandidateKey(table);
        if (umd.getName() != null) {
            IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
            DatastoreIdentifier ckId = idFactory.newIdentifier(4, umd.getName());
            ck.setName(((Object)ckId).toString());
        }
        int countFields = fieldMapping.getNumberOfDatastoreFields();
        for (int j = 0; j < countFields; ++j) {
            ck.addDatastoreField(fieldMapping.getDataStoreMapping(j).getDatastoreField());
        }
        return ck;
    }
}

