/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.exceptions.NoTableManagedException;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.RDBMSStoreHelper;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.exceptions.MissingColumnException;
import org.jpox.store.rdbms.exceptions.MissingTableException;
import org.jpox.store.rdbms.exceptions.NotATableException;
import org.jpox.store.rdbms.exceptions.UnexpectedColumnException;
import org.jpox.store.rdbms.exceptions.WrongPrimaryKeyException;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Index;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.typeinfo.ForeignKeyInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.SQLWarnings;
import org.jpox.util.StringUtils;

public abstract class TableImpl
extends AbstractTable {
    static /* synthetic */ Class class$java$lang$String;

    public TableImpl(DatastoreIdentifier name, RDBMSManager storeMgr) {
        super(name, storeMgr);
    }

    public void preInitialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
    }

    public void postInitialize(ClassLoaderResolver clr) {
        this.assertIsInitialized();
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKey pk = new PrimaryKey(this);
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            Column col = (Column)i.next();
            if (!col.isPrimaryKey()) continue;
            pk.addDatastoreField(col);
        }
        return pk;
    }

    public boolean validate(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        this.assertIsInitialized();
        int tableType = RDBMSStoreHelper.getTableType(this.storeMgr, this, conn);
        if (tableType == -1) {
            throw new MissingTableException(this.getCatalogName(), this.getSchemaName(), this.toString());
        }
        long startTime = System.currentTimeMillis();
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Table.Validating", this));
        }
        if (tableType != 1) {
            throw new NotATableException(this.toString(), tableType);
        }
        this.validateColumns(conn, validateColumnStructure, autoCreate, autoCreateErrors);
        try {
            this.validatePrimaryKey(conn);
        }
        catch (WrongPrimaryKeyException wpke) {
            if (autoCreateErrors != null) {
                autoCreateErrors.add(wpke);
            }
            throw wpke;
        }
        this.state = 4;
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
        }
        return false;
    }

    public boolean validateColumns(Connection conn, boolean validateColumnStructure, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        HashMap unvalidated = new HashMap(this.columnsByName);
        Iterator i = this.storeMgr.getColumnInfoForTable(this, conn).iterator();
        while (i.hasNext()) {
            ColumnInfo ci = (ColumnInfo)i.next();
            DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(ci.getColumnName(), this.storeMgr.getPMFContext().getTypeManager().isDefaultEmbeddedType(class$java$lang$String == null ? TableImpl.class$("java.lang.String") : class$java$lang$String), -1);
            Column col = (Column)unvalidated.get(colName);
            if (col == null) continue;
            if (validateColumnStructure) {
                col.initializeColumnInfoFromDatastore(ci);
                col.validate(ci);
                unvalidated.remove(colName);
                continue;
            }
            unvalidated.remove(colName);
        }
        if (unvalidated.size() > 0) {
            if (autoCreate) {
                ArrayList<String> stmts = new ArrayList<String>();
                Set columnKeys = unvalidated.keySet();
                Iterator columnKeysIter = columnKeys.iterator();
                while (columnKeysIter.hasNext()) {
                    DatastoreIdentifier colName = (DatastoreIdentifier)columnKeysIter.next();
                    Column col = (Column)unvalidated.get(colName);
                    String addColStmt = this.dba.getAddColumnStatement(this, col);
                    stmts.add(addColStmt);
                    JPOXLogger.RDBMS_DDL.info(LOCALISER.msg("RDBMS.Table.CreatingColumn", col.getIdentifier(), this.toString()));
                }
                try {
                    this.executeDdlStatementList(stmts, conn);
                }
                catch (SQLException sqle) {
                    if (autoCreateErrors != null) {
                        autoCreateErrors.add(sqle);
                    }
                    throw sqle;
                }
                this.storeMgr.invalidateColumnInfoForTable(this);
            } else {
                MissingColumnException mce = new MissingColumnException(this, unvalidated.values());
                if (autoCreateErrors != null) {
                    autoCreateErrors.add(mce);
                } else {
                    throw mce;
                }
            }
        }
        this.state = 4;
        return true;
    }

    public void initializeColumnInfoForPrimaryKeyColumns(Connection conn) throws SQLException {
        Iterator i = this.columnsByName.values().iterator();
        while (i.hasNext()) {
            ColumnInfo ci;
            Column col = (Column)i.next();
            if (!col.isPrimaryKey() || (ci = this.storeMgr.getColumnInfoForColumnName(this, conn, col.getIdentifier())) == null) continue;
            col.initializeColumnInfoFromDatastore(ci);
        }
    }

    public void initializeColumnInfoFromDatastore(Connection conn) throws SQLException {
        HashMap columns = new HashMap(this.columnsByName);
        Iterator i = this.storeMgr.getColumnInfoForTable(this, conn).iterator();
        while (i.hasNext()) {
            ColumnInfo ci = (ColumnInfo)i.next();
            DatastoreIdentifier colName = this.storeMgr.getIdentifierFactory().newIdentifier(1, ci.getColumnName());
            Column col = (Column)columns.get(colName);
            if (col == null) continue;
            col.initializeColumnInfoFromDatastore(ci);
        }
    }

    protected boolean validatePrimaryKey(Connection conn) throws SQLException {
        Map actualPKs = this.getExistingPrimaryKeys(conn);
        PrimaryKey expectedPK = this.getPrimaryKey();
        if (expectedPK.size() == 0 ? !actualPKs.isEmpty() : actualPKs.size() != 1 || !actualPKs.values().contains(expectedPK)) {
            throw new WrongPrimaryKeyException(this.toString(), expectedPK.toString(), StringUtils.collectionToString(actualPKs.values()));
        }
        return true;
    }

    public boolean validateConstraints(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean cksWereModified;
        boolean fksWereModified;
        boolean idxsWereModified;
        this.assertIsInitialized();
        if (this.dba.createIndexesBeforeForeignKeys()) {
            idxsWereModified = this.validateIndices(conn, autoCreate, autoCreateErrors, clr);
            fksWereModified = this.validateForeignKeys(conn, autoCreate, autoCreateErrors, clr);
            cksWereModified = this.validateCandidateKeys(conn, autoCreate, autoCreateErrors);
        } else {
            cksWereModified = this.validateCandidateKeys(conn, autoCreate, autoCreateErrors);
            fksWereModified = this.validateForeignKeys(conn, autoCreate, autoCreateErrors, clr);
            idxsWereModified = this.validateIndices(conn, autoCreate, autoCreateErrors, clr);
        }
        return fksWereModified || idxsWereModified || cksWereModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateForeignKeys(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        boolean dbWasModified = false;
        HashMap actualForeignKeysByName = null;
        int numActualFKs = 0;
        if (!TableImpl.isDumpingDdl()) {
            actualForeignKeysByName = this.getExistingForeignKeys(conn);
            numActualFKs = actualForeignKeysByName.size();
        } else {
            actualForeignKeysByName = new HashMap();
        }
        Map stmtsByFKName = this.getSQLAddFKStatements(actualForeignKeysByName, clr);
        if (stmtsByFKName.isEmpty()) {
            if (numActualFKs <= 0) return dbWasModified;
            if (!JPOXLogger.RDBMS.isInfoEnabled()) return dbWasModified;
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.ForeignKey.Validated", "" + numActualFKs, this));
            return dbWasModified;
        } else {
            if (autoCreate) {
                Statement stmt = conn.createStatement();
                try {
                    Iterator i = stmtsByFKName.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        String fkName = (String)e.getKey();
                        String stmtText = (String)e.getValue();
                        if (JPOXLogger.RDBMS.isInfoEnabled()) {
                            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.ForeignKey.Creating", fkName, this.getCatalogName(), this.getSchemaName()));
                        }
                        try {
                            this.executeDdlStatement(stmt, stmtText);
                        }
                        catch (SQLException sqle) {
                            if (autoCreateErrors == null) throw sqle;
                            autoCreateErrors.add(sqle);
                        }
                    }
                    return true;
                }
                finally {
                    stmt.close();
                }
            }
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.ForeignKey.MissingForeignKeys", this, stmtsByFKName.values()));
        }
        return dbWasModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateIndices(Connection conn, boolean autoCreate, Collection autoCreateErrors, ClassLoaderResolver clr) throws SQLException {
        Map stmtsByIdxName;
        boolean dbWasModified = false;
        HashMap actualIndicesByName = null;
        int numActualIdxs = 0;
        if (!TableImpl.isDumpingDdl()) {
            actualIndicesByName = this.getExistingIndices(conn);
            Iterator names = actualIndicesByName.keySet().iterator();
            while (names.hasNext()) {
                DatastoreIdentifier idxName = (DatastoreIdentifier)names.next();
                Index idx = (Index)actualIndicesByName.get(idxName);
                if (!((Object)idx.getDatastoreContainerObject().getIdentifier()).toString().equals(((Object)this.identifier).toString())) continue;
                ++numActualIdxs;
            }
        } else {
            actualIndicesByName = new HashMap();
        }
        if ((stmtsByIdxName = this.getSQLCreateIndexStatements(actualIndicesByName, clr)).isEmpty()) {
            if (numActualIdxs <= 0) return dbWasModified;
            if (!JPOXLogger.RDBMS.isInfoEnabled()) return dbWasModified;
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.Index.Validated", "" + numActualIdxs, this));
            return dbWasModified;
        } else {
            if (autoCreate) {
                Statement stmt = conn.createStatement();
                try {
                    Iterator i = stmtsByIdxName.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        String idxName = (String)e.getKey();
                        String stmtText = (String)e.getValue();
                        if (JPOXLogger.RDBMS.isInfoEnabled()) {
                            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.Index.Creating", idxName, this.getCatalogName(), this.getSchemaName()));
                        }
                        try {
                            this.executeDdlStatement(stmt, stmtText);
                        }
                        catch (SQLException sqle) {
                            if (autoCreateErrors == null) throw sqle;
                            autoCreateErrors.add(sqle);
                        }
                    }
                    return true;
                }
                finally {
                    stmt.close();
                }
            }
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.Index.MissingIndexes", this, stmtsByIdxName.values()));
        }
        return dbWasModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateCandidateKeys(Connection conn, boolean autoCreate, Collection autoCreateErrors) throws SQLException {
        boolean dbWasModified = false;
        HashMap actualCandidateKeysByName = null;
        int numActualCKs = 0;
        if (!TableImpl.isDumpingDdl()) {
            actualCandidateKeysByName = this.getExistingCandidateKeys(conn);
            numActualCKs = actualCandidateKeysByName.size();
        } else {
            actualCandidateKeysByName = new HashMap();
        }
        Map stmtsByCKName = this.getSQLAddCandidateKeyStatements(actualCandidateKeysByName);
        if (stmtsByCKName.isEmpty()) {
            if (numActualCKs <= 0) return dbWasModified;
            if (!JPOXLogger.RDBMS.isInfoEnabled()) return dbWasModified;
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.CandidateKey.Validated", "" + numActualCKs, this));
            return dbWasModified;
        } else {
            if (autoCreate) {
                Statement stmt = conn.createStatement();
                try {
                    Iterator i = stmtsByCKName.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        String ckName = (String)e.getKey();
                        String stmtText = (String)e.getValue();
                        if (JPOXLogger.RDBMS.isInfoEnabled()) {
                            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.CandidateKey.Creating", ckName, this.getCatalogName(), this.getSchemaName()));
                        }
                        try {
                            this.executeDdlStatement(stmt, stmtText);
                        }
                        catch (SQLException sqle) {
                            if (autoCreateErrors == null) throw sqle;
                            autoCreateErrors.add(sqle);
                        }
                    }
                    return true;
                }
                finally {
                    stmt.close();
                }
            }
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Table.CandidateKey.MissingForeignKeys", this, stmtsByCKName.values()));
        }
        return dbWasModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConstraints(Connection conn) throws SQLException {
        this.assertIsInitialized();
        boolean drop_using_constraint = this.dba.supportsAlterTableDropConstraint();
        boolean drop_using_foreign_key = this.dba.supportsAlterTableDropForeignKeyConstraint();
        if (!drop_using_constraint && !drop_using_foreign_key) {
            return;
        }
        HashSet<String> fkNames = new HashSet<String>();
        Iterator i = RDBMSStoreHelper.getForeignKeyInfoForTable(this.storeMgr, this, conn).iterator();
        while (i.hasNext()) {
            ForeignKeyInfo fki = (ForeignKeyInfo)i.next();
            if (fki.fkName == null) continue;
            fkNames.add(fki.fkName);
        }
        int numFKs = fkNames.size();
        if (numFKs > 0) {
            if (JPOXLogger.RDBMS.isInfoEnabled()) {
                JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.ForeignKey.Dropping", "" + numFKs, this));
            }
            i = fkNames.iterator();
            IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
            Statement stmt = conn.createStatement();
            try {
                while (i.hasNext()) {
                    String constraintName = (String)i.next();
                    String stmtText = null;
                    stmtText = drop_using_constraint ? "ALTER TABLE " + this.identifier + " DROP CONSTRAINT " + idFactory.getIdentifierInAdapterCase(constraintName) : "ALTER TABLE " + this.identifier + " DROP FOREIGN KEY " + idFactory.getIdentifierInAdapterCase(constraintName);
                    if (JPOXLogger.RDBMS_DDL.isDebugEnabled()) {
                        JPOXLogger.RDBMS_DDL.debug(stmtText);
                    }
                    long startTime = System.currentTimeMillis();
                    stmt.execute(stmtText);
                    if (JPOXLogger.RDBMS_DDL.isDebugEnabled()) {
                        JPOXLogger.RDBMS_DDL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
                    }
                    SQLWarnings.log(stmt);
                }
            }
            finally {
                stmt.close();
            }
        }
    }

    protected List getExpectedForeignKeys(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashSet<DatastoreField> colsInFKs = new HashSet<DatastoreField>();
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            Column col = (Column)i.next();
            if (colsInFKs.contains(col)) continue;
            try {
                DatastoreClass referencedTable = this.storeMgr.getDatastoreClass(col.getStoredJavaType(), clr);
                if (referencedTable == null) continue;
                for (int j = 0; j < col.getMapping().getNumberOfDatastoreFields(); ++j) {
                    colsInFKs.add(col.getMapping().getDataStoreMapping(j).getDatastoreField());
                }
                ForeignKey fk = new ForeignKey(col.getMapping(), this.dba, referencedTable, true);
                foreignKeys.add(fk);
            }
            catch (NoTableManagedException e) {}
        }
        return foreignKeys;
    }

    protected List getExpectedCandidateKeys() {
        this.assertIsInitialized();
        ArrayList candidateKeys = new ArrayList();
        return candidateKeys;
    }

    protected Set getExpectedIndices(ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashSet<Index> indices = new HashSet<Index>();
        PrimaryKey pk = this.getPrimaryKey();
        Iterator i = this.getExpectedForeignKeys(clr).iterator();
        while (i.hasNext()) {
            ForeignKey fk = (ForeignKey)i.next();
            if (pk.startsWith(fk)) continue;
            indices.add(new Index(fk));
        }
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getExistingPrimaryKeys(Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        String[] c = RDBMSStoreHelper.splitTableIdentifierName(this.dba.getCatalogSeparator(), this.identifier.getIdentifier());
        HashMap<DatastoreIdentifier, PrimaryKey> primaryKeysByName = new HashMap<DatastoreIdentifier, PrimaryKey>();
        ResultSet rs = dmd.getPrimaryKeys(c[0], c[1] == null ? this.getSchemaName() : c[1], c[2]);
        try {
            while (rs.next()) {
                RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
                String s = rs.getString(6);
                DatastoreIdentifier pkName = s == null ? idFactory.newPrimaryKeyIdentifier(this) : idFactory.newIdentifier(1, s);
                PrimaryKey pk = (PrimaryKey)primaryKeysByName.get(pkName);
                if (pk == null) {
                    pk = new PrimaryKey(this);
                    pk.setName(pkName.getIdentifier());
                    primaryKeysByName.put(pkName, pk);
                }
                int keySeq = rs.getInt(5) - 1;
                DatastoreIdentifier colName = idFactory.newIdentifier(1, rs.getString(4));
                Column col = (Column)this.columnsByName.get(colName);
                if (col == null) {
                    throw new UnexpectedColumnException(this.toString(), colName.getIdentifier(), this.getSchemaName(), this.getCatalogName());
                }
                pk.setDatastoreField(keySeq, col);
            }
        }
        finally {
            if (rs.getStatement() != null) {
                rs.getStatement().close();
            }
            rs.close();
        }
        return primaryKeysByName;
    }

    private Map getExistingForeignKeys(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, ForeignKey> foreignKeysByName = new HashMap<DatastoreIdentifier, ForeignKey>();
        Iterator i = RDBMSStoreHelper.getForeignKeyInfoForTable(this.storeMgr, this, conn).iterator();
        while (i.hasNext()) {
            TableImpl refTable;
            RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
            ForeignKeyInfo fki = (ForeignKeyInfo)i.next();
            DatastoreIdentifier fkName = fki.fkName == null ? idFactory.newForeignKeyIdentifier(this, foreignKeysByName.size()) : idFactory.newIdentifier(2, fki.fkName);
            boolean initiallyDeferred = fki.deferrability == 5;
            ForeignKey fk = (ForeignKey)foreignKeysByName.get(fkName);
            if (fk == null) {
                fk = new ForeignKey(initiallyDeferred);
                fk.setName(fkName.getIdentifier());
                foreignKeysByName.put(fkName, fk);
            }
            if ((refTable = (TableImpl)((Object)this.storeMgr.getDatastoreClass(idFactory.newDatastoreContainerIdentifier(fki.pkTableName)))) == null) continue;
            DatastoreIdentifier colName = idFactory.newIdentifier(1, fki.fkColumnName);
            DatastoreIdentifier refColName = idFactory.newIdentifier(1, fki.pkColumnName);
            DatastoreField col = (DatastoreField)this.columnsByName.get(colName);
            DatastoreField refCol = (DatastoreField)refTable.columnsByName.get(refColName);
            if (col == null || refCol == null) continue;
            fk.addDatastoreField(col, refCol);
        }
        return foreignKeysByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getExistingCandidateKeys(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, CandidateKey> candidateKeysByName;
        block16: {
            DatabaseMetaData dmd = conn.getMetaData();
            candidateKeysByName = new HashMap<DatastoreIdentifier, CandidateKey>();
            String[] c = RDBMSStoreHelper.splitTableIdentifierName(this.dba.getCatalogSeparator(), this.identifier.getIdentifier());
            ResultSet rs = dmd.getTables(c[0], c[1] == null ? this.getSchemaName() : c[1], c[2], null);
            boolean isRsOpen = true;
            try {
                if (!rs.next()) break block16;
                RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
                if (rs.getStatement() != null) {
                    rs.getStatement().close();
                }
                rs.close();
                isRsOpen = false;
                ResultSet rsIndexes = this.dba.getExistingIndexes(conn, dmd, c[0], c[1] == null ? this.getSchemaName() : c[1], c[2]);
                try {
                    boolean hasNext = rsIndexes.next();
                    if (!hasNext) {
                        rsIndexes = this.dba.getExistingIndexes(conn, dmd, c[0], this.storeMgr.getSchemaName(), c[2]);
                        hasNext = rsIndexes.next();
                    }
                    while (hasNext) {
                        boolean isUnique;
                        boolean bl = isUnique = !rsIndexes.getBoolean(4);
                        if (isUnique) {
                            short idxType = rsIndexes.getShort(7);
                            if (idxType == 0) {
                                hasNext = rsIndexes.next();
                                continue;
                            }
                            String keyName = rsIndexes.getString(6);
                            DatastoreIdentifier idxName = idFactory.newIdentifier(4, keyName);
                            CandidateKey can = (CandidateKey)candidateKeysByName.get(idxName);
                            if (can == null) {
                                can = new CandidateKey(this);
                                can.setName(keyName);
                                candidateKeysByName.put(idxName, can);
                            }
                            int colSeq = rsIndexes.getShort(8) - 1;
                            DatastoreIdentifier colName = idFactory.newIdentifier(1, rsIndexes.getString(9));
                            Column col = (Column)this.columnsByName.get(colName);
                            if (col != null) {
                                can.setDatastoreField(colSeq, col);
                            }
                        }
                        hasNext = rsIndexes.next();
                    }
                }
                finally {
                    if (rsIndexes.getStatement() != null) {
                        rsIndexes.getStatement().close();
                    }
                    rsIndexes.close();
                }
            }
            finally {
                if (isRsOpen) {
                    if (rs.getStatement() != null) {
                        rs.getStatement().close();
                    }
                    rs.close();
                }
            }
        }
        return candidateKeysByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getExistingIndices(Connection conn) throws SQLException {
        HashMap<DatastoreIdentifier, Index> indicesByName;
        block15: {
            DatabaseMetaData dmd = conn.getMetaData();
            indicesByName = new HashMap<DatastoreIdentifier, Index>();
            String[] c = RDBMSStoreHelper.splitTableIdentifierName(this.dba.getCatalogSeparator(), this.identifier.getIdentifier());
            ResultSet rs = dmd.getTables(c[0], c[1] == null ? this.getSchemaName() : c[1], c[2], null);
            boolean isRsOpen = true;
            try {
                if (!rs.next()) break block15;
                RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
                if (rs.getStatement() != null) {
                    rs.getStatement().close();
                }
                rs.close();
                isRsOpen = false;
                ResultSet rsIndexes = this.dba.getExistingIndexes(conn, dmd, c[0], c[1] == null ? this.getSchemaName() : c[1], c[2]);
                try {
                    boolean hasNext = rsIndexes.next();
                    if (!hasNext) {
                        rsIndexes = this.dba.getExistingIndexes(conn, dmd, c[0], this.storeMgr.getSchemaName(), c[2]);
                        hasNext = rsIndexes.next();
                    }
                    while (hasNext) {
                        short idxType = rsIndexes.getShort(7);
                        if (idxType == 0) {
                            hasNext = rsIndexes.next();
                            continue;
                        }
                        String indexName = rsIndexes.getString(6);
                        DatastoreIdentifier idxName = idFactory.newIdentifier(3, indexName);
                        Index idx = (Index)indicesByName.get(idxName);
                        if (idx == null) {
                            boolean isUnique = !rsIndexes.getBoolean(4);
                            idx = new Index(this, isUnique, null);
                            idx.setName(indexName);
                            indicesByName.put(idxName, idx);
                        }
                        int colSeq = rsIndexes.getShort(8) - 1;
                        DatastoreIdentifier colName = idFactory.newIdentifier(1, rsIndexes.getString(9));
                        Column col = (Column)this.columnsByName.get(colName);
                        if (col != null) {
                            idx.setColumn(colSeq, col);
                        }
                        hasNext = rsIndexes.next();
                    }
                }
                finally {
                    if (rsIndexes.getStatement() != null) {
                        rsIndexes.getStatement().close();
                    }
                    rsIndexes.close();
                }
            }
            finally {
                if (isRsOpen) {
                    if (rs.getStatement() != null) {
                        rs.getStatement().close();
                    }
                    rs.close();
                }
            }
        }
        return indicesByName;
    }

    protected List getSQLCreateStatements(Properties props) {
        String pkStmt;
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getCreateTableStatement(this, this.columns.toArray(new Column[this.columns.size()]), props));
        PrimaryKey pk = this.getPrimaryKey();
        if (pk.size() > 0 && (pkStmt = this.dba.getAddPrimaryKeyStatement(pk, this.storeMgr.getIdentifierFactory())) != null) {
            stmts.add(pkStmt);
        }
        return stmts;
    }

    protected Map getSQLAddFKStatements(Map actualForeignKeysByName, ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashMap<String, String> stmtsByFKName = new HashMap<String, String>();
        List expectedForeignKeys = this.getExpectedForeignKeys(clr);
        Iterator i = expectedForeignKeys.iterator();
        int n = 1;
        RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
        while (i.hasNext()) {
            ForeignKey fk = (ForeignKey)i.next();
            if (actualForeignKeysByName.containsValue(fk)) continue;
            if (fk.getName() == null) {
                DatastoreIdentifier fkName;
                while (actualForeignKeysByName.containsKey(fkName = idFactory.newForeignKeyIdentifier(this, n++))) {
                }
                fk.setName(fkName.getIdentifier());
            }
            String stmtText = this.dba.getAddForeignKeyStatement(fk, idFactory);
            stmtsByFKName.put(fk.getName(), stmtText);
        }
        return stmtsByFKName;
    }

    protected Map getSQLAddCandidateKeyStatements(Map actualCandidateKeysByName) {
        this.assertIsInitialized();
        HashMap<String, String> stmtsByCKName = new HashMap<String, String>();
        List expectedCandidateKeys = this.getExpectedCandidateKeys();
        Iterator i = expectedCandidateKeys.iterator();
        int n = 1;
        RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
        while (i.hasNext()) {
            CandidateKey ck = (CandidateKey)i.next();
            if (actualCandidateKeysByName.containsValue(ck)) continue;
            if (ck.getName() == null) {
                DatastoreIdentifier ckName;
                while (actualCandidateKeysByName.containsKey(ckName = idFactory.newCandidateKeyIdentifier(this, n++))) {
                }
                ck.setName(ckName.getIdentifier());
            }
            String stmtText = this.dba.getAddCandidateKeyStatement(ck, idFactory);
            stmtsByCKName.put(ck.getName(), stmtText);
        }
        return stmtsByCKName;
    }

    private boolean isIndexReallyNeeded(Index requiredIdx, Collection actualIndices) {
        Iterator i = actualIndices.iterator();
        if (requiredIdx.getName() != null) {
            IdentifierFactory idFactory = requiredIdx.getDatastoreContainerObject().getStoreManager().getIdentifierFactory();
            String reqdName = idFactory.getIdentifierInAdapterCase(requiredIdx.getName());
            while (i.hasNext()) {
                Index actualIdx = (Index)i.next();
                String actualName = idFactory.getIdentifierInAdapterCase(actualIdx.getName());
                if (!actualName.equals(reqdName) || !((Object)actualIdx.getDatastoreContainerObject().getIdentifier()).toString().equals(((Object)requiredIdx.getDatastoreContainerObject().getIdentifier()).toString())) continue;
                return false;
            }
        } else {
            while (i.hasNext()) {
                Index actualIdx = (Index)i.next();
                if (!actualIdx.toString().equals(requiredIdx.toString()) || !((Object)actualIdx.getDatastoreContainerObject().getIdentifier()).toString().equals(((Object)requiredIdx.getDatastoreContainerObject().getIdentifier()).toString())) continue;
                return false;
            }
        }
        return true;
    }

    protected Map getSQLCreateIndexStatements(Map actualIndicesByName, ClassLoaderResolver clr) {
        this.assertIsInitialized();
        HashMap<String, String> stmtsByIdxName = new HashMap<String, String>();
        Set expectedIndices = this.getExpectedIndices(clr);
        int n = 1;
        Iterator i = expectedIndices.iterator();
        RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
        while (i.hasNext()) {
            Index idx = (Index)i.next();
            if (!this.isIndexReallyNeeded(idx, actualIndicesByName.values())) continue;
            if (idx.getName() == null) {
                DatastoreIdentifier idxName;
                do {
                    idxName = idFactory.newIndexIdentifier(this, idx.getUnique(), n++);
                    idx.setName(idxName.getIdentifier());
                } while (actualIndicesByName.containsKey(idxName));
            }
            String stmtText = this.dba.getCreateIndexStatement(idx, idFactory);
            stmtsByIdxName.put(idx.getName(), stmtText);
        }
        return stmtsByIdxName;
    }

    protected List getSQLDropStatements() {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        stmts.add(this.dba.getDropTableStatement(this));
        return stmts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

