/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.table.TableImpl;

public class SequenceTable
extends TableImpl {
    private JavaTypeMapping sequenceNameMapping = null;
    private JavaTypeMapping nextValMapping = null;
    private String insertStmt = null;
    private String incrementByStmt = null;
    private String deleteStmt = null;
    private String deleteAllStmt = null;
    private String fetchAllStmt = null;
    private String fetchStmt = null;
    private String sequenceNameColumnName;
    private String nextValColumnName;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public SequenceTable(DatastoreIdentifier identifier, RDBMSManager storeMgr, String seqNameColName, String nextValColName) {
        super(identifier, storeMgr);
        this.sequenceNameColumnName = seqNameColName;
        this.nextValColumnName = nextValColName;
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        this.sequenceNameMapping = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = SequenceTable.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        Column colSequenceName = (Column)this.addDatastoreField((class$java$lang$String == null ? (class$java$lang$String = SequenceTable.class$("java.lang.String")) : class$java$lang$String).getName(), idFactory.newDatastoreFieldIdentifier(this.sequenceNameColumnName), this.sequenceNameMapping, null);
        colSequenceName.setAsPrimaryKey();
        colSequenceName.getColumnMetaData().setLength(Integer.valueOf("255"));
        colSequenceName.getColumnMetaData().setJdbcType("VARCHAR");
        this.getStoreManager().getMappingManager().createDatastoreMapping(this.sequenceNameMapping, this.storeMgr, colSequenceName, (class$java$lang$String == null ? (class$java$lang$String = SequenceTable.class$("java.lang.String")) : class$java$lang$String).getName());
        this.nextValMapping = this.dba.getMapping(class$java$lang$Long == null ? (class$java$lang$Long = SequenceTable.class$("java.lang.Long")) : class$java$lang$Long, this.storeMgr);
        DatastoreField colNextVal = this.addDatastoreField((class$java$lang$Long == null ? (class$java$lang$Long = SequenceTable.class$("java.lang.Long")) : class$java$lang$Long).getName(), idFactory.newDatastoreFieldIdentifier(this.nextValColumnName), this.nextValMapping, null);
        this.getStoreManager().getMappingManager().createDatastoreMapping(this.nextValMapping, this.storeMgr, colNextVal, (class$java$lang$Long == null ? (class$java$lang$Long = SequenceTable.class$("java.lang.Long")) : class$java$lang$Long).getName());
        this.insertStmt = "INSERT INTO " + this.identifier.getFullyQualifiedName(false) + " (" + colSequenceName.getIdentifier() + "," + colNextVal.getIdentifier() + ") VALUES (?,?)";
        this.incrementByStmt = "UPDATE " + this.identifier.getFullyQualifiedName(false) + " SET " + colNextVal.getIdentifier() + "=(" + colNextVal.getIdentifier() + "+?) WHERE " + colSequenceName.getIdentifier() + "=?";
        this.deleteStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + colSequenceName.getIdentifier() + "=?";
        this.deleteAllStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false);
        this.fetchStmt = "SELECT " + colNextVal.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + colSequenceName.getIdentifier() + "=?";
        if (this.dba.supportsLockWithSelectForUpdate()) {
            this.fetchStmt = this.fetchStmt + " FOR UPDATE";
        }
        this.fetchAllStmt = "SELECT " + colNextVal.getIdentifier() + "," + colSequenceName.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false) + " ORDER BY " + colSequenceName.getIdentifier();
        this.state = 2;
    }

    public JavaTypeMapping getIDMapping() {
        throw new JDOFatalInternalException("Attempt to get ID mapping of Sequence table!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getFetchAllSequences(Connection conn) throws SQLException {
        HashSet<String> sequenceNames = new HashSet<String>();
        Statement ps = null;
        try {
            ps = this.storeMgr.getStatement(conn, this.fetchAllStmt, true);
            ResultSet rs = this.storeMgr.executeStatementQuery(this.fetchAllStmt, (PreparedStatement)ps);
            try {
                while (rs.next()) {
                    sequenceNames.add(rs.getString(2));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return sequenceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextVal(String sequenceName, Connection conn, int incrementBy, DatastoreIdentifier tableIdentifier, String columnName, int initialValue) throws SQLException {
        Long nextVal;
        block21: {
            Statement ps = null;
            nextVal = null;
            try {
                ps = this.storeMgr.getStatement(conn, this.fetchStmt, true);
                this.sequenceNameMapping.setString(null, ps, new int[]{1}, sequenceName);
                ResultSet rs = this.storeMgr.executeStatementQuery(this.fetchStmt, (PreparedStatement)ps);
                try {
                    if (!rs.next()) {
                        boolean addedSequence = false;
                        if (columnName != null && tableIdentifier != null) {
                            Statement ps2 = null;
                            ResultSet rs2 = null;
                            try {
                                String fetchInitStmt = "SELECT MAX(" + columnName + ") FROM " + tableIdentifier.getFullyQualifiedName(false);
                                ps2 = this.storeMgr.getStatement(conn, fetchInitStmt, true);
                                rs2 = this.storeMgr.executeStatementQuery(fetchInitStmt, (PreparedStatement)ps2);
                                if (rs2.next()) {
                                    long val = rs2.getLong(1);
                                    this.addSequence(sequenceName, new Long((long)(incrementBy + 1) + val), conn);
                                    nextVal = new Long(1L + val);
                                    addedSequence = true;
                                }
                            }
                            catch (Exception e) {
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                                if (ps2 != null) {
                                    ps2.close();
                                }
                            }
                        }
                        if (!addedSequence) {
                            this.addSequence(sequenceName, new Long(incrementBy + 1), conn);
                            nextVal = new Long(1L);
                        }
                        break block21;
                    }
                    nextVal = new Long(rs.getLong(1));
                    this.incrementSequence(sequenceName, incrementBy, conn);
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException e) {
                throw new PoidException(LOCALISER.msg("SequencePoidGenerator.CantObtainSequenceId", e.getMessage()), e);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementSequence(String sequenceName, long incrementBy, Connection conn) throws SQLException {
        Statement ps = null;
        try {
            ps = this.storeMgr.getStatement(conn, this.incrementByStmt, false);
            this.nextValMapping.setLong(null, ps, new int[]{1}, incrementBy);
            this.sequenceNameMapping.setString(null, ps, new int[]{2}, sequenceName);
            this.storeMgr.executeStatementUpdate(this.incrementByStmt, (PreparedStatement)ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private void addSequence(String sequenceName, Long nextVal, Connection conn) throws SQLException {
        Statement ps = null;
        try {
            ps = this.storeMgr.getStatement(conn, this.insertStmt, false);
            this.sequenceNameMapping.setString(null, ps, new int[]{1}, sequenceName);
            this.nextValMapping.setLong(null, ps, new int[]{2}, nextVal);
            this.storeMgr.executeStatementUpdate(this.insertStmt, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSequence(String sequenceName, Connection conn) throws SQLException {
        Statement ps = null;
        try {
            ps = this.storeMgr.getStatement(conn, this.deleteStmt, false);
            ps.setString(1, sequenceName);
            this.storeMgr.executeStatementUpdate(this.deleteStmt, (PreparedStatement)ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllSequences(Connection conn) throws SQLException {
        Statement ps = null;
        try {
            ps = this.storeMgr.getStatement(conn, this.deleteAllStmt, false);
            this.storeMgr.executeStatementUpdate(this.deleteAllStmt, (PreparedStatement)ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public JavaTypeMapping getFieldMapping(AbstractPropertyMetaData fmd) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

