/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import javax.jdo.JDOFatalInternalException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.PrimaryKeyMetaData;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.table.TableImpl;

public abstract class JoinTable
extends TableImpl
implements DatastoreContainerObject {
    protected final AbstractPropertyMetaData fmd;
    protected JavaTypeMapping ownerMapping;
    protected final String ownerType;

    protected JoinTable(DatastoreIdentifier tableName, AbstractPropertyMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, storeMgr);
        this.fmd = fmd;
        this.ownerType = fmd.getClassName(true);
        if (fmd.getPersistenceModifier() == FieldPersistenceModifier.NONE) {
            throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.Table.InvalidPersistenceModifierForField", fmd.getName()));
        }
    }

    public PrimaryKey getPrimaryKey() {
        PrimaryKeyMetaData pkmd;
        PrimaryKey pk = super.getPrimaryKey();
        if (this.fmd.getJoinMetaData() != null && (pkmd = this.fmd.getJoinMetaData().getPrimaryKeyMetaData()) != null && pkmd.getName() != null) {
            pk.setName(pkmd.getName());
        }
        return pk;
    }

    protected boolean requiresPrimaryKey() {
        boolean pkRequired = true;
        if (this.fmd.getJoinMetaData() != null && this.fmd.getJoinMetaData().hasExtension("primary-key") && this.fmd.getJoinMetaData().getValueForExtension("primary-key").equalsIgnoreCase("false")) {
            pkRequired = false;
        }
        return pkRequired;
    }

    public JavaTypeMapping getOwnerMapping() {
        this.assertIsInitialized();
        return this.ownerMapping;
    }

    public AbstractPropertyMetaData getOwnerFieldMetaData() {
        return this.fmd;
    }

    public JavaTypeMapping getIDMapping() {
        throw new JDOFatalInternalException("Unsupported ID mapping in join table");
    }
}

