/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.VersionMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;
import org.jpox.store.exceptions.NoSuchPersistentFieldException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.exceptions.PersistentSuperclassNotAllowedException;
import org.jpox.store.rdbms.exceptions.ViewDefinitionException;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.table.ViewImpl;
import org.jpox.util.MacroString;

public class ClassView
extends ViewImpl
implements DatastoreClass {
    private int nextHiValue = -1;
    private int nextLoValue = -1;
    private final ClassMetaData cmd;
    private final MacroString viewDef;
    private String createStatementDDL;
    private JavaTypeMapping[] fieldMappings;

    public ClassView(DatastoreIdentifier tableName, RDBMSManager storeMgr, ClassMetaData cmd) {
        super(tableName, storeMgr);
        this.cmd = cmd;
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new JDOUnsupportedOptionException(LOCALISER.msg("RDBMS.View.IdentityTypeNotSupported", cmd.getFullClassName(), cmd.getIdentityType()));
        }
        if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            // empty if block
        }
        if (cmd.getPersistenceCapableSuperclass() != null) {
            throw new PersistentSuperclassNotAllowedException(cmd.getFullClassName());
        }
        String viewImpStr = cmd.getValueForExtension("view-imports");
        String viewDefStr = null;
        if (this.dba.getVendorID() != null) {
            viewDefStr = cmd.getValueForExtension("view-definition-" + this.dba.getVendorID());
        }
        if (viewDefStr == null) {
            viewDefStr = cmd.getValueForExtension("view-definition");
        }
        if (viewDefStr == null) {
            throw new ViewDefinitionException(cmd.getFullClassName(), viewDefStr);
        }
        this.viewDef = new MacroString(cmd.getFullClassName(), viewImpStr, viewDefStr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        int fieldCount = this.cmd.getNoOfManagedFields();
        this.fieldMappings = new JavaTypeMapping[fieldCount];
        for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
            AbstractPropertyMetaData fmd = this.cmd.getManagedField(fieldNumber);
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                this.fieldMappings[fieldNumber] = this.dba.getMappingManager().getMapping(this, fmd, this.dba, clr, 0);
                continue;
            }
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
            throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.InvalidPersistenceModifierForField", this.cmd.getFullClassName(), fmd.getName(), fmd.getPersistenceModifier()));
        }
        this.state = 2;
    }

    public void postInitialize(final ClassLoaderResolver clr) {
        this.assertIsInitialized();
        this.createStatementDDL = this.viewDef.substituteMacros(new MacroString.MacroHandler(){

            public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                ClassView.this.storeMgr.resolveIdentifierMacro(im, clr);
            }

            public void onParameterMacro(MacroString.ParameterMacro pm) {
                throw new JDOUserException(AbstractTable.LOCALISER.msg("RDBMS.View.MacrosNotAllowedInViewDefinition", ClassView.this.cmd.getFullClassName(), pm));
            }
        }, clr);
    }

    public JavaTypeMapping getIDMapping() {
        for (int i = 0; i < this.fieldMappings.length; ++i) {
            if (this.fieldMappings[i] == null) continue;
            return this.fieldMappings[i];
        }
        return null;
    }

    public DatastoreClass getBaseDatastoreClassWithField(AbstractPropertyMetaData fmd) {
        return null;
    }

    public DatastoreClass getSuperDatastoreClass() {
        return null;
    }

    public JavaTypeMapping getDataStoreObjectIdMapping() {
        return null;
    }

    public boolean managesClass(String className) {
        return false;
    }

    public AbstractPropertyMetaData getFieldMetaData(String fieldName) {
        return this.cmd.getField(fieldName);
    }

    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    public boolean isBaseDatastoreClass() {
        return true;
    }

    public boolean isObjectIDDatastoreAttributed() {
        return false;
    }

    public void delete(StateManager sm) {
        throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.OperationNotSupported", this.cmd.getFullClassName(), "delete()"));
    }

    public void deleteDependent(StateManager sm, AbstractPropertyMetaData[] fieldMetaData) {
        throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.OperationNotSupported", this.cmd.getFullClassName(), "deleteDependent()"));
    }

    public void fetch(StateManager sm, AbstractPropertyMetaData[] fieldMetaData) {
        throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.OperationNotSupported", this.cmd.getFullClassName(), "fetch()"));
    }

    public void insert(StateManager sm) {
        throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.OperationNotSupported", this.cmd.getFullClassName(), "insert()"));
    }

    public void locate(StateManager sm) {
        throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.OperationNotSupported", this.cmd.getFullClassName(), "locate()"));
    }

    public void update(StateManager sm, AbstractPropertyMetaData[] fieldMetaData) {
        throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.View.OperationNotSupported", this.cmd.getFullClassName(), "update()"));
    }

    public void provideDatastoreIdMappings(MappingConsumer consumer) {
    }

    public void provideDiscriminatorMappings(MappingConsumer consumer) {
    }

    public void provideMappingsForFields(MappingConsumer consumer, AbstractPropertyMetaData[] fieldNumbers, boolean includeSecondaryTables) {
    }

    public void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
    }

    public void providePrimaryKeyMappings(MappingConsumer consumer) {
    }

    public void provideVersionMappings(MappingConsumer consumer) {
    }

    public void provideExternalMappings(MappingConsumer consumer, int mappingType) {
    }

    public final synchronized Object newOID(PersistenceManager pm, PersistenceCapable pc) {
        if (this.nextHiValue < 0) {
            this.nextHiValue = 0;
            this.nextLoValue = 0;
        }
        OID id = OIDFactory.getInstance(this.cmd.getFullClassName(), new Long(this.nextLoValue));
        if ((long)this.nextLoValue == Long.MIN_VALUE) {
            this.nextLoValue = -1;
            this.nextHiValue = -1;
        } else {
            ++this.nextLoValue;
        }
        return id;
    }

    public String getType() {
        return this.cmd.getFullClassName();
    }

    public JavaTypeMapping getFieldMapping(AbstractPropertyMetaData fmd) {
        this.assertIsInitialized();
        JavaTypeMapping m = this.fieldMappings[fmd.getAbsoluteFieldNumber()];
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fmd.getAbsoluteFieldNumber());
        }
        return m;
    }

    public JavaTypeMapping getFieldMapping(String fieldName) {
        this.assertIsInitialized();
        int rfn = this.cmd.getFieldNumber(fieldName);
        if (rfn < 0) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fieldName);
        }
        return this.getFieldMapping(this.cmd.getManagedField(rfn));
    }

    protected List getSQLCreateStatements(Properties props) {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.createStatementDDL, ";");
        while (tokens.hasMoreTokens()) {
            stmts.add(tokens.nextToken());
        }
        return stmts;
    }

    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return null;
    }

    public JavaTypeMapping getDiscriminatorMapping() {
        return null;
    }

    public final VersionMetaData getVersionMetaData() {
        return null;
    }

    public JavaTypeMapping getVersionMapping() {
        return null;
    }

    public JavaTypeMapping getExternalMapping(AbstractPropertyMetaData fmd, int mappingType) {
        throw new JDOFatalInternalException("N/A");
    }

    public AbstractPropertyMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        throw new JDOFatalInternalException("N/A");
    }
}

