/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.table;

import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jdo.JDOFatalInternalException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.VersionMetaData;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.RDBMSStoreHelper;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.exceptions.DuplicateColumnNameException;
import org.jpox.store.rdbms.exceptions.MissingTableException;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.table.Table;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.SQLWarnings;

public abstract class AbstractTable
implements Table {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected final RDBMSManager storeMgr;
    protected final RDBMSAdapter dba;
    protected final DatastoreIdentifier identifier;
    protected int state = 0;
    protected List columns = new ArrayList();
    protected HashMap columnsByName = new HashMap();
    protected static FileWriter ddlDumpWriter = null;
    private String fullyQualifiedName;
    private final int hashCode;

    public AbstractTable(DatastoreIdentifier identifier, RDBMSManager storeMgr) {
        this.storeMgr = storeMgr;
        this.dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        this.identifier = identifier;
        this.hashCode = identifier.hashCode() ^ storeMgr.hashCode();
    }

    public boolean isInitialized() {
        return this.state >= 2;
    }

    public boolean isPKInitialized() {
        return this.state >= 1;
    }

    public boolean isValidated() {
        return this.state == 4;
    }

    public boolean isInitializedModified() {
        return this.state == 3;
    }

    public StoreManager getStoreManager() {
        return this.storeMgr;
    }

    public String getCatalogName() {
        return ((SQLIdentifier)this.identifier).getCatalogName();
    }

    public String getSchemaName() {
        return ((SQLIdentifier)this.identifier).getSchemaName();
    }

    public DatastoreIdentifier getIdentifier() {
        return this.identifier;
    }

    public synchronized DatastoreField addDatastoreField(String storedJavaType, DatastoreIdentifier name, JavaTypeMapping mapping, ExtendableMetaData colmd) {
        Column col;
        boolean duplicateName = false;
        if (this.hasColumnName(name) && colmd != null) {
            col = (Column)this.columnsByName.get(name);
            duplicateName = true;
            MetaData md = col.getColumnMetaData().getParent();
            while (!(md instanceof AbstractClassMetaData)) {
                md = md.getParent();
            }
            MetaData dupMd = colmd.getParent();
            while (!(dupMd instanceof AbstractClassMetaData)) {
                dupMd = dupMd.getParent();
            }
            if (((AbstractClassMetaData)md).getFullClassName().equals(((AbstractClassMetaData)dupMd).getFullClassName())) {
                throw new DuplicateColumnNameException(this.toString(), (Column)this.columnsByName.get(name), col);
            }
            if (!mapping.getClass().getName().equals(col.getMapping().getClass().getName())) {
                throw new DuplicateColumnNameException(this.toString(), (Column)this.columnsByName.get(name), col);
            }
            if (!storedJavaType.equals(col.getStoredJavaType())) {
                throw new DuplicateColumnNameException(this.toString(), (Column)this.columnsByName.get(name), col);
            }
        }
        col = new Column(this, storedJavaType, name, mapping, (ColumnMetaData)colmd);
        if (!duplicateName) {
            this.addColumnInternal(col);
        }
        if (this.isInitialized()) {
            this.state = 3;
        }
        return col;
    }

    public boolean hasDatastoreField(DatastoreIdentifier identifier) {
        return this.hasColumnName(identifier);
    }

    public DatastoreField[] getDatastoreFieldsMetaData() {
        return this.columns.toArray(new DatastoreField[this.columns.size()]);
    }

    public void create(Connection conn) throws SQLException {
        this.assertIsInitialized();
        if (JPOXLogger.RDBMS.isInfoEnabled()) {
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.Creating", this));
        }
        this.executeDdlStatementList(this.getSQLCreateStatements(null), conn);
    }

    public void drop(Connection conn) throws SQLException {
        this.assertIsInitialized();
        if (JPOXLogger.RDBMS.isInfoEnabled()) {
            JPOXLogger.RDBMS.info(LOCALISER.msg("RDBMS.Table.Dropping", this));
        }
        this.executeDdlStatementList(this.getSQLDropStatements(), conn);
    }

    public boolean exists(Connection conn, boolean auto_create) throws SQLException {
        this.assertIsInitialized();
        int tableType = RDBMSStoreHelper.getTableType(this.storeMgr, this, conn);
        if (tableType == -1 || this.allowDdlDump() && AbstractTable.isDumpingDdl()) {
            if (!auto_create) {
                throw new MissingTableException(this.getCatalogName(), this.getSchemaName(), this.toString());
            }
            this.create(conn);
            this.state = 4;
            return true;
        }
        return false;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractTable)) {
            return false;
        }
        AbstractTable t = (AbstractTable)obj;
        return this.getClass().equals(t.getClass()) && this.identifier.equals(t.identifier) && this.storeMgr.equals(t.storeMgr);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        if (this.fullyQualifiedName != null) {
            return this.fullyQualifiedName;
        }
        this.fullyQualifiedName = this.identifier.getFullyQualifiedName(false);
        return this.fullyQualifiedName;
    }

    public DatastoreIdentifier getDatastoreIdentifierFullyQualified() {
        String schema;
        String catalog = ((SQLIdentifier)this.identifier).getCatalogName();
        if (catalog != null) {
            catalog = JDBCUtils.getIdentifierNameStripped(catalog, this.dba);
        }
        if ((schema = ((SQLIdentifier)this.identifier).getSchemaName()) != null) {
            schema = JDBCUtils.getIdentifierNameStripped(schema, this.dba);
        }
        String table = this.identifier.getIdentifier();
        table = JDBCUtils.getIdentifierNameStripped(table, this.dba);
        SQLIdentifier di = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(table);
        di.setCatalogName(catalog);
        di.setSchemaName(schema);
        return di;
    }

    protected synchronized void addColumnInternal(Column col) {
        DatastoreIdentifier colName = col.getIdentifier();
        this.columns.add(col);
        this.columnsByName.put(colName, col);
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Table.NewColumn", col));
        }
    }

    protected boolean hasColumnName(DatastoreIdentifier colName) {
        return this.columnsByName.get(colName) != null;
    }

    protected abstract List getSQLCreateStatements(Properties var1);

    protected abstract List getSQLDropStatements();

    protected void assertIsPKUninitialized() {
        if (this.isPKInitialized()) {
            throw new IllegalStateException(LOCALISER.msg("RDBMS.Table.AlreadyInitialisedError", this));
        }
    }

    protected void assertIsUninitialized() {
        if (this.isInitialized()) {
            throw new IllegalStateException(LOCALISER.msg("RDBMS.Table.AlreadyInitialisedError", this));
        }
    }

    protected void assertIsInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(LOCALISER.msg("RDBMS.Table.UninitialisedError", this));
        }
    }

    protected void assertIsInitializedModified() {
        if (!this.isInitializedModified()) {
            throw new IllegalStateException(LOCALISER.msg("RDBMS.Table.UnmodifiedError", this));
        }
    }

    protected void assertIsPKInitialized() {
        if (!this.isPKInitialized()) {
            throw new IllegalStateException(LOCALISER.msg("RDBMS.Table.UninitialisedError", this));
        }
    }

    protected void assertIsValidated() {
        if (!this.isValidated()) {
            throw new IllegalStateException(LOCALISER.msg("RDBMS.Table.NotValidatedError", this));
        }
    }

    protected boolean allowDdlDump() {
        return true;
    }

    public static boolean isDumpingDdl() {
        return ddlDumpWriter != null;
    }

    public static void setDdlDumpWriter(FileWriter fileWriter) {
        ddlDumpWriter = fileWriter;
    }

    protected void executeDdlStatementList(List stmts, Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        String stmtText = null;
        try {
            Iterator i = stmts.iterator();
            while (i.hasNext()) {
                stmtText = (String)i.next();
                this.executeDdlStatement(stmt, stmtText);
            }
        }
        catch (SQLException sqe) {
            JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Table.Error", stmtText, sqe));
            throw sqe;
        }
        finally {
            stmt.close();
        }
    }

    protected void executeDdlStatement(Statement stmt, String stmtText) throws SQLException {
        if (ddlDumpWriter != null && this.allowDdlDump()) {
            try {
                ddlDumpWriter.write(stmtText + ";\n\n");
            }
            catch (IOException e) {
                JPOXLogger.RDBMS_DDL.error("error writing DDL into file", e);
            }
        } else {
            if (JPOXLogger.RDBMS_DDL.isDebugEnabled()) {
                JPOXLogger.RDBMS_DDL.debug(stmtText);
            }
            long startTime = System.currentTimeMillis();
            stmt.execute(stmtText);
            if (JPOXLogger.RDBMS_DDL.isDebugEnabled()) {
                JPOXLogger.RDBMS_DDL.debug(LOCALISER.msg("JDBC.Statement.ExecutionTime", System.currentTimeMillis() - startTime));
            }
        }
        SQLWarnings.log(stmt);
    }

    public DiscriminatorMetaData getDiscriminatorMetaData() {
        throw new JDOFatalInternalException("Discriminators of objects is not supported in this type of table");
    }

    public JavaTypeMapping getDiscriminatorMapping() {
        throw new JDOFatalInternalException("Discriminators of objects is not supported in this type of table");
    }

    public VersionMetaData getVersionMetaData() {
        throw new JDOFatalInternalException("Versioning of objects is not supported in this type of table");
    }

    public JavaTypeMapping getVersionMapping() {
        throw new JDOFatalInternalException("Versioning of objects is not supported in this type of table");
    }
}

