/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.sqlidentifier;

import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;

public class SQLIdentifier
implements DatastoreIdentifier {
    protected final DatastoreAdapter dba;
    protected final IdentifierFactory factory;
    protected String sqlIdentifier;
    protected String catalogName;
    protected String schemaName;
    private String toString;

    protected SQLIdentifier(IdentifierFactory factory, String sqlIdentifier) {
        this.dba = factory.getDatastoreAdapter();
        this.factory = factory;
        this.sqlIdentifier = this.toCase(sqlIdentifier);
    }

    protected String toCase(String sqlIdentifier) {
        if (this.factory.getIdentifierCase() == 2 || this.factory.getIdentifierCase() == 3) {
            return sqlIdentifier.toLowerCase();
        }
        if (this.factory.getIdentifierCase() == 0 || this.factory.getIdentifierCase() == 1) {
            return sqlIdentifier.toUpperCase();
        }
        return sqlIdentifier;
    }

    public String getIdentifier() {
        return this.sqlIdentifier;
    }

    public int hashCode() {
        return this.sqlIdentifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SQLIdentifier)) {
            return false;
        }
        SQLIdentifier id = (SQLIdentifier)obj;
        return !(!this.sqlIdentifier.equals(id.sqlIdentifier) || this.schemaName != null && id.schemaName != null && !this.schemaName.equals(id.schemaName) || this.catalogName != null && id.catalogName != null && !this.catalogName.equals(id.catalogName));
    }

    public String toString() {
        if (this.toString == null) {
            String identifierQuoteString = ((RDBMSAdapter)this.dba).getIdentifierQuoteString();
            this.toString = ((RDBMSAdapter)this.dba).isSQLKeyword(this.sqlIdentifier) ? identifierQuoteString + this.sqlIdentifier + identifierQuoteString : (this.factory.getIdentifierCase() == 3 || this.factory.getIdentifierCase() == 5 || this.factory.getIdentifierCase() == 1 ? identifierQuoteString + this.sqlIdentifier + identifierQuoteString : this.sqlIdentifier);
        }
        return this.toString;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public final String getFullyQualifiedName(boolean adapterCase) {
        boolean supportsCatalogName = ((RDBMSAdapter)this.dba).supportsCatalogsInTableDefinitions();
        boolean supportsSchemaName = ((RDBMSAdapter)this.dba).supportsSchemasInTableDefinitions();
        String separator = ((RDBMSAdapter)this.dba).getCatalogSeparator();
        StringBuffer name = new StringBuffer();
        if (supportsCatalogName && this.catalogName != null) {
            if (adapterCase) {
                name.append(this.factory.getIdentifierInAdapterCase(this.catalogName));
            } else {
                name.append(this.catalogName);
            }
            name.append(separator);
        }
        if (supportsSchemaName && this.schemaName != null) {
            if (adapterCase) {
                name.append(this.factory.getIdentifierInAdapterCase(this.schemaName));
            } else {
                name.append(this.schemaName);
            }
            name.append(separator);
        }
        if (adapterCase) {
            name.append(this.factory.getIdentifierInAdapterCase(this.toString()));
        } else {
            name.append(this.toString());
        }
        return name.toString();
    }
}

