/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.sqlidentifier;

import javax.jdo.JDOFatalInternalException;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.rdbms.sqlidentifier.ColumnIdentifier;
import org.jpox.store.rdbms.sqlidentifier.JPOXIdentifierFactory;

public class JPOX2IdentifierFactory
extends JPOXIdentifierFactory {
    public JPOX2IdentifierFactory(DatastoreAdapter dba, String defaultCatalog, String defaultSchema, String requiredCase, String wordSeparator, String tablePrefix, String tableSuffix) {
        super(dba, defaultCatalog, defaultSchema, requiredCase, wordSeparator, tablePrefix, tableSuffix);
    }

    public DatastoreIdentifier newJoinTableFieldIdentifier(AbstractPropertyMetaData ownerFmd, AbstractPropertyMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (destinationId != null) {
            return this.newDatastoreFieldIdentifier(destinationId.getIdentifier(), embedded, fieldRole);
        }
        String baseName = null;
        baseName = fieldRole == 3 ? "ELEMENT" : (fieldRole == 4 ? "ELEMENT" : (fieldRole == 5 ? "KEY" : (fieldRole == 6 ? "VALUE" : "UNKNOWN")));
        return this.newDatastoreFieldIdentifier(baseName);
    }

    public DatastoreIdentifier newForeignKeyFieldIdentifier(AbstractPropertyMetaData ownerFmd, DatastoreIdentifier destinationId, boolean embedded, int fieldRole) {
        if (fieldRole == 1) {
            return this.newDatastoreFieldIdentifier(ownerFmd.getName() + "." + destinationId.getIdentifier(), embedded, fieldRole);
        }
        if (fieldRole == 7) {
            return this.newDatastoreFieldIdentifier(ownerFmd.getName(), embedded, fieldRole);
        }
        throw new JDOFatalInternalException("DatastoreField role " + fieldRole + " not supported by this method");
    }

    public DatastoreIdentifier newVersionFieldIdentifier() {
        String name = "VERSION";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newIndexFieldIdentifier() {
        String name = "IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    public DatastoreIdentifier newAdapterIndexFieldIdentifier() {
        return this.newIndexFieldIdentifier();
    }

    public String generateIdentifierNameForJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (c >= 'A' && c <= 'Z' && this.identifierCase != 4 && this.identifierCase != 5) {
                s.append(c);
                continue;
            }
            if (c >= 'A' && c <= 'Z' && (this.identifierCase == 4 || this.identifierCase == 5)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && (this.identifierCase == 4 || this.identifierCase == 5)) {
                s.append(c);
                continue;
            }
            if (c >= 'a' && c <= 'z' && this.identifierCase != 4 && this.identifierCase != 5) {
                s.append((char)(c - 32));
                continue;
            }
            if (c >= '0' && c <= '9' || c == '_') {
                s.append(c);
                continue;
            }
            if (c == '.') {
                s.append(this.wordSeparator);
                continue;
            }
            String cval = "000" + Integer.toHexString(c);
            s.append(cval.substring(cval.length() - (c > '\u00ff' ? 4 : 2)));
        }
        while (s.length() > 0 && s.charAt(0) == '_') {
            s.deleteCharAt(0);
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("Illegal Java identifier: " + javaName);
        }
        return s.toString();
    }
}

