/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUnsupportedOptionException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.EmbeddedKeyPCMapping;
import org.jpox.store.mapping.EmbeddedValuePCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.scostore.BaseContainerStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.scostore.MapStore;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.SQLWarnings;

public class MapEntrySetStore
extends BaseContainerStore
implements SetStore {
    protected DatastoreContainerObject setTable;
    protected MapStore mapStore;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected String iteratorStmt;
    protected String sizeStmt;
    protected ClassLoaderResolver clr;
    ResultObjectFactory rof = null;
    static /* synthetic */ Class class$org$jpox$store$rdbms$scostore$MapEntrySetStore$EntryImpl;

    public MapEntrySetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager());
        this.setTable = mapTable;
        this.mapStore = mapStore;
        this.keyType = mapStore.getKeyType();
        this.valueType = mapStore.getValueType();
        this.ownerMapping = mapTable.getOwnerMapping();
        this.ownerFieldMetaData = mapTable.getOwnerFieldMetaData();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.kmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.keyType, clr);
        this.vmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.valueType, clr);
        this.clr = clr;
        this.initialize();
    }

    public MapEntrySetStore(DatastoreContainerObject valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore) {
        super(valueTable.getStoreManager());
        this.setTable = valueTable;
        this.mapStore = mapStore;
        this.keyType = mapStore.getKeyType();
        this.valueType = mapStore.getValueType();
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.valueMapping = valueMapping;
        this.initialize();
    }

    public boolean hasOrderMapping() {
        return false;
    }

    private void initialize() {
        if (this.keyMapping != null && this.valueMapping != null) {
            this.iteratorStmt = this.getIteratorStmt();
        }
        this.sizeStmt = this.getSizeStmt();
    }

    public boolean updateEmbeddedElement(StateManager sm, Object element, int fieldNumber, Object value) {
        return false;
    }

    private String getSizeStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT COUNT(*) FROM ");
        stmt.append(this.setTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.keyMapping != null) {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" IS NOT NULL");
            }
        }
        return stmt.toString();
    }

    private String getIteratorStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        if (this.keyMapping != null) {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
        }
        if (this.valueMapping != null) {
            for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
        }
        stmt.append(" FROM ");
        stmt.append(this.setTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.keyMapping != null) {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" IS NOT NULL");
            }
        }
        return stmt.toString();
    }

    public String getElementType() {
        return (class$org$jpox$store$rdbms$scostore$MapEntrySetStore$EntryImpl == null ? (class$org$jpox$store$rdbms$scostore$MapEntrySetStore$EntryImpl = MapEntrySetStore.class$("org.jpox.store.rdbms.scostore.MapEntrySetStore$EntryImpl")) : class$org$jpox$store$rdbms$scostore$MapEntrySetStore$EntryImpl).getName();
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean validateElementType(Object element) {
        return element instanceof Map.Entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager sm) {
        SetIterator iter;
        String stmt = null;
        if (this.keyMapping != null && this.valueMapping != null) {
            stmt = this.iteratorStmt;
        } else {
            QueryExpression expr = this.dba.newQueryStatement(this.setTable, this.clr);
            ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(expr, expr.getDefaultTableExpression());
            ScalarExpression ownerVal = this.ownerMapping.newLiteral(expr, sm.getObject());
            expr.andCondition(ownerExpr.eq(ownerVal), true);
            this.rof = this.newResultObjectFactory(sm, expr, true);
            stmt = expr.toStatementText(false).toString();
        }
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, stmt, false);
                try {
                    if (this.keyMapping != null && this.valueMapping != null) {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    }
                    ResultSet rs = this.storeMgr.executeStatementQuery(stmt, ps);
                    try {
                        iter = new SetIterator(sm, rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException("Iteration request failed: " + stmt, (Throwable)e);
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(StateManager sm) {
        int numRows;
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.sizeStmt, true);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    ResultSet rs = this.storeMgr.executeStatementQuery(this.sizeStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new JDODataStoreException("Size request returned no result row: " + this.sizeStmt);
                        }
                        numRows = rs.getInt(1);
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException("Size request failed: " + this.sizeStmt, (Throwable)e);
        }
        return numRows;
    }

    public boolean contains(StateManager sm, Object element) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        return this.mapStore.containsKey(sm, entry.getKey());
    }

    public boolean add(StateManager sm, Object element) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean addAll(StateManager sm, Collection elements) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean remove(StateManager sm, Object element) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        Object removed = this.mapStore.remove(sm, entry.getKey());
        return removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
    }

    public boolean removeAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        Iterator iter = elements.iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Object element = iter.next();
            Map.Entry entry = (Map.Entry)element;
            Object removed = this.mapStore.remove(sm, entry.getKey());
            modified = removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
        }
        return modified;
    }

    public void clear(StateManager sm) {
        this.mapStore.clear(sm);
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression expr, boolean useFetchPlan) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.entrySet()");
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getExistsSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collRangeVar) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getSizeSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collRangeVar) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.entrySet()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        throw new JDOUnsupportedOptionException("Cannot query sets obtained by Map.entrySet()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EntryImpl
    implements Map.Entry {
        private final StateManager sm;
        private final Object key;
        private final Object value;

        public EntryImpl(StateManager sm, Object key, Object value) {
            this.sm = sm;
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return MapEntrySetStore.this.mapStore.put(this.sm, this.key, value);
        }
    }

    private class SetIterator
    implements Iterator {
        private final StateManager sm;
        private final PersistenceManager pm;
        private final Iterator delegate;
        private Map.Entry lastElement = null;

        public SetIterator(StateManager sm, ResultSet rs) throws SQLException {
            this.sm = sm;
            this.pm = sm.getPersistenceManager();
            ArrayList<EntryImpl> results = new ArrayList<EntryImpl>();
            while (rs.next()) {
                int jdbcPosition = 1;
                Object key = null;
                Object value = null;
                int ownerFieldNum = -1;
                if (MapEntrySetStore.this.setTable instanceof JoinTable) {
                    ownerFieldNum = ((JoinTable)MapEntrySetStore.this.setTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                }
                key = MapEntrySetStore.this.keyMapping instanceof EmbeddedKeyPCMapping || MapEntrySetStore.this.keyMapping instanceof SerialisedPCMapping || MapEntrySetStore.this.keyMapping instanceof SerialisedReferenceMapping ? MapEntrySetStore.this.keyMapping.getObject(this.pm, rs, Mappings.getParametersIndex(jdbcPosition, MapEntrySetStore.this.keyMapping), sm, ownerFieldNum) : MapEntrySetStore.this.keyMapping.getObject(this.pm, rs, Mappings.getParametersIndex(jdbcPosition, MapEntrySetStore.this.keyMapping));
                value = MapEntrySetStore.this.valueMapping instanceof EmbeddedValuePCMapping || MapEntrySetStore.this.valueMapping instanceof SerialisedPCMapping || MapEntrySetStore.this.valueMapping instanceof SerialisedReferenceMapping ? MapEntrySetStore.this.valueMapping.getObject(this.pm, rs, Mappings.getParametersIndex(jdbcPosition, MapEntrySetStore.this.valueMapping), sm, ownerFieldNum) : MapEntrySetStore.this.valueMapping.getObject(this.pm, rs, Mappings.getParametersIndex(jdbcPosition += MapEntrySetStore.this.keyMapping.getNumberOfDatastoreFields(), MapEntrySetStore.this.valueMapping));
                results.add(new EntryImpl(sm, key, value));
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = (Map.Entry)this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            MapEntrySetStore.this.mapStore.remove(this.sm, this.lastElement.getKey());
            this.delegate.remove();
            this.lastElement = null;
        }
    }
}

