/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.MapMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.exceptions.ClassDefinitionException;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.SerialisedMapping;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractMapStore;
import org.jpox.store.rdbms.scostore.MapEntrySetStore;
import org.jpox.store.rdbms.scostore.MapKeySetStore;
import org.jpox.store.rdbms.scostore.MapValueSetStore;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.ClassUtils;

public class FKMapStore
extends AbstractMapStore {
    private final int ownerFieldNumber;
    private int keyFieldNumber = -1;
    private int valueFieldNumber = -1;
    private final String updateFkStmt;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;
    static /* synthetic */ Class class$javax$jdo$spi$PersistenceCapable;
    static /* synthetic */ Class class$org$jpox$store$mapping$SimpleDatastoreRepresentation;
    static /* synthetic */ Class class$java$lang$String;

    public FKMapStore(AbstractPropertyMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.ownerFieldMetaData = fmd;
        String ownerFieldName = fmd.getMappedBy();
        MapMetaData mmd = (MapMetaData)fmd.getContainer();
        if (mmd == null) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.MapMetaDataMissing", fmd.getFullFieldName()));
        }
        boolean keyStoredInValue = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() == null) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyValueMappedNotSpecified", fmd.getFullFieldName()));
        }
        this.keyType = mmd.getKeyType();
        this.valueType = mmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        if (keyStoredInValue && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = FKMapStore.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(valueClass)) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyStoredInValueButValueNotPC", fmd.getFullFieldName(), this.valueType));
        }
        if (!keyStoredInValue && !(class$javax$jdo$spi$PersistenceCapable == null ? (class$javax$jdo$spi$PersistenceCapable = FKMapStore.class$("javax.jdo.spi.PersistenceCapable")) : class$javax$jdo$spi$PersistenceCapable).isAssignableFrom(keyClass)) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueStoredInKeyButKeyNotPC", fmd.getFullFieldName(), this.keyType));
        }
        if (keyStoredInValue) {
            this.vmd = storeMgr.getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.vmd == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.ValueMetaDataNotFound", this.valueType, fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIDMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (ownerFieldName != null) {
                AbstractPropertyMetaData vofmd = this.vmd.getField(ownerFieldName);
                if (vofmd == null) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByNonExistent", fmd.getFullFieldName(), ownerFieldName, valueClass.getName()));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByTypeInvalid", fmd.getFullFieldName(), vofmd.getFullFieldName(), vofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.vmd.getFieldNumberAbsolute(ownerFieldName);
                this.ownerMapping = this.valueTable.getFieldMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.valueType, ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.valueType, vofmd.getTypeName(), fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.valueType));
                }
            }
            AbstractPropertyMetaData vkfmd = null;
            if ((fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldNotSpecified", valueClass.getName()));
            }
            String key_field_name = fmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null && (vkfmd = storeMgr.getMetaDataManager().getMetaDataForField(valueClass, clr, key_field_name)) == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldNotFound", valueClass.getName(), key_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldNotSpecified", fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.keyType, clr)) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseKeyFieldTypeIncompatible", fmd.getFullFieldName(), this.keyType, vkfmd.getType().getName()));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.vmd.getFieldNumberAbsolute(keyFieldName);
            this.keyMapping = this.valueTable.getFieldMapping(this.vmd.getManagedFieldAbsolute(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerKeyFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.valueType, keyFieldName));
            }
            if (!(class$org$jpox$store$mapping$SimpleDatastoreRepresentation == null ? (class$org$jpox$store$mapping$SimpleDatastoreRepresentation = FKMapStore.class$("org.jpox.store.mapping.SimpleDatastoreRepresentation")) : class$org$jpox$store$mapping$SimpleDatastoreRepresentation).isAssignableFrom(this.keyMapping.getClass())) {
                throw new JDOUserException("Invalid field type for map key field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = this.valueTable;
        } else {
            this.kmd = storeMgr.getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.kmd == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.KeyMetaDataNotFound", this.keyType, fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIDMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (ownerFieldName != null) {
                AbstractPropertyMetaData kofmd = this.kmd.getField(ownerFieldName);
                if (kofmd == null) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByNonExistent", fmd.getFullFieldName(), ownerFieldName, keyClass.getName()));
                }
                if (!ClassUtils.typesAreCompatible(kofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName(), clr)) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.MappedByTypeInvalid", fmd.getFullFieldName(), kofmd.getFullFieldName(), kofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.kmd.getFieldNumberAbsolute(ownerFieldName);
                this.ownerMapping = this.valueTable.getFieldMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.keyType, ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.keyType, kofmd.getTypeName(), fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.keyType));
                }
            }
            AbstractPropertyMetaData vkfmd = null;
            if ((fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldNotSpecified", keyClass.getName()));
            }
            String value_field_name = fmd.getValueMetaData().getMappedBy();
            if (value_field_name != null && (vkfmd = storeMgr.getMetaDataManager().getMetaDataForField(keyClass, clr, value_field_name)) == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldNotFound", keyClass.getName(), value_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldNotSpecified", fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible(vkfmd.getType(), this.valueType, clr)) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseValueFieldTypeIncompatible", fmd.getFullFieldName(), this.valueType, vkfmd.getType().getName()));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.kmd.getFieldNumberAbsolute(valueFieldName);
            this.valueMapping = this.valueTable.getFieldMapping(this.kmd.getManagedFieldAbsolute(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerValueFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.keyType, valueFieldName));
            }
            if (!(class$org$jpox$store$mapping$SimpleDatastoreRepresentation == null ? (class$org$jpox$store$mapping$SimpleDatastoreRepresentation = FKMapStore.class$("org.jpox.store.mapping.SimpleDatastoreRepresentation")) : class$org$jpox$store$mapping$SimpleDatastoreRepresentation).isAssignableFrom(this.valueMapping.getClass())) {
                throw new JDOUserException("Invalid field type for map value field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = this.valueTable;
        }
        this.initialiseStatements();
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        } else {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateValueFk(StateManager sm, Object value, Object owner) {
        boolean retval;
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(sm, value);
        PersistenceManager pm = sm.getPersistenceManager();
        try {
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        this.ownerMapping.setObject(pm, ps, Mappings.getParametersIndex(1, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateValueInStatement(pm, ps, value, jdbcPosition);
                    this.storeMgr.executeStatementUpdate(this.updateFkStmt, ps);
                    retval = true;
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateKeyFk(StateManager sm, Object key, Object owner) {
        boolean retval;
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(sm, key);
        PersistenceManager pm = sm.getPersistenceManager();
        try {
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        this.ownerMapping.setObject(pm, ps, Mappings.getParametersIndex(1, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateKeyInStatement(pm, ps, key, jdbcPosition);
                    this.storeMgr.executeStatementUpdate(this.updateFkStmt, ps);
                    retval = true;
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        ClassLoaderResolver clr = ownerSm.getPersistenceManager().getClassLoaderResolver();
        final Class valueCls = clr.classForName(this.valueType);
        QueryExpression stmt = null;
        if (this.valueTable.getDiscriminatorMetaData() != null && this.valueTable.getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (this.storeMgr.getPMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerFieldMetaData.getMap().getValueType()))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerFieldMetaData.getMap().getValueType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{valueCls}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
        } else {
            stmt = new UnionIteratorStatement(clr, valueCls, true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return FKMapStore.this.valueMapping;
                }

                public Class getType() {
                    return valueCls;
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return FKMapStore.this.valueTable;
                }

                public boolean useJoin() {
                    return false;
                }
            }).getQueryStatement();
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key).add(this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = FKMapStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr).newLiteral(stmt, "%"));
            stmt.andCondition(new BooleanExpression(keyExpr, ScalarExpression.OP_LIKE, keyVal), true);
        } else {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key);
            stmt.andCondition(keyExpr.eq(keyVal), true);
        }
        return stmt;
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(LOCALISER.msg("RDBMS.SCO.Map.NullValuesNotAllowed"));
        }
        super.validateValueType(clr, value);
    }

    protected void validateValueForWriting(StateManager sm, Object value) {
        super.validateValueForWriting(sm, value);
        if (value != null && !this.valuesAreEmbedded && !this.valuesAreSerialised && value instanceof PersistenceCapable) {
            PersistenceManager pm = sm.getPersistenceManager();
            pm.findStateManager((PersistenceCapable)value).flush();
        }
    }

    protected void validateKeyForWriting(StateManager sm, Object key) {
        super.validateKeyForWriting(sm, key);
        if (key != null && !this.keysAreEmbedded && !this.keysAreSerialised && key instanceof PersistenceCapable) {
            PersistenceManager pm = sm.getPersistenceManager();
            pm.findStateManager((PersistenceCapable)key).flush();
        }
    }

    public Object put(StateManager sm, final Object newKey, Object newValue) {
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(sm, newKey);
            this.validateValueType(sm.getPersistenceManager().getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(sm.getPersistenceManager().getClassLoaderResolver(), newKey);
            this.validateValueForWriting(sm, newValue);
        }
        Object oldValue = this.get(sm, newKey);
        if (oldValue != newValue) {
            if (this.vmd != null) {
                if (oldValue != null) {
                    this.removeValue(sm, newKey, oldValue);
                }
                PersistenceManager pm = sm.getPersistenceManager();
                PersistenceCapable pcNewValue = (PersistenceCapable)newValue;
                final PersistenceCapable newOwner = sm.getObject();
                if (pcNewValue.jdoIsPersistent()) {
                    if (pm != pcNewValue.jdoGetPersistenceManager()) {
                        throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValudInvalidWithDifferentPM"), pcNewValue.jdoGetObjectId());
                    }
                    StateManager vsm = pm.findStateManager(pcNewValue);
                    if (this.ownerFieldNumber >= 0) {
                        vsm.isLoaded(pcNewValue, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(pcNewValue, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateValueFk(sm, pcNewValue, newOwner);
                    }
                    vsm.isLoaded(pcNewValue, this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.setObjectField(pcNewValue, this.keyFieldNumber, oldKey, newKey);
                } else {
                    pm.makePersistentInternal(newValue, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceField(FKMapStore.this.keyFieldNumber, newKey);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlanImpl getFetchPlanForLoading() {
                            return null;
                        }
                    });
                    if (this.ownerFieldNumber < 0) {
                        this.updateValueFk(sm, pcNewValue, newOwner);
                    }
                }
            } else {
                PersistenceManager pm = sm.getPersistenceManager();
                PersistenceCapable pcNewKey = (PersistenceCapable)newKey;
                final PersistenceCapable newOwner = sm.getObject();
                if (pcNewKey.jdoIsPersistent()) {
                    if (pm != pcNewKey.jdoGetPersistenceManager()) {
                        throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteKeyInvalidWithDifferentPM"), pcNewKey.jdoGetObjectId());
                    }
                    StateManager vsm = pm.findStateManager(pcNewKey);
                    if (this.ownerFieldNumber >= 0) {
                        vsm.isLoaded(pcNewKey, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(pcNewKey, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                    vsm.isLoaded(pcNewKey, this.valueFieldNumber);
                    oldValue = vsm.provideField(this.valueFieldNumber);
                    vsm.setObjectField(pcNewKey, this.valueFieldNumber, oldValue, newValue);
                } else {
                    final Object newValueObj = newValue;
                    pm.makePersistentInternal(newKey, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceField(FKMapStore.this.valueFieldNumber, newValueObj);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlanImpl getFetchPlanForLoading() {
                            return null;
                        }
                    });
                    if (this.ownerFieldNumber < 0) {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                }
            }
        }
        if (this.ownerFieldMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getPersistenceManager().deletePersistent(oldValue);
        }
        return oldValue;
    }

    public Object remove(StateManager sm, Object key) {
        Object oldValue = this.get(sm, key);
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                this.removeValue(sm, key, oldValue);
            }
        } else {
            sm.getPersistenceManager().deletePersistent(key);
        }
        if (this.ownerFieldMetaData.getMap().isDependentKey()) {
            sm.getPersistenceManager().deletePersistent(key);
        }
        if (this.ownerFieldMetaData.getMap().isDependentValue()) {
            sm.getPersistenceManager().deletePersistent(oldValue);
        }
        return oldValue;
    }

    private void removeValue(StateManager sm, Object key, Object oldValue) {
        PersistenceManager pm = sm.getPersistenceManager();
        if (this.keyMapping.isNullable()) {
            PersistenceCapable pcOldValue = (PersistenceCapable)oldValue;
            StateManager vsm = pm.findStateManager(pcOldValue);
            vsm.setObjectField(pcOldValue, this.keyFieldNumber, key, null);
            vsm.replaceField(this.keyFieldNumber, null);
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.setObjectField(pcOldValue, this.ownerFieldNumber, oldOwner, null);
                vsm.replaceField(this.ownerFieldNumber, null);
            } else {
                this.updateValueFk(sm, pcOldValue, null);
            }
        } else {
            pm.deletePersistent(oldValue);
        }
    }

    public void clear(StateManager sm) {
        Iterator iter = this.keySetStore(sm.getPersistenceManager().getClassLoaderResolver()).iterator(sm);
        while (iter.hasNext()) {
            this.remove(sm, iter.next());
        }
    }

    public void clearKeyOfValue(StateManager sm, Object key, Object oldValue) {
        PersistenceManager pm = sm.getPersistenceManager();
        if (this.keyMapping.isNullable()) {
            PersistenceCapable pcOldValue = (PersistenceCapable)oldValue;
            StateManager vsm = pm.findStateManager(pcOldValue);
            if (!vsm.isDeleted(pcOldValue)) {
                vsm.setObjectField(pcOldValue, this.keyFieldNumber, key, null);
                vsm.replaceField(this.keyFieldNumber, null);
                vsm.makeDirty(this.keyFieldNumber);
            }
        } else {
            pm.deletePersistent(oldValue);
        }
    }

    public synchronized SetStore keySetStore(ClassLoaderResolver clr) {
        return this.keySetStore == null ? new MapKeySetStore(this.valueTable, this.ownerMapping, this.keyMapping, clr, this.ownerFieldMetaData) : this.keySetStore;
    }

    public synchronized SetStore valueSetStore(ClassLoaderResolver clr) {
        return this.valueSetStore == null ? new MapValueSetStore(this.valueTable, this.ownerMapping, this.valueMapping, this, clr, this.ownerFieldMetaData) : this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        return this.entrySetStore == null ? new MapEntrySetStore(this.valueTable, this.ownerMapping, this.keyMapping, this.valueMapping, this) : this.entrySetStore;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (!sm.getPersistenceManager().getClassLoaderResolver().isAssignableFrom(this.valueType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, candidateClass);
        }
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getPersistenceManager().getClassLoaderResolver());
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, sm.getPersistenceManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.valueMapping);
        return stmt;
    }

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapRangeVar, Class filteredKeyType, ScalarExpression kExpr, DatastoreIdentifier keyRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType.getName());
        }
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, te);
        DatastoreIdentifier containerRangeVar = mapRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = keyRangeVar;
        }
        stmt.newTableExpression(this.mapTable, containerRangeVar);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (!this.storeMgr.getPMFContext().getTypeManager().isSupportedType(filteredKeyType.getName())) {
            DatastoreClass filteredKeyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
            JavaTypeMapping keyTableID = filteredKeyTable.getIDMapping();
            stmt.newTableExpression(filteredKeyTable, keyRangeVar);
            ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            ScalarExpression keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyRangeVar));
            stmt.innerJoin(keyExpr, keyMapExpr, stmt.getTableExpression(keyRangeVar), true, true);
            return keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyRangeVar));
        }
        return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType.getName());
        }
        DatastoreClass filteredValueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredValueTable, valueRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = mapRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = valueRangeVar;
        }
        ScalarExpression ownerValueExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.valueTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerValueExpr), true);
        JavaTypeMapping valueTableID = filteredValueTable.getIDMapping();
        return valueTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyRangeVar, DatastoreIdentifier valueRangeVar) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredKeyType, keyExpr, keyRangeVar), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredValueType, valExpr, valueRangeVar)};
        return qclKeyValues;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

