/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.store.rdbms.scostore.AbstractListStore;
import org.jpox.util.JPOXLogger;

public class FKListStore
extends AbstractListStore {
    private final int ownerFieldNumber;
    private final String unsetStmt;
    private final String removeAtNullifyStmt;
    private final String clearNullifyStmt;
    private final String updateFkStmt;

    public FKListStore(AbstractPropertyMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.ownerFieldMetaData = fmd;
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.CollectionMetaDataMissing", fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (storeMgr.getPMFContext().getTypeManager().isReferenceType(element_class)) {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.ElementMetaDataNotFound", element_class.getName(), fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Collection.ElementWithSubclassTableWithMultipleTablesNotSupported", this.ownerFieldMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractPropertyMetaData eofmd = this.emd.getField(mappedByFieldName);
            if (eofmd == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.MappedByNonExistent", fmd.getFullFieldName(), mappedByFieldName, element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.MappedByTypeInvalid", fmd.getFullFieldName(), eofmd.getFullFieldName(), eofmd.getTypeName(), fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getFieldNumberAbsolute(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Collection.InverseOwnerMappedByFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType, ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.InverseOwnerMappedByFieldInvalidType", ownerFieldName, this.elementType, eofmd.getTypeName(), fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.Collection.InverseOwnerFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (this.orderMapping == null) {
            throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.List.InverseIndexFieldNotPresent", fmd.getAbstractClassMetaData().getFullClassName(), fmd.getName(), this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        this.listName = "inverseList";
        this.initialiseStatements();
        this.addStmt = null;
        this.removeAtNullifyStmt = this.getRemoveAtNullifyStmt();
        this.clearNullifyStmt = this.getClearNullifyStmt();
        this.updateFkStmt = this.getUpdateFkStmt();
        this.unsetStmt = this.getUnsetStmt();
    }

    protected String getSetStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected String getUnsetStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = NULL");
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append("=-1");
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = NULL");
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, -1);
        Object o = this.get(sm, index);
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.unsetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    jdbcPosition = this.populateOrderInStatement(pm, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
                    }
                    this.storeMgr.executeStatementUpdate(this.unsetStmt, ps);
                }
                finally {
                    ps.close();
                }
                PreparedStatement ps2 = this.storeMgr.getStatement(conn, this.setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, pm, ps2, jdbcPosition);
                    jdbcPosition = this.populateOrderInStatement(pm, ps2, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps2, jdbcPosition);
                    }
                    jdbcPosition = this.populateElementInStatement(pm, ps2, element, jdbcPosition);
                    this.storeMgr.executeStatementUpdate(this.setStmt, ps2);
                }
                finally {
                    ps2.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.SetRequestFailed", this.setStmt), (Throwable)e);
        }
        if (this.ownerFieldMetaData.getCollection().isDependentElement() && allowDependentField && o != null) {
            sm.getPersistenceManager().deletePersistent(o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        PersistenceManager pm = sm.getPersistenceManager();
        try {
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    }
                    if (owner == null) {
                        this.ownerMapping.setObject(pm, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateOrderInStatement(pm, ps, index, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
                    }
                    jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
                    this.storeMgr.executeStatementUpdate(this.updateFkStmt, ps);
                    retval = true;
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.UpdateFkRequestFailed", this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("?");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM, int start_index, int end_index) {
        ScalarExpression indexVal;
        ScalarExpression indexExpr;
        if (this.elementInfo == null) {
            return null;
        }
        final ClassLoaderResolver clr = ownerSM.getPersistenceManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        if (this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (this.storeMgr.getPMFContext().getTypeManager().isReferenceType(clr.classForName(this.ownerFieldMetaData.getCollection().getElementType()))) {
                String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(this.ownerFieldMetaData.getCollection().getElementType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, this.storeMgr, true).getQueryStatement();
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{clr.classForName(this.elementInfo[0].getClassName())}, true, this.storeMgr, true).getQueryStatement();
            }
            this.iterateUsingDiscriminator = true;
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                final int elementNo = i;
                QueryExpression subStmt = new UnionIteratorStatement(clr, clr.classForName(this.elementType), true, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                    public JavaTypeMapping getMapping() {
                        return FKListStore.this.elementMapping;
                    }

                    public Class getType() {
                        return clr.classForName(FKListStore.this.elementType);
                    }

                    public DatastoreContainerObject getDatastoreContainerObject() {
                        return FKListStore.this.elementInfo[elementNo].getDatastoreClass();
                    }

                    public boolean useJoin() {
                        return false;
                    }
                }).getQueryStatement();
                if (stmt == null) {
                    stmt = subStmt;
                    continue;
                }
                stmt.union(subStmt);
            }
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        boolean returning_range = false;
        if (start_index == -1 && end_index == -1) {
            returning_range = true;
        } else if (start_index == end_index && start_index >= 0) {
            indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
            indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
            stmt.andCondition(indexExpr.eq(indexVal), true);
        } else {
            returning_range = true;
            if (start_index >= 0) {
                indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                stmt.andCondition(indexExpr.gteq(indexVal), true);
            }
            if (end_index >= 0) {
                indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                indexVal = this.orderMapping.newLiteral(stmt, new Integer(end_index));
                stmt.andCondition(indexExpr.lt(indexVal), true);
            }
        }
        if (returning_range) {
            ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
            boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
            exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression()).getExpressionList().toArray();
            stmt.setOrdering(exprIndex, descendingOrder);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(StateManager sm, int startAt, boolean atEnd, Collection c, boolean initialising) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = 0;
        if (!initialising) {
            currentListSize = this.size(sm);
        }
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(sm, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                PersistenceManager pm = sm.getPersistenceManager();
                Connection conn = this.storeMgr.getConnection(pm, true, false);
                int shift = c.size();
                try {
                    PreparedStatement ps = this.storeMgr.getStatement(conn, this.shiftStmt, false);
                    try {
                        for (int i = currentListSize - 1; i >= startAt; --i) {
                            this.processShift(sm, ps, false, i, shift);
                        }
                    }
                    finally {
                        ps.close();
                    }
                }
                finally {
                    this.storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.shiftStmt), (Throwable)e);
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            elementIter = c.iterator();
            while (elementIter.hasNext()) {
                Object element = elementIter.next();
                this.updateElementFk(sm, element, sm.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    protected String getRemoveAtNullifyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("?");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(", ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=NULL");
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(", ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=-1");
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    public boolean remove(StateManager sm, Object element) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        int index = this.indexOf(sm, element);
        if (index == -1) {
            return false;
        }
        this.removeAt(sm, index);
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            sm.getPersistenceManager().deletePersistent(element);
        }
        return true;
    }

    protected void removeAt(StateManager sm, int index) {
        String stmt = this.removeAtStmt;
        if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.List.RemoveElementFromInverseNull"));
            stmt = this.removeAtNullifyStmt;
        } else {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.List.RemoveElementFromInverseDelete"));
        }
        this.internalRemoveAt(sm, index, stmt);
    }

    protected String getClearNullifyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("?");
        } else {
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(", ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=NULL");
        }
        for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(", ");
            stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=-1");
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(", ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append("=NULL");
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(" AND ");
                stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    protected String getSizeStmt() {
        return super.getSizeStmt();
    }

    protected String getContainsStmt() {
        return super.getContainsStmt();
    }

    protected String getClearStmt() {
        return super.getClearStmt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        if (this.ownerFieldMetaData.getCollection().isDependentElement()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDeleteDependent"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping.isNullable()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseNull"));
            deleteElements = false;
        } else {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.SCO.Collection.ClearElementsFromInverseDelete"));
            deleteElements = true;
        }
        if (deleteElements) {
            ownerSM.isLoaded(ownerSM.getObject(), this.ownerFieldMetaData.getAbsoluteFieldNumber());
            Collection value = (Collection)ownerSM.provideField(this.ownerFieldMetaData.getAbsoluteFieldNumber());
            if (value != null && !value.isEmpty()) {
                ownerSM.getPersistenceManager().deletePersistentAll(value.toArray());
            }
        } else {
            try {
                PersistenceManager pm = ownerSM.getPersistenceManager();
                Connection conn = this.storeMgr.getConnection(pm, true, false);
                try {
                    PreparedStatement ps = this.storeMgr.getStatement(conn, this.clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.populateOwnerInStatement(ownerSM, pm, ps, jdbcPosition);
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
                        }
                        this.storeMgr.executeStatementUpdate(this.clearNullifyStmt, ps);
                    }
                    finally {
                        ps.close();
                    }
                }
                finally {
                    this.storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.ClearRequestFailed", this.clearNullifyStmt), (Throwable)e);
            }
        }
    }

    protected boolean validateElementForWriting(StateManager sm, Object element, int index) {
        if (!this.validateElementType(sm.getPersistenceManager().getClassLoaderResolver(), element)) {
            throw new ClassCastException(LOCALISER.msg("RDBMS.SCO.Collection.ElementIsInvalid", element.getClass().getName(), this.elementType));
        }
        boolean inserted = false;
        if (element != null && !this.elementsAreEmbedded && !this.elementsAreSerialised) {
            PersistenceManager pm = sm.getPersistenceManager();
            final PersistenceCapable newOwner = sm.getObject();
            final StateManager ownerSM = sm;
            final int elementPosition = index;
            if (!JDOHelper.isPersistent((Object)element)) {
                boolean exists = false;
                if (JDOHelper.isDetached((Object)element)) {
                    try {
                        StateManager objSM;
                        Object obj = pm.getObjectById(((PersistenceCapable)element).jdoGetObjectId(), true, false, element.getClass().getName());
                        if (obj != null && (objSM = pm.findStateManager((PersistenceCapable)obj)) != null) {
                            pm.evictFromTransaction(objSM);
                        }
                        exists = true;
                    }
                    catch (JDOObjectNotFoundException onfe) {
                        exists = false;
                    }
                }
                if (!exists) {
                    pm.makePersistentInternal(element, new FieldValues(){

                        public void fetchFields(StateManager esm) {
                            boolean isPersistentInterface = FKListStore.this.storeMgr.getMetaDataManager().isPersistentInterface(FKListStore.this.elementType);
                            DatastoreClass elementTable = null;
                            elementTable = !isPersistentInterface ? FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.elementType, FKListStore.this.clr) : FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.storeMgr.getMetaDataManager().getImplementationNameForPersistentInterface(FKListStore.this.elementType), FKListStore.this.clr);
                            if (elementTable != null) {
                                JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerFieldMetaData, 5);
                                if (externalFKMapping != null) {
                                    esm.setExternalFieldValueForMapping(externalFKMapping, ownerSM.getObject());
                                }
                                if (FKListStore.this.relationDiscriminatorMapping != null) {
                                    esm.setExternalFieldValueForMapping(FKListStore.this.relationDiscriminatorMapping, FKListStore.this.relationDiscriminatorValue);
                                }
                                if (FKListStore.this.orderMapping != null && elementPosition >= 0) {
                                    if (FKListStore.this.ownerFieldMetaData.getOrderMetaData() != null && FKListStore.this.ownerFieldMetaData.getOrderMetaData().getMappedBy() != null) {
                                        Number indexValue = null;
                                        indexValue = FKListStore.this.orderMapping.getFieldMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || FKListStore.this.orderMapping.getFieldMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)new Long(elementPosition) : (Number)new Integer(elementPosition);
                                        esm.replaceField(FKListStore.this.orderMapping.getFieldMetaData().getAbsoluteFieldNumber(), indexValue);
                                    } else {
                                        esm.setExternalFieldValueForMapping(FKListStore.this.orderMapping, new Integer(elementPosition));
                                    }
                                }
                            }
                            if (FKListStore.this.ownerFieldNumber >= 0) {
                                esm.replaceField(FKListStore.this.ownerFieldNumber, newOwner);
                            }
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlanImpl getFetchPlanForLoading() {
                            return null;
                        }
                    });
                    StateManager elementSM = pm.findStateManager((PersistenceCapable)element);
                    if (elementSM != null) {
                        elementSM.flush();
                    }
                    inserted = true;
                }
            } else {
                PersistenceCapable pcElement = (PersistenceCapable)element;
                if (pm != pcElement.jdoGetPersistenceManager()) {
                    throw new JDOUserException(LOCALISER.msg("RDBMS.SCO.List.WriteInvalidWithDifferentPM"), pcElement.jdoGetObjectId());
                }
                StateManager esm = pm.findStateManager(pcElement);
                if (this.ownerFieldNumber >= 0) {
                    esm.isLoaded(pcElement, this.ownerFieldNumber);
                    Object oldOwner = esm.provideField(this.ownerFieldNumber);
                    esm.setObjectField(pcElement, this.ownerFieldNumber, oldOwner, newOwner);
                }
                esm.flush();
            }
        }
        return inserted;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass) {
        if (!sm.getPersistenceManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, sm.getPersistenceManager().getClassLoaderResolver());
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, sm.getPersistenceManager().getClassLoaderResolver());
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.elementMapping);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listRangeVar, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredElementTable, elementRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = listRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = elementRangeVar;
        }
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.containerTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

