/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalInternalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.CollectionMetaData;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.ReferenceMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.RDBMSTransaction;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.scostore.AbstractCollectionStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.scostore.SetStore;
import org.jpox.util.JPOXLogger;

abstract class AbstractSetStore
extends AbstractCollectionStore
implements SetStore {
    protected String setName;
    protected String addStmt;
    protected String removeStmt;

    protected AbstractSetStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    protected void initialiseStatements() {
        super.initialiseStatements();
        this.removeStmt = this.getRemoveStmt();
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator(StateManager ownerSM) {
        SetStoreIterator iter;
        QueryExpression stmt = this.getIteratorStatement(ownerSM);
        if (stmt == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull"));
        }
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        PersistenceManager pm = ownerSM.getPersistenceManager();
        RDBMSTransaction tx = (RDBMSTransaction)pm.currentTransaction();
        String statement = stmt.toStatementText(tx.useUpdateLockOnFetch()).toString();
        if (statement == null) {
            throw new JDOFatalInternalException(LOCALISER.msg("RDBMS.SCO.IteratorStatementIsNull"));
        }
        try {
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = stmt.toStatementText(tx.useUpdateLockOnFetch()).prepareStatement(pm, conn);
                try {
                    ResultSet rs = this.storeMgr.executeStatementQuery(statement, ps);
                    try {
                        iter = new SetStoreIterator(ownerSM, rs, rof);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.IteratorRequestFailed", statement), (Throwable)e);
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(StateManager sm, Object element) {
        this.validateElementForWriting(sm, element);
        boolean modified = false;
        PersistenceManager pm = sm.getPersistenceManager();
        try {
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            PreparedStatement ps = this.storeMgr.getStatement(conn, this.addStmt, false);
            try {
                int num = this.processAddStmt(sm, ps, false, element);
                if (num > 0) {
                    modified = true;
                }
            }
            finally {
                ps.close();
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.addStmt);
            JPOXLogger.RDBMS.error(msg);
            throw new JDODataStoreException(msg, (Throwable)e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        boolean batched = this.allowsBatching() && elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.validateElementForWriting(sm, iter.next());
        }
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            PreparedStatement ps = this.storeMgr.getStatement(conn, this.addStmt, false);
            try {
                iter = elements.iterator();
                Object element = null;
                while (iter.hasNext()) {
                    element = iter.next();
                    int num = this.processAddStmt(sm, ps, false, element);
                    if (num <= 0) continue;
                    modified = true;
                }
                if (batched) {
                    int[] num = this.storeMgr.executeStatementBatch(this.addStmt, ps);
                    if (num == null) {
                        modified = false;
                    } else {
                        for (int i = 0; i < num.length; ++i) {
                            if (num[i] <= 0) continue;
                            modified = true;
                        }
                    }
                }
            }
            finally {
                ps.close();
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            String msg = LOCALISER.msg("RDBMS.SCO.AddRequestFailed", this.addStmt);
            JPOXLogger.RDBMS.error(msg);
            throw new JDODataStoreException(msg, (Throwable)e);
        }
        return modified;
    }

    protected int processAddStmt(StateManager ownerSM, PreparedStatement ps, boolean batched, Object element) throws SQLException {
        int number = 0;
        PersistenceManager pm = ownerSM.getPersistenceManager();
        int jdbcPosition = 1;
        jdbcPosition = this.populateOwnerInStatement(ownerSM, pm, ps, jdbcPosition);
        jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
        if (this.relationDiscriminatorMapping != null) {
            jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
        }
        if (batched) {
            ps.addBatch();
            number = 1;
        } else {
            number = this.storeMgr.executeStatementUpdate(this.addStmt, ps);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(StateManager sm, Object element) {
        if (!this.validateElementForReading(sm, element)) {
            JPOXLogger.RDBMS.debug("AbstractSetStore::remove element=" + element + " doesn't exist in this Set.");
            return false;
        }
        boolean modified = false;
        PersistenceManager pm = sm.getPersistenceManager();
        try {
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.removeStmt, false);
                try {
                    int rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
                    }
                    modified = (rowsDeleted = this.storeMgr.executeStatementUpdate(this.removeStmt, ps)) == 1;
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            String msg = LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", this.removeStmt);
            JPOXLogger.RDBMS.error(msg);
            throw new JDODataStoreException(msg, (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerFieldMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement()) {
            pm.deletePersistent(element);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean batched = this.allowsBatching() && elements.size() > 1;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (this.validateElementForReading(sm, element)) continue;
            JPOXLogger.RDBMS.debug("AbstractSetStore::removeAll element=" + element + " doesn't exist in this Set.");
            return false;
        }
        boolean modified = false;
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, true, false);
            PreparedStatement ps = this.storeMgr.getStatement(conn, this.removeStmt, false);
            try {
                Object element = null;
                iter = elements.iterator();
                while (iter.hasNext()) {
                    element = iter.next();
                    int rowsDeleted = this.processRemoveStmt(sm, ps, batched, element);
                    if (rowsDeleted <= 0) continue;
                    modified = true;
                }
            }
            finally {
                ps.close();
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS.error(e);
            String msg = LOCALISER.msg("RDBMS.SCO.RemoveRequestFailed", this.removeStmt);
            JPOXLogger.RDBMS.error(msg);
            throw new JDODataStoreException(msg, (Throwable)e);
        }
        return modified;
    }

    protected int processRemoveStmt(StateManager ownerSM, PreparedStatement ps, boolean batched, Object element) throws SQLException {
        int number = 0;
        PersistenceManager pm = ownerSM.getPersistenceManager();
        int jdbcPosition = 1;
        jdbcPosition = this.populateOwnerInStatement(ownerSM, pm, ps, jdbcPosition);
        jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
        if (this.relationDiscriminatorMapping != null) {
            jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
        }
        if (batched) {
            ps.addBatch();
        } else {
            number = this.storeMgr.executeStatementUpdate(this.removeStmt, ps);
        }
        return number;
    }

    protected String getRemoveStmt() {
        int i;
        int i2;
        StringBuffer stmt = new StringBuffer();
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        stmt.append("DELETE FROM ");
        stmt.append(this.containerTable.toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        if (this.elementInfo != null && this.elementInfo[0].getDatastoreClass() != this.containerTable && this.elementInfo[0].getDiscriminatorMapping() != null) {
            joinedDiscrim = true;
            JavaTypeMapping elemIdMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
            stmt.append(" INNER JOIN ");
            stmt.append(((Object)this.elementInfo[0].getDatastoreClass()).toString()).append(" ").append(joinedElementAlias).append(" ON ");
            for (i2 = 0; i2 < this.elementMapping.getNumberOfDatastoreFields(); ++i2) {
                if (i2 > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(containerAlias).append(".");
                stmt.append(this.elementMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier());
                stmt.append("=");
                stmt.append(joinedElementAlias).append(".").append(elemIdMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier());
            }
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(containerAlias).append(".");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(containerAlias).append(".");
            stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            if (this.elementsAreSerialised) {
                stmt.append(" LIKE ");
            } else {
                stmt.append(" = ");
            }
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.elementInfo != null && this.elementInfo[0].getDiscriminatorMapping() != null) {
            JavaTypeMapping discrimMapping = this.elementInfo[0].getDiscriminatorMapping();
            for (i2 = 0; i2 < discrimMapping.getNumberOfDatastoreFields(); ++i2) {
                stmt.append(" AND ");
                if (joinedDiscrim) {
                    stmt.append(joinedElementAlias);
                } else {
                    stmt.append(containerAlias);
                }
                stmt.append(".");
                stmt.append(((Object)discrimMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(i2)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    private class SetStoreIterator
    implements Iterator {
        private final StateManager sm;
        private final PersistenceManager pm;
        private final Iterator delegate;
        private Object lastElement = null;

        public SetStoreIterator(StateManager sm, ResultSet rs, ResultObjectFactory rof) throws SQLException {
            this.sm = sm;
            this.pm = sm.getPersistenceManager();
            ArrayList<Object> results = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    Object nextElement;
                    int i;
                    int[] param;
                    if (AbstractSetStore.this.elementsAreEmbedded || AbstractSetStore.this.elementsAreSerialised) {
                        param = new int[AbstractSetStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        if (AbstractSetStore.this.elementMapping instanceof SerialisedPCMapping || AbstractSetStore.this.elementMapping instanceof SerialisedReferenceMapping || AbstractSetStore.this.elementMapping instanceof EmbeddedElementPCMapping) {
                            int ownerFieldNumber = -1;
                            if (AbstractSetStore.this.containerTable != null) {
                                ownerFieldNumber = ((JoinTable)AbstractSetStore.this.containerTable).getOwnerFieldMetaData().getAbsoluteFieldNumber();
                            }
                            nextElement = AbstractSetStore.this.elementMapping.getObject(this.pm, rs, param, sm, ownerFieldNumber);
                        } else {
                            nextElement = AbstractSetStore.this.elementMapping.getObject(this.pm, rs, param);
                        }
                    } else if (AbstractSetStore.this.elementMapping instanceof ReferenceMapping) {
                        param = new int[AbstractSetStore.this.elementMapping.getNumberOfDatastoreFields()];
                        for (i = 0; i < param.length; ++i) {
                            param[i] = i + 1;
                        }
                        nextElement = AbstractSetStore.this.elementMapping.getObject(this.pm, rs, param);
                    } else {
                        nextElement = rof.getObject(this.pm, rs, this.pm.getClassLoaderResolver().classForName(AbstractSetStore.this.elementType));
                    }
                    results.add(nextElement);
                }
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            AbstractSetStore.this.remove(this.sm, this.lastElement);
            this.delegate.remove();
            this.lastElement = null;
        }
    }
}

