/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.scostore;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.mapping.EmbeddedElementPCMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.scostore.ElementContainerStore;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.util.SQLWarnings;

public abstract class AbstractCollectionStore
extends ElementContainerStore {
    protected String containsStmt;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractCollectionStore(StoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    protected void initialiseStatements() {
        super.initialiseStatements();
        this.containsStmt = this.getContainsStmt();
    }

    protected String getUpdateEmbeddedElementStmt(JavaTypeMapping fieldMapping) {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)fieldMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)fieldMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)this.elementMapping;
        for (int i2 = 0; i2 < embeddedMapping.getNumberOfJavaTypeMappings(); ++i2) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i2);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                stmt.append(" AND ");
                stmt.append(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedElement(StateManager sm, Object element, int fieldNumber, Object value) {
        boolean modified = false;
        if (this.elementMapping != null && this.elementMapping instanceof EmbeddedElementPCMapping) {
            String fieldName = this.emd.getManagedFieldAbsolute(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedElementPCMapping)this.elementMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            String stmt = this.getUpdateEmbeddedElementStmt(fieldMapping);
            try {
                PersistenceManager pm = sm.getPersistenceManager();
                Connection conn = this.storeMgr.getConnection(pm, true, false);
                try {
                    PreparedStatement ps = this.storeMgr.getStatement(conn, stmt, false);
                    try {
                        int jdbcPosition = 1;
                        fieldMapping.setObject(pm, ps, Mappings.getParametersIndex(jdbcPosition, fieldMapping), value);
                        jdbcPosition += fieldMapping.getNumberOfDatastoreFields();
                        jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                        jdbcPosition = this.populateEmbeddedElementFieldsInStatement(sm, element, ps, jdbcPosition, (JoinTable)this.containerTable);
                        this.storeMgr.executeStatementUpdate(stmt, ps);
                        modified = true;
                    }
                    finally {
                        ps.close();
                    }
                }
                finally {
                    this.storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.AddRequestFailed", stmt), (Throwable)e);
            }
        }
        return modified;
    }

    protected String getContainsStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        String containerAlias = "THIS";
        String joinedElementAlias = "ELEM";
        stmt.append("SELECT ");
        for (int i2 = 0; i2 < this.ownerMapping.getNumberOfDatastoreFields(); ++i2) {
            if (i2 > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i2).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString()).append(" ").append(containerAlias);
        boolean joinedDiscrim = false;
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(containerAlias).append(".").append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(containerAlias).append(".").append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            if (this.elementsAreSerialised) {
                stmt.append(" LIKE ");
            } else {
                stmt.append(" = ");
            }
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        if (this.elementInfo != null && this.containerTable == this.elementInfo[0].getDatastoreClass() && this.elementInfo[0].getDiscriminatorMapping() != null) {
            JavaTypeMapping discrimMapping = this.elementInfo[0].getDiscriminatorMapping();
            for (int i3 = 0; i3 < discrimMapping.getNumberOfDatastoreFields(); ++i3) {
                stmt.append(" AND ");
                if (joinedDiscrim) {
                    stmt.append(joinedElementAlias);
                } else {
                    stmt.append(containerAlias);
                }
                stmt.append(".").append(((Object)discrimMapping.getDataStoreMapping(i3).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)discrimMapping.getDataStoreMapping(i3)).getUpdateInputParameter());
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            for (int i4 = 0; i4 < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i4) {
                stmt.append(" AND ");
                stmt.append(containerAlias).append(".").append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i4).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i4)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(StateManager sm, Object element) {
        boolean retval;
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        try {
            PersistenceManager pm = sm.getPersistenceManager();
            Connection conn = this.storeMgr.getConnection(pm, false, false);
            try {
                PreparedStatement ps = this.storeMgr.getStatement(conn, this.containsStmt, true);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.populateOwnerInStatement(sm, pm, ps, jdbcPosition);
                    jdbcPosition = this.populateElementInStatement(pm, ps, element, jdbcPosition);
                    if (this.elementInfo != null && this.elementInfo[0].getDiscriminatorMapping() != null && this.elementInfo[0].getDatastoreClass() == this.containerTable) {
                        jdbcPosition = this.populateElementDiscriminatorInStatement(pm, ps, jdbcPosition, false, this.elementInfo[0]);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.populateRelationDiscriminatorInStatement(pm, ps, jdbcPosition);
                    }
                    ResultSet rs = this.storeMgr.executeStatementQuery(this.containsStmt, ps);
                    try {
                        retval = rs.next();
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    ps.close();
                }
            }
            finally {
                this.storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.SCO.ContainsRequestFailed", this.containsStmt), (Throwable)e);
        }
        return retval;
    }

    public QueryExpression getExistsSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        stmt.select(collectionRangeVar, this.elementMapping);
        return stmt;
    }

    public QueryExpression getSizeSubquery(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionRangeVar) {
        QueryExpression stmt = this.dba.newQueryStatement(this.containerTable, collectionRangeVar, qs.getClassLoaderResolver());
        ScalarExpression ownerExpr = mapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerInCollectionExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(collectionRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerInCollectionExpr));
        JavaTypeMapping m = this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = AbstractCollectionStore.class$("java.lang.String")) : class$java$lang$String, this.storeMgr);
        StringLiteral lit = (StringLiteral)m.newLiteral(stmt, "COUNT(*)");
        lit.generateStatementWithoutQuotes();
        stmt.selectScalarExpression(lit);
        return stmt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

