/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOObjectNotFoundException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.FetchStatement;
import org.jpox.store.OID;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.RDBMSTransaction;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.fieldmanager.ResultSetGetter;
import org.jpox.store.rdbms.request.MappingStatementIndex;
import org.jpox.store.rdbms.request.Request;
import org.jpox.store.rdbms.table.ListTable;
import org.jpox.store.rdbms.table.SetTable;
import org.jpox.util.JPOXLogger;

public class FetchRequest
extends Request {
    private final MappingCallbacks[] callbacks;
    private FetchMappingConsumer consumer;
    private MappingStatementIndex mappingStatementIndex;
    private FetchStatement fetchStatement;
    private final AbstractPropertyMetaData[] fieldMetaData;
    private AbstractClassMetaData cmd;
    private String[] stmt = new String[2];
    static /* synthetic */ Class class$java$util$List;

    public FetchRequest(DatastoreClass table, AbstractPropertyMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(table);
        this.fieldMetaData = fieldMetaData;
        this.cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        this.mappingStatementIndex = new MappingStatementIndex();
        this.fetchStatement = new RDBMSFetchStatement(table);
        this.consumer = new FetchMappingConsumer(this.fetchStatement, clr);
        table.provideMappingsForFields(this.consumer, fieldMetaData, true);
        table.provideDatastoreIdMappings(this.consumer);
        table.provideDiscriminatorMappings(this.consumer);
        this.callbacks = this.consumer.getMappingCallbacks().toArray(new MappingCallbacks[this.consumer.getMappingCallbacks().size()]);
        if (this.consumer.getFieldsToBeReplaced().length > 0) {
            table.provideVersionMappings(this.consumer);
            table.providePrimaryKeyMappings(this.consumer);
        } else {
            this.fetchStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.fieldMetaData != null && JPOXLogger.JDO.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching class " + this.cmd.getFullClassName() + " fields [");
            for (int i = 0; i < this.fieldMetaData.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.fieldMetaData[i].getName());
            }
            str.append("] for object ").append(sm.getObjectId(sm.getObject()));
            str.append(" in table ").append(this.table);
            JPOXLogger.JDO.debug(str);
        }
        if (this.fetchStatement != null) {
            PersistenceManager pm = sm.getPersistenceManager();
            RDBMSManager storeMgr = (RDBMSManager)pm.getStoreManager();
            RDBMSTransaction tx = (RDBMSTransaction)pm.currentTransaction();
            if (this.stmt[tx.useUpdateLockOnFetch() ? 1 : 0] == null) {
                this.stmt[tx.useUpdateLockOnFetch() ? 1 : 0] = this.fetchStatement.toString(tx.useUpdateLockOnFetch());
            }
            try {
                Connection conn = storeMgr.getConnection(pm, false, false);
                try {
                    PreparedStatement ps = storeMgr.getStatement(conn, this.stmt[tx.useUpdateLockOnFetch() ? 1 : 0], true);
                    try {
                        if (sm.getInternalObjectId() instanceof OID) {
                            this.table.getDataStoreObjectIdMapping().setObject(pm, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else {
                            sm.provideFields(this.consumer.getPrimaryKeyFieldsToBeProvided(), new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), false));
                        }
                        ResultSet rs = storeMgr.executeStatementQuery(this.stmt[tx.useUpdateLockOnFetch() ? 1 : 0], ps);
                        try {
                            if (!rs.next()) {
                                JPOXLogger.RDBMS_SQL.warn(LOCALISER.msg("RDBMS.Manager.ObjectWithIdNotFound", sm.getInternalObjectId()));
                                throw new JDOObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                            sm.replaceFields(this.consumer.getFieldsToBeReplaced(), new ResultSetGetter(sm, rs, this.mappingStatementIndex.getFields()));
                            if (this.mappingStatementIndex.getVersion().getExpressionIndex() != null) {
                                Object datastoreVersion = this.table.getVersionMapping().getObject(pm, rs, this.mappingStatementIndex.getVersion().getExpressionIndex());
                                sm.setVersion(datastoreVersion);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        ps.close();
                    }
                }
                finally {
                    storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (SQLException e) {
                throw new JDODataStoreException("Fetch request failed: " + this.stmt[tx.useUpdateLockOnFetch() ? 1 : 0], (Throwable)e);
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].postFetch(sm);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FetchMappingConsumer
    implements MappingConsumer {
        private int paramIndex = 1;
        final FetchStatement fetchStmt;
        List ftbr = new ArrayList();
        List pkbp = new ArrayList();
        List mappingCallbacks = new ArrayList();
        boolean initialized = false;
        final ClassLoaderResolver clr;

        public FetchMappingConsumer(FetchStatement fetchStmt, ClassLoaderResolver clr) {
            this.fetchStmt = fetchStmt;
            this.clr = clr;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                FetchRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highestFieldNumber]);
                FetchRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            block23: {
                int[] expressionsIndex;
                block26: {
                    block24: {
                        DatastoreContainerObject joinTable;
                        int relationType;
                        block25: {
                            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(FetchRequest.this.cmd)) {
                                return;
                            }
                            if (!m.includeInFetchStatement()) break block23;
                            ((FetchRequest)FetchRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                            FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setMapping(m);
                            expressionsIndex = null;
                            if (m.getNumberOfDatastoreFields() != 0 || !(m instanceof PersistenceCapableMapping) && !(m instanceof InterfaceMapping)) break block24;
                            relationType = fmd.getRelationType(this.clr);
                            if (relationType != 2) break block25;
                            if (fmd.getMappedBy() != null) {
                                Class fieldType = fmd.getType();
                                String[] clsNames = fieldType.isInterface() ? FetchRequest.this.table.getStoreManager().getMetaDataManager().getClassesImplementingInterface(fieldType.getName(), this.clr) : new String[]{fieldType.getName()};
                                DatastoreClass relatedTable = FetchRequest.this.table.getStoreManager().getDatastoreClass(clsNames[0], this.clr);
                                JavaTypeMapping referenceMapping = relatedTable.getFieldMapping(fmd.getMappedBy());
                                JavaTypeMapping selectMapping = relatedTable.getIDMapping();
                                JavaTypeMapping refDiscrimMapping = relatedTable.getDiscriminatorMapping();
                                Object[] discrimValues = null;
                                JavaTypeMapping refTypeMapping = null;
                                expressionsIndex = new int[referenceMapping.getNumberOfDatastoreFields()];
                                if (refDiscrimMapping != null) {
                                    DiscriminatorStrategy strategy = fmd.getAbstractClassMetaData().getDiscriminatorStrategy();
                                    if (strategy == DiscriminatorStrategy.CLASS_NAME) {
                                        int i;
                                        HashSet<String> allclasses = new HashSet<String>();
                                        if (clsNames != null) {
                                            for (i = 0; i < clsNames.length; ++i) {
                                                allclasses.add(clsNames[i]);
                                            }
                                        }
                                        for (i = 0; i < clsNames.length; ++i) {
                                            HashSet subclasses = FetchRequest.this.table.getStoreManager().getSubClassesForClass(clsNames[i], true, this.clr);
                                            if (subclasses == null || subclasses.size() <= 0) continue;
                                            allclasses.addAll(subclasses);
                                        }
                                        discrimValues = allclasses.toArray();
                                    } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
                                        HashSet subclasses = FetchRequest.this.table.getStoreManager().getSubClassesForClass(fmd.getTypeName(), true, this.clr);
                                        if (subclasses != null && subclasses.size() > 0) {
                                            int valNo = 0;
                                            discrimValues = new Object[subclasses.size() + 1];
                                            discrimValues[valNo++] = fmd.getAbstractClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                                            Iterator subclassesIter = subclasses.iterator();
                                            while (subclassesIter.hasNext()) {
                                                String subclass = (String)subclassesIter.next();
                                                AbstractClassMetaData subclassCmd = FetchRequest.this.table.getStoreManager().getMetaDataManager().getMetaDataForClass(subclass, this.clr);
                                                discrimValues[valNo++] = subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                                            }
                                        } else {
                                            discrimValues = new Object[]{fmd.getAbstractClassMetaData().getMetaDataManager().getMetaDataForClass(fmd.getType(), this.clr).getInheritanceMetaData().getDiscriminatorMetaData().getValue()};
                                        }
                                    }
                                } else if (relatedTable != referenceMapping.getDataStoreMapping(0).getDatastoreField().getDatastoreContainerObject()) {
                                    refTypeMapping = relatedTable.getIDMapping();
                                }
                                expressionsIndex = refTypeMapping == null ? FetchRequest.this.fetchStatement.selectOuterJoin(referenceMapping, selectMapping, refDiscrimMapping, discrimValues) : FetchRequest.this.fetchStatement.selectOuterJoin(referenceMapping, selectMapping, refTypeMapping);
                            }
                            break block26;
                        }
                        if (relationType != 6) break block26;
                        AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(this.clr);
                        if (fmd.getJoinMetaData() == null && relatedFmd.getJoinMetaData() == null || (joinTable = FetchRequest.this.table.getStoreManager().getDatastoreContainerObject(relatedFmd)) == null) break block26;
                        JavaTypeMapping referenceMapping = null;
                        JavaTypeMapping selectMapping = null;
                        if ((class$java$util$List == null ? (class$java$util$List = FetchRequest.class$("java.util.List")) : class$java$util$List).isAssignableFrom(relatedFmd.getType())) {
                            ListTable listTable = (ListTable)joinTable;
                            referenceMapping = listTable.getElementMapping();
                            selectMapping = listTable.getOwnerMapping();
                        } else {
                            SetTable setTable = (SetTable)joinTable;
                            referenceMapping = setTable.getElementMapping();
                            selectMapping = setTable.getOwnerMapping();
                        }
                        expressionsIndex = new int[referenceMapping.getNumberOfDatastoreFields()];
                        expressionsIndex = FetchRequest.this.fetchStatement.selectOuterJoin(referenceMapping, selectMapping, null, null);
                        break block26;
                    }
                    expressionsIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int i = 0; i < expressionsIndex.length; ++i) {
                        expressionsIndex[i] = this.fetchStmt.select(m.getDataStoreMapping(i).getDatastoreField());
                    }
                }
                FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setExpressionIndex(expressionsIndex);
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                if (fmd.isPrimaryKey()) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField(m.getDataStoreMapping(j).getDatastoreField()) + "=?");
                        if (!this.pkbp.contains(abs_field_num)) {
                            this.pkbp.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                    FetchRequest.this.mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                } else if (!this.ftbr.contains(abs_field_num)) {
                    this.ftbr.add(abs_field_num);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mappingCallbacks.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                FetchRequest.this.mappingStatementIndex.getVersion().setMapping(FetchRequest.this.table.getVersionMapping());
                int[] expressionsIndex = new int[FetchRequest.this.table.getVersionMapping().getNumberOfDatastoreFields()];
                for (int j = 0; j < expressionsIndex.length; ++j) {
                    expressionsIndex[j] = this.fetchStmt.select(FetchRequest.this.table.getVersionMapping().getDataStoreMapping(j).getDatastoreField());
                }
                FetchRequest.this.mappingStatementIndex.getVersion().setExpressionIndex(expressionsIndex);
            } else if (mappingType == 2) {
                this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField((DatastoreField)FetchRequest.this.key.getColumns().get(0)) + "=?");
                int[] nArray = new int[]{this.paramIndex++};
                FetchRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(nArray);
            }
        }

        public List getMappingCallbacks() {
            return this.mappingCallbacks;
        }

        public int[] getFieldsToBeReplaced() {
            int[] fieldsToBeReplaced = new int[this.ftbr.size()];
            for (int i = 0; i < this.ftbr.size(); ++i) {
                fieldsToBeReplaced[i] = (Integer)this.ftbr.get(i);
            }
            return fieldsToBeReplaced;
        }

        public int[] getPrimaryKeyFieldsToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }
    }
}

