/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.request;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOOptimisticVerificationException;
import org.jpox.ClassLoaderResolver;
import org.jpox.PersistenceManager;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.VersionStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreField;
import org.jpox.store.OID;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingConsumer;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.VersionMapping;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.fieldmanager.ParameterSetter;
import org.jpox.store.rdbms.mapping.RDBMSMapping;
import org.jpox.store.rdbms.request.Request;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class DeleteRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final MappingCallbacks[] callbacks;
    private final String versionStmt;
    private final boolean versionChecks;
    private final String deleteStmt;
    private StatementExpressionIndex[] statementExpressionIndex;
    private final int[] pkfieldsToBeProvided;
    private final AbstractPropertyMetaData[] fieldsWithRelatedObjects;

    public DeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table);
        AbstractClassMetaData cmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(cls, clr);
        int paramIndex = 1;
        StringBuffer where = new StringBuffer();
        if (table.getIdentityType() == IdentityType.DATASTORE) {
            Iterator iterator = this.key.getColumns().iterator();
            where.append(((Object)((DatastoreField)iterator.next()).getIdentifier()).toString());
            where.append("=?");
            ++paramIndex;
        }
        DeleteMappingConsumer consumer = new DeleteMappingConsumer(clr, cmd, where, paramIndex);
        table.providePrimaryKeyMappings(consumer);
        table.provideDatastoreIdMappings(consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        this.pkfieldsToBeProvided = consumer.getPrimaryKeysToBeProvided();
        this.statementExpressionIndex = consumer.getStatementExpressionIndex();
        this.callbacks = consumer.getMappingCallBacks().toArray(new MappingCallbacks[consumer.getMappingCallBacks().size()]);
        this.fieldsWithRelatedObjects = consumer.getFieldsWithRelatedObjects();
        this.deleteStmt = "DELETE FROM " + ((Object)table).toString() + " WHERE " + where;
        this.versionStmt = table.getVersionMapping() != null ? "SELECT " + table.getVersionMapping().getDataStoreMapping(0).getDatastoreField() + " FROM " + ((Object)table).toString() + " WHERE " + where : null;
        this.versionChecks = table.getVersionMapping() != null && table.getVersionMetaData().getVersionStrategy() != VersionStrategy.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        int i;
        if (JPOXLogger.JDO.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Deleting object " + StringUtils.toJVMIDString(sm.getObject()) + " of type " + sm.getObject().getClass().getName() + " from table " + this.table);
            JPOXLogger.JDO.debug(str);
        }
        for (i = 0; i < this.callbacks.length; ++i) {
            this.callbacks[i].preDelete(sm);
        }
        if (this.fieldsWithRelatedObjects != null && this.fieldsWithRelatedObjects.length > 0) {
            for (i = 0; i < this.fieldsWithRelatedObjects.length; ++i) {
                AbstractPropertyMetaData relatedFmd = this.fieldsWithRelatedObjects[i];
                this.updateRelatedObjectsForField(sm, relatedFmd);
            }
        }
        PersistenceManager pm = sm.getPersistenceManager();
        RDBMSManager storeMgr = (RDBMSManager)pm.getStoreManager();
        try {
            Connection conn = storeMgr.getConnection(pm, true, false);
            try {
                int[] paramNumber;
                PreparedStatement ps;
                block25: {
                    if (pm.currentTransaction().getOptimistic() && this.versionStmt != null) {
                        ps = storeMgr.getStatement(conn, this.versionStmt, false);
                        try {
                            if (sm.getInternalObjectId() instanceof OID) {
                                paramNumber = new int[]{1};
                                this.table.getDataStoreObjectIdMapping().setObject(pm, ps, paramNumber, sm.getInternalObjectId());
                            } else {
                                sm.provideFields(this.pkfieldsToBeProvided, new ParameterSetter(sm, ps, this.statementExpressionIndex, false));
                            }
                            ResultSet rs = storeMgr.executeStatementQuery(this.versionStmt, ps);
                            try {
                                if (rs.next()) {
                                    Object datastoreVersion = this.table.getVersionMapping().getObject(pm, rs, new int[]{1});
                                    if (this.versionChecks && !((VersionMapping)this.table.getVersionMapping()).compareVersion(datastoreVersion, sm.getTransactionalVersion(sm.getObject()))) {
                                        String msg = LOCALISER.msg("RDBMS.Request.OptimisticVersionMismatch", sm.getInternalObjectId(), ((Object)this.table).toString(), datastoreVersion, sm.getTransactionalVersion(sm.getObject()));
                                        JPOXLogger.RDBMS.error(msg);
                                        throw new JDOOptimisticVerificationException(msg, (Object)sm.getObject());
                                    }
                                    break block25;
                                }
                                String msg = LOCALISER.msg("RDBMS.Request.OptimisticVersionMissing", sm.getInternalObjectId(), ((Object)this.table).toString());
                                JPOXLogger.RDBMS.error(msg);
                                throw new JDOOptimisticVerificationException(msg, (Object)sm.getObject());
                            }
                            finally {
                                rs.close();
                            }
                        }
                        finally {
                            ps.close();
                        }
                    }
                }
                ps = storeMgr.getStatement(conn, this.deleteStmt, false);
                try {
                    if (sm.getInternalObjectId() instanceof OID) {
                        paramNumber = new int[]{1};
                        this.table.getDataStoreObjectIdMapping().setObject(pm, ps, paramNumber, sm.getInternalObjectId());
                    } else {
                        sm.provideFields(this.pkfieldsToBeProvided, new ParameterSetter(sm, ps, this.statementExpressionIndex, false));
                    }
                    storeMgr.executeStatementUpdate(this.deleteStmt, ps);
                }
                finally {
                    ps.close();
                }
            }
            finally {
                storeMgr.releaseConnection(pm, conn);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException("Delete request failed: " + this.deleteStmt, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRelatedObjectsForField(StateManager sm, AbstractPropertyMetaData fmd) {
        AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(sm.getPersistenceManager().getClassLoaderResolver());
        String fullClassName = ((AbstractClassMetaData)relatedFmd.getParent()).getFullClassName();
        String[] classes = (AbstractClassMetaData)relatedFmd.getParent() instanceof InterfaceMetaData ? sm.getStoreManager().getMetaDataManager().getClassesImplementingInterface(fullClassName, sm.getPersistenceManager().getClassLoaderResolver()) : new String[]{fullClassName};
        HashSet<DatastoreClass> datastoreClasses = new HashSet<DatastoreClass>();
        for (int i = 0; i < classes.length; ++i) {
            datastoreClasses.add(sm.getStoreManager().getDatastoreClass(classes[i], sm.getPersistenceManager().getClassLoaderResolver()));
        }
        PersistenceManager pm = sm.getPersistenceManager();
        RDBMSManager storeMgr = (RDBMSManager)pm.getStoreManager();
        Iterator it = datastoreClasses.iterator();
        while (it.hasNext()) {
            int j;
            DatastoreClass refTable = (DatastoreClass)it.next();
            JavaTypeMapping refMapping = refTable.getFieldMapping(fmd.getMappedBy());
            if (!refMapping.isNullable()) continue;
            StringBuffer clearLinkStmt = new StringBuffer("UPDATE " + ((Object)refTable).toString() + " SET ");
            for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(",");
                }
                clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                clearLinkStmt.append("=NULL");
            }
            clearLinkStmt.append(" WHERE ");
            for (j = 0; j < refMapping.getNumberOfDatastoreFields(); ++j) {
                if (j > 0) {
                    clearLinkStmt.append(" AND ");
                }
                clearLinkStmt.append(refMapping.getDataStoreMapping(j).getDatastoreField().toString());
                clearLinkStmt.append("=?");
            }
            try {
                Connection conn = storeMgr.getConnection(pm, true, false);
                try {
                    Statement ps = null;
                    try {
                        ps = storeMgr.getStatement(conn, clearLinkStmt.toString(), false);
                        refMapping.setObject(pm, ps, Mappings.getParametersIndex(1, refMapping), sm.getObject());
                        storeMgr.executeStatementUpdate(clearLinkStmt.toString(), (PreparedStatement)ps);
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                finally {
                    storeMgr.releaseConnection(pm, conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new JDODataStoreException("Update request failed", (Throwable)e);
            }
        }
    }

    private class DeleteMappingConsumer
    implements MappingConsumer {
        private final StringBuffer where;
        private int paramIndex;
        private StatementExpressionIndex[] statementExpressionIndex;
        private List pkbp = new ArrayList();
        private List fwro = new ArrayList();
        private List mc = new ArrayList();
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public DeleteMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, StringBuffer where, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.where = where;
            this.paramIndex = initialParamIndex;
        }

        public void preConsumeMapping(int highestFieldNumberIndex) {
            if (this.statementExpressionIndex == null) {
                this.statementExpressionIndex = new StatementExpressionIndex[highestFieldNumberIndex];
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractPropertyMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (fmd.isPrimaryKey()) {
                    this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                    this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        this.where.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier());
                        this.where.append(" = ");
                        this.where.append(((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter());
                        this.pkbp.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        ++this.paramIndex;
                    }
                    this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                } else if (m.getNumberOfDatastoreFields() == 0 && (m instanceof PersistenceCapableMapping || m instanceof InterfaceMapping)) {
                    int relationType = fmd.getRelationType(this.clr);
                    if (relationType == 2) {
                        if (fmd.getMappedBy() != null) {
                            this.fwro.add(fmd);
                        }
                    } else if (relationType == 6) {
                        AbstractPropertyMetaData relatedFmd = fmd.getRelatedFieldMetaData(this.clr);
                        if (fmd.getJoinMetaData() != null || relatedFmd.getJoinMetaData() != null) {
                            // empty if block
                        }
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
        }

        public int[] getPrimaryKeysToBeProvided() {
            int[] pkfieldsToBeProvided = new int[this.pkbp.size()];
            for (int i = 0; i < this.pkbp.size(); ++i) {
                pkfieldsToBeProvided[i] = (Integer)this.pkbp.get(i);
            }
            return pkfieldsToBeProvided;
        }

        public AbstractPropertyMetaData[] getFieldsWithRelatedObjects() {
            AbstractPropertyMetaData[] fieldsWithRelatedObjects = new AbstractPropertyMetaData[this.fwro.size()];
            for (int i = 0; i < this.fwro.size(); ++i) {
                fieldsWithRelatedObjects[i] = (AbstractPropertyMetaData)this.fwro.get(i);
            }
            return fieldsWithRelatedObjects;
        }

        public List getMappingCallBacks() {
            return this.mc;
        }

        public StatementExpressionIndex[] getStatementExpressionIndex() {
            return this.statementExpressionIndex;
        }
    }
}

