/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.rdbms.query.QueryStatement;
import org.jpox.store.rdbms.query.StatementText;

public class SAPDBQueryStatement
extends QueryStatement {
    private int[] orderingColumnIndexes;

    public SAPDBQueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        super(initialTable, clr);
    }

    public SAPDBQueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier initialRangeVar, ClassLoaderResolver clr) {
        super(initialTable, initialRangeVar, clr);
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            orderByStmt = new StatementText();
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                if (i > 0) {
                    orderByStmt.append(',');
                }
                orderByStmt.append(Integer.toString(this.orderingColumnIndexes[i]));
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }

    protected void addOrderingColumnsToSelect() {
        if (this.orderingExpressions != null) {
            this.orderingColumnIndexes = new int[this.orderingExpressions.length];
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                this.selected.add(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION));
                this.orderingColumnIndexes[i] = this.selected.size();
                Iterator iterator = this.union.iterator();
                while (iterator.hasNext()) {
                    QueryStatement qs = (QueryStatement)iterator.next();
                    qs.selectScalarExpression(this.orderingExpressions[i]);
                }
            }
        }
    }
}

