/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.jdo.JDOUserException;
import org.jpox.ClassNameConstants;
import org.jpox.PersistenceManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class QueryUtils {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean resultClassIsUserType(String className) {
        return !QueryUtils.resultClassIsSimple(className) && !className.equals((class$java$util$Map == null ? (class$java$util$Map = QueryUtils.class$("java.util.Map")) : class$java$util$Map).getName()) && !className.equals((array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = QueryUtils.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).getName());
    }

    public static boolean resultClassIsSimple(String className) {
        return className.equals(ClassNameConstants.JAVA_LANG_BOOLEAN) || className.equals(ClassNameConstants.JAVA_LANG_BYTE) || className.equals(ClassNameConstants.JAVA_LANG_CHARACTER) || className.equals(ClassNameConstants.JAVA_LANG_DOUBLE) || className.equals(ClassNameConstants.JAVA_LANG_FLOAT) || className.equals(ClassNameConstants.JAVA_LANG_INTEGER) || className.equals(ClassNameConstants.JAVA_LANG_LONG) || className.equals(ClassNameConstants.JAVA_LANG_SHORT) || className.equals(ClassNameConstants.JAVA_LANG_STRING) || className.equals((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = QueryUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName()) || className.equals((class$java$math$BigInteger == null ? (class$java$math$BigInteger = QueryUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger).getName()) || className.equals((class$java$util$Date == null ? (class$java$util$Date = QueryUtils.class$("java.util.Date")) : class$java$util$Date).getName()) || className.equals((class$java$sql$Date == null ? (class$java$sql$Date = QueryUtils.class$("java.sql.Date")) : class$java$sql$Date).getName()) || className.equals((class$java$sql$Time == null ? (class$java$sql$Time = QueryUtils.class$("java.sql.Time")) : class$java$sql$Time).getName()) || className.equals((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = QueryUtils.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName()) || className.equals((class$java$lang$Object == null ? (class$java$lang$Object = QueryUtils.class$("java.lang.Object")) : class$java$lang$Object).getName());
    }

    public static Object createResultObjectUsingArgumentedConstructor(Class resultClass, Object[] fieldValues) {
        Object obj = null;
        Class[] ctrTypes = new Class[fieldValues.length];
        for (int i = 0; i < ctrTypes.length; ++i) {
            ctrTypes[i] = fieldValues[i] != null ? fieldValues[i].getClass() : null;
        }
        Constructor ctr = ClassUtils.getConstructorWithArguments(resultClass, ctrTypes);
        if (ctr != null) {
            try {
                obj = ctr.newInstance(fieldValues);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return obj;
    }

    public static Object createResultObjectUsingDefaultConstructorAndSetters(Class resultClass, String[] resultFieldNames, Map resultClassFieldNames, Object[] fieldValues) {
        Object obj = null;
        try {
            obj = resultClass.newInstance();
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("Query.ResultClassNotCreatable", resultClass.getName());
            JPOXLogger.JDO_QUERY.error(msg);
            throw new JDOUserException(msg);
        }
        for (int i = 0; i < fieldValues.length; ++i) {
            if (QueryUtils.setFieldForResultObject(resultClassFieldNames, obj, resultFieldNames[i], fieldValues[i])) continue;
            String msg = LOCALISER.msg("Query.ResultClassHasUnsettableField", resultClass.getName(), resultFieldNames[i], fieldValues[i].getClass().getName());
            JPOXLogger.JDO_QUERY.error(msg);
            throw new JDOUserException(msg);
        }
        return obj;
    }

    private static boolean setFieldForResultObject(Map resultClassFieldNames, Object obj, String fieldName, Object value) {
        Field field;
        boolean fieldSet = false;
        if (!fieldSet) {
            Field f;
            String declaredFieldName = fieldName;
            field = (Field)resultClassFieldNames.get(fieldName.toUpperCase());
            if (field != null) {
                declaredFieldName = field.getName();
            }
            if ((f = ClassUtils.getFieldForClass(obj.getClass(), declaredFieldName)) != null && Modifier.isPublic(f.getModifiers())) {
                try {
                    f.set(obj, value);
                    fieldSet = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fieldSet && JPOXLogger.JDO_QUERY.isDebugEnabled()) {
                JPOXLogger.JDO_QUERY.debug(LOCALISER.msg("Query.ResultClass.PublicFieldNotAvailable", obj.getClass().getName(), declaredFieldName));
            }
        }
        if (!fieldSet && value != null) {
            Method m;
            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            field = (Field)resultClassFieldNames.get(fieldName.toUpperCase());
            if (field != null) {
                setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + field.getName().substring(1);
            }
            if ((m = ClassUtils.getMethodWithArgument(obj.getClass(), setMethodName, value.getClass())) != null && Modifier.isPublic(m.getModifiers())) {
                try {
                    m.invoke(obj, value);
                    fieldSet = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fieldSet && JPOXLogger.JDO_QUERY.isDebugEnabled()) {
                JPOXLogger.JDO_QUERY.debug(LOCALISER.msg("Query.ResultClass.SetMethodNotAvailable", obj.getClass().getName(), setMethodName, value.getClass().getName()));
            }
        }
        if (!fieldSet) {
            Method m = QueryUtils.getPublicPutMethodForResultClass(obj.getClass());
            if (m != null) {
                try {
                    m.invoke(obj, fieldName, value);
                    fieldSet = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fieldSet && JPOXLogger.JDO_QUERY.isDebugEnabled()) {
                JPOXLogger.JDO_QUERY.debug(LOCALISER.msg("Query.ResultClass.PutMethodNotAvailable", obj.getClass().getName(), "put"));
            }
        }
        return fieldSet;
    }

    public static Method getPublicSetMethodForFieldOfResultClass(Class resultClass, String fieldName, Class fieldType) {
        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method m = ClassUtils.getMethodWithArgument(resultClass, setMethodName, fieldType);
        if (m != null && Modifier.isPublic(m.getModifiers())) {
            return m;
        }
        return null;
    }

    public static Method getPublicPutMethodForResultClass(Class resultClass) {
        String putMethodName = "put";
        Method m = ClassUtils.getMethodForClass(resultClass, putMethodName, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = QueryUtils.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = QueryUtils.class$("java.lang.Object")) : class$java$lang$Object});
        if (m != null && Modifier.isPublic(m.getModifiers())) {
            return m;
        }
        return null;
    }

    public static String[] getExpressionsFromString(String str) {
        StringCharacterIterator ci = new StringCharacterIterator(str);
        int braces = 0;
        String text = "";
        ArrayList<String> exprList = new ArrayList<String>();
        while (ci.getIndex() != ci.getEndIndex()) {
            char c = ci.current();
            if (c == ',' && braces == 0) {
                exprList.add(text);
                text = "";
            } else if (c == '(') {
                ++braces;
                text = text + c;
            } else if (c == ')') {
                --braces;
                text = text + c;
            } else {
                text = text + c;
            }
            ci.next();
        }
        exprList.add(text);
        return exprList.toArray(new String[exprList.size()]);
    }

    public static String getClassNameFromDiscriminatorResultSetRow(DatastoreClass table, ResultSet rs, PersistenceManager pm) {
        String rowClassName;
        block6: {
            rowClassName = null;
            JavaTypeMapping discriminatorMapping = table.getDiscriminatorMapping();
            DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
            if (discriminatorMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
                try {
                    String discriminatorColName = discriminatorMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifier();
                    String discriminatorValue = rs.getString(discriminatorColName);
                    if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                        rowClassName = discriminatorValue;
                        break block6;
                    }
                    if (dismd.getStrategy() != DiscriminatorStrategy.VALUE_MAP) break block6;
                    String className = table.getType();
                    if (dismd.getValue().equals(discriminatorValue)) {
                        rowClassName = className;
                        break block6;
                    }
                    Iterator iterator = pm.getStoreManager().getSubClassesForClass(table.getType(), true, pm.getClassLoaderResolver()).iterator();
                    while (iterator.hasNext()) {
                        className = (String)iterator.next();
                        AbstractClassMetaData classCmd = pm.getMetaDataManager().getMetaDataForClass(className, pm.getClassLoaderResolver());
                        if (!discriminatorValue.equals(classCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue())) continue;
                        rowClassName = className;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return rowClassName;
    }

    public static String getClassNameFromJPOXMetaDataResultSetRow(ResultSet rs) {
        try {
            return rs.getString("JPOXMETADATA").trim();
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

