/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalException;
import org.jpox.PersistenceManager;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.query.AbstractQueryResult;
import org.jpox.util.SQLWarnings;
import org.jpox.util.WeakValueMap;

public final class InsensitiveQueryResult
extends AbstractQueryResult
implements QueryResult,
Serializable {
    private final int size;
    private Map resultsObjsByIndex;

    public InsensitiveQueryResult(QueryExpression qs, Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) {
        block6: {
            int i;
            int fetchSize;
            block5: {
                super(qs, query, rof, rs);
                this.resultsObjsByIndex = new WeakValueMap();
                if (candidates != null) {
                    throw new JDOFatalException("Unsupported Feature: Candidate Collection is only allowed using ForwardQueryResults");
                }
                fetchSize = query.getFetchPlan().getFetchSize();
                try {
                    boolean hasLast = rs.last();
                    this.size = !hasLast ? 0 : rs.getRow();
                }
                catch (SQLException e) {
                    throw new JDODataStoreException(LOCALISER.msg("QueryResult.ReadError", e));
                }
                if (query.getPersistenceManager().currentTransaction().isActive() && !query.getPersistenceManager().currentTransaction().getOptimistic() && fetchSize != -1) break block5;
                for (i = 0; i < this.size; ++i) {
                    this.getObjectForIndex(i);
                }
                break block6;
            }
            if (fetchSize <= 0) break block6;
            for (i = 0; i < fetchSize; ++i) {
                this.getObjectForIndex(i);
            }
        }
    }

    protected Object getObjectForIndex(int index) {
        Object obj = this.resultsObjsByIndex.get("" + index);
        if (obj != null) {
            return obj;
        }
        try {
            this.rs.absolute(index + 1);
            obj = this.rof.getObject((PersistenceManager)this.query.getPersistenceManager(), this.rs, this.query.getCandidateClass());
            SQLWarnings.log(this.rs);
            this.resultsObjsByIndex.put("" + index, obj);
            return obj;
        }
        catch (SQLException sqe) {
            throw new JDODataStoreException(LOCALISER.msg("QueryResult.ReadError", sqe));
        }
    }

    public synchronized void close() {
        this.resultsObjsByIndex.clear();
        super.close();
    }

    public void closingConnection() {
        boolean loadAllResults = true;
        Object value = this.query.getExtension("org.jpox.query.loadResultsAtCommit");
        if (value != null && ((String)value).equalsIgnoreCase("false")) {
            loadAllResults = false;
        }
        if (loadAllResults) {
            for (int i = 0; i < this.size(); ++i) {
                this.getObjectForIndex(i);
            }
        }
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InsensitiveQueryResult)) {
            return false;
        }
        InsensitiveQueryResult other = (InsensitiveQueryResult)o;
        if (this.qs != null) {
            return other.qs == this.qs;
        }
        return other.query == this.query;
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        return this.getObjectForIndex(index);
    }

    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.size() < 1;
    }

    public synchronized int size() {
        this.assertIsOpen();
        return this.size;
    }

    private class QueryResultIterator
    implements ListIterator {
        private int iterRowNum = 0;

        public void add(Object obj) {
            throw new UnsupportedOperationException(AbstractQueryResult.LOCALISER.msg("QueryResult.NotModifiable"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            InsensitiveQueryResult insensitiveQueryResult = InsensitiveQueryResult.this;
            synchronized (insensitiveQueryResult) {
                if (!InsensitiveQueryResult.this.isOpen()) {
                    return false;
                }
                return this.iterRowNum <= InsensitiveQueryResult.this.size() - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            InsensitiveQueryResult insensitiveQueryResult = InsensitiveQueryResult.this;
            synchronized (insensitiveQueryResult) {
                if (!InsensitiveQueryResult.this.isOpen()) {
                    return false;
                }
                return this.iterRowNum > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            InsensitiveQueryResult insensitiveQueryResult = InsensitiveQueryResult.this;
            synchronized (insensitiveQueryResult) {
                if (!InsensitiveQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(AbstractQueryResult.LOCALISER.msg("QueryResult.Closed"));
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next element");
                }
                Object obj = InsensitiveQueryResult.this.getObjectForIndex(this.iterRowNum);
                ++this.iterRowNum;
                return obj;
            }
        }

        public int nextIndex() {
            if (this.hasNext()) {
                return this.iterRowNum;
            }
            return InsensitiveQueryResult.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            InsensitiveQueryResult insensitiveQueryResult = InsensitiveQueryResult.this;
            synchronized (insensitiveQueryResult) {
                if (!InsensitiveQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(AbstractQueryResult.LOCALISER.msg("QueryResult.Closed"));
                }
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous element");
                }
                --this.iterRowNum;
                return InsensitiveQueryResult.this.getObjectForIndex(this.iterRowNum);
            }
        }

        public int previousIndex() {
            if (this.iterRowNum == 0) {
                return -1;
            }
            return this.iterRowNum - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException(AbstractQueryResult.LOCALISER.msg("QueryResult.NotModifiable"));
        }

        public void set(Object obj) {
            throw new UnsupportedOperationException(AbstractQueryResult.LOCALISER.msg("QueryResult.NotModifiable"));
        }
    }
}

