/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOUserException;
import org.jpox.PersistenceManager;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.query.QueryResult;
import org.jpox.store.rdbms.query.AbstractQueryResult;
import org.jpox.store.rdbms.query.ForwardQueryResult;
import org.jpox.store.rdbms.query.InsensitiveQueryResult;
import org.jpox.store.rdbms.query.RDBMSQuery;
import org.jpox.store.rdbms.query.ResultClassROF;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class BaseSQLQuery
extends RDBMSQuery {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected final transient String sqlText;
    protected transient String jdbcSqlText = null;
    protected transient StatementExpressionIndex[] statementExpressionIndex;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public BaseSQLQuery(PersistenceManager pm, BaseSQLQuery query) {
        this(pm, query.sqlText);
    }

    public BaseSQLQuery(PersistenceManager pm, String sql_text) {
        super(pm);
        this.candidateClass = null;
        this.filter = null;
        this.imports = null;
        this.variables = null;
        this.parameters = null;
        this.ordering = null;
        if (sql_text == null) {
            throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.StatementNullError"));
        }
        this.sqlText = sql_text.trim();
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.jdbcSqlText = null;
        this.statementExpressionIndex = null;
    }

    protected boolean shouldReturnSingleRow() {
        return this.unique;
    }

    public void setCandidates(Extent pcs) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.CandidateExtentsInapplicableError"));
    }

    public void setCandidates(Collection pcs) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.CandidateCollectionsInapplicableError"));
    }

    public void setResult(String result) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.ResultInapplicableError"));
    }

    public void setRange(int fromIncl, int toExcl) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.RangeInapplicableError"));
    }

    public void setSubclasses(boolean subclasses) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.CandidateExtentsInapplicableError"));
    }

    public void setFilter(String filter) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.FilterStringsInapplicableError"));
    }

    public void declareVariables(String variables) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.VariablesInapplicableError"));
    }

    public void setGrouping(String grouping) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.GroupingNotExplicitError"));
    }

    public void setOrdering(String ordering) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.OrderingNotExplicitError"));
    }

    public void compile() {
        if (!this.isCompiled) {
            super.compile();
            this.generateQueryStatement();
            if (JPOXLogger.JDO_QUERY.isDebugEnabled()) {
                JPOXLogger.JDO_QUERY.debug(LOCALISER_RDBMS.msg("SQL.Statement.Summary", this.jdbcSqlText));
            }
            this.isCompiled = true;
        }
    }

    protected abstract void generateQueryStatement();

    public abstract Collection performExecute(Map var1);

    protected QueryResult getQueryResultForNoCandidateClass(ResultSet rs) throws SQLException {
        Class requiredResultClass = this.resultClass;
        int numberOfColumns = 0;
        String[] resultFieldNames = null;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            numberOfColumns = rsmd.getColumnCount();
            if (requiredResultClass == null) {
                requiredResultClass = numberOfColumns == 1 ? (class$java$lang$Object == null ? (class$java$lang$Object = BaseSQLQuery.class$("java.lang.Object")) : class$java$lang$Object) : (array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = BaseSQLQuery.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
            }
            resultFieldNames = new String[numberOfColumns];
            for (int i = 0; i < numberOfColumns; ++i) {
                resultFieldNames[i] = rsmd.getColumnName(i + 1);
            }
        }
        catch (SQLException sqe) {
            // empty catch block
        }
        AbstractQueryResult qr = null;
        qr = this.getResultSetType().equals("scroll-insensitive") ? new InsensitiveQueryResult(null, this, new ResultClassROF(requiredResultClass, resultFieldNames), rs, null) : new ForwardQueryResult(null, this, new ResultClassROF(requiredResultClass, resultFieldNames), rs, null);
        return qr;
    }

    protected long performDeletePersistentAll(Map parameters) {
        throw new JDOUserException(LOCALISER_RDBMS.msg("SQL.DeletePersistent.NotSupported"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

