/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.util.Localiser;

public final class DatastoreUUIDHexPoidGenerator
extends AbstractRDBMSPoidGenerator {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");

    public DatastoreUUIDHexPoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 10;
        if (this.properties != null && this.properties.get("key-cache-size") != null) {
            try {
                this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
            }
            catch (Exception e) {
                throw new PoidException(LOCALISER.msg("PoidGenerator.InvalidKeyCacheSize", this.properties.get("key-cache-size")));
            }
        }
    }

    protected synchronized PoidBlock reserveBlock(long size) {
        Statement ps = null;
        ResultSet rs = null;
        ArrayList<String> oid = new ArrayList<String>();
        try {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            RDBMSManager rdbmsMgr = (RDBMSManager)this.storeMgr;
            String stmt = dba.getSelectNewUUIDStmt();
            ps = rdbmsMgr.getStatement(this.connection, stmt, false);
            int i = 1;
            while ((long)i < size) {
                rs = rdbmsMgr.executeStatementQuery(stmt, (PreparedStatement)ps);
                if (rs.next()) {
                    String nextId = rs.getString(1);
                    oid.add(nextId);
                }
                ++i;
            }
            PoidBlock poidBlock = new PoidBlock(oid);
            return poidBlock;
        }
        catch (SQLException e) {
            throw new PoidException(LOCALISER.msg("PoidGenerator.IDAllocationError", e.getMessage()));
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {}
        }
    }
}

