/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping.oracle;

import javax.jdo.JDOFatalInternalException;
import org.jpox.StateManager;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.StringMapping;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.jpox.store.rdbms.mapping.oracle.OracleClobRDBMSMapping;

public class OracleStringMapping
extends StringMapping
implements MappingCallbacks {
    public void postInsert(StateManager sm) {
        String value = (String)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            value = "";
        } else if (value.length() == 0) {
            value = ((RDBMSAdapter)this.dba).getSurrogateForEmptyStrings();
        }
        if (this.fmd.getColumnMetaData()[0].getJdbcType().toUpperCase().equals("BLOB")) {
            OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDataStoreMapping(0), value.getBytes());
        } else if (this.fmd.getColumnMetaData()[0].getJdbcType().toUpperCase().equals("CLOB")) {
            OracleClobRDBMSMapping.updateClobColumn(sm, this.getDatastoreContainer(), this.getDataStoreMapping(0), value);
        } else {
            throw new JDOFatalInternalException("AssertionError: Only JDBC types BLOB and CLOB are allowed!");
        }
    }

    public void deleteDependent(StateManager sm) {
    }

    public void postFetch(StateManager sm) {
    }

    public void postUpdate(StateManager sm) {
        this.postInsert(sm);
    }

    public void preDelete(StateManager sm) {
    }
}

