/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class SmallIntRDBMSMapping
extends ColumnMapping {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;

    protected SmallIntRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public SmallIntRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                SmallIntRDBMSMapping.applyValidValuesToColumn(this.column, validValues);
            }
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(5);
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "boolean", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        try {
            int intValue = ((ResultSet)rs).getInt(param);
            if (intValue == 0) {
                value = false;
            } else if (intValue == 1) {
                value = true;
            } else {
                throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.IllegalValueForBooleanInColumn", "Types.SMALLINT", "" + intValue));
            }
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Boolean", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setShort(Object ps, int param, short value) {
        try {
            ((PreparedStatement)ps).setShort(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "short", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public short getShort(Object rs, int param) {
        short value;
        try {
            value = ((ResultSet)rs).getShort(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "short", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "int", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "int", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setByte(Object ps, int param, byte value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "byte", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public byte getByte(Object rs, int param) {
        byte value;
        try {
            value = ((ResultSet)rs).getByte(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "byte", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Integer) {
                ((PreparedStatement)ps).setShort(param, ((Integer)value).shortValue());
            } else if (value instanceof Short) {
                ((PreparedStatement)ps).setShort(param, (Short)value);
            } else if (value instanceof Byte) {
                ((PreparedStatement)ps).setShort(param, ((Byte)value).shortValue());
            } else if (value instanceof BigInteger) {
                ((PreparedStatement)ps).setInt(param, ((BigInteger)value).shortValue());
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        Number value;
        try {
            short d = ((ResultSet)rs).getShort(param);
            value = this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Integer == null ? (class$java$lang$Integer = SmallIntRDBMSMapping.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) ? (Number)(((ResultSet)rs).wasNull() ? null : new Integer(d)) : (Number)(this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Byte == null ? (class$java$lang$Byte = SmallIntRDBMSMapping.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) ? (Number)(((ResultSet)rs).wasNull() ? null : new Byte((byte)d)) : (Number)(((ResultSet)rs).wasNull() ? null : new Short(d)));
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

