/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalException;
import org.jpox.ClassLoaderResolver;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.ExtendableMetaData;
import org.jpox.metadata.NullValue;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.PluginManager;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.AbstractMappingManager;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.DatastoreMappingFactory;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.MultiMap;
import org.jpox.util.StringUtils;

public class RDBMSMappingManager
extends AbstractMappingManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    MultiMap datastoreMappingsByJavaType;
    MultiMap datastoreMappingsByJDBCType;
    MultiMap datastoreMappingsBySQLType;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;

    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr, String vendorId) {
        if (this.datastoreMappingsByJavaType != null) {
            return;
        }
        this.datastoreMappingsByJDBCType = new MultiMap();
        this.datastoreMappingsBySQLType = new MultiMap();
        this.datastoreMappingsByJavaType = new MultiMap();
        ExtensionPoint exPoint = mgr.getExtensionPoint("org.jpox.store_datastoremapping");
        for (int i = 0; i < exPoint.getExtensions().length; ++i) {
            ConfigurationElement[] elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (int e = 0; e < elms.length; ++e) {
                String javaName = elms[e].getAttribute("java-type").trim();
                String rdbmsMappingClassName = elms[e].getAttribute("rdbms-mapping-class");
                String jdbcType = elms[e].getAttribute("jdbc-type");
                String sqlType = elms[e].getAttribute("sql-type");
                String defaultJava = elms[e].getAttribute("default");
                String javaVersion = elms[e].getAttribute("java-version");
                String javaVersionRestricted = elms[e].getAttribute("java-version-restricted");
                boolean defaultForJavaType = false;
                if (defaultJava != null && defaultJava.equalsIgnoreCase("true")) {
                    defaultForJavaType = Boolean.TRUE;
                }
                boolean javaRestricted = false;
                if (javaVersionRestricted != null && javaVersionRestricted.equalsIgnoreCase("true")) {
                    javaRestricted = Boolean.TRUE;
                }
                if (javaVersion == null || javaVersion.length() < 1) {
                    javaVersion = "1.3";
                }
                if ((!JavaUtils.isGreaterEqualsThan(javaVersion) || javaRestricted) && (!JavaUtils.isEqualsThan(javaVersion) || !javaRestricted)) continue;
                Class mappingType = null;
                if (StringUtils.isWhitespace(rdbmsMappingClassName)) continue;
                try {
                    mappingType = mgr.loadClass(elms[e].getExtension().getPlugin().getId(), rdbmsMappingClassName);
                }
                catch (JDOException jdoe) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("Mapping.DatastoreMappingClassNotFound", rdbmsMappingClassName));
                }
                HashSet<String> includes = new HashSet<String>();
                HashSet<String> excludes = new HashSet<String>();
                ConfigurationElement[] childElm = elms[e].getChildren();
                for (int j = 0; j < childElm.length; ++j) {
                    if (childElm[j].getName().equals("includes")) {
                        includes.add(childElm[j].getAttribute("vendor-id"));
                        continue;
                    }
                    if (!childElm[j].getName().equals("excludes")) continue;
                    excludes.add(childElm[j].getAttribute("vendor-id"));
                }
                if (excludes.contains(vendorId) || !includes.isEmpty() && !includes.contains(vendorId)) continue;
                this.registerDatastoreMapping(javaName, mappingType, jdbcType, sqlType, defaultForJavaType);
            }
        }
    }

    public void registerDatastoreMapping(String javaTypeName, Class datastoreMappingType, String jdbcType, String sqlType, boolean dflt) {
        boolean mappingRequired = true;
        Collection coll = (Collection)this.datastoreMappingsByJavaType.get(javaTypeName);
        if (coll != null && coll.size() > 0) {
            Iterator collIter = coll.iterator();
            while (collIter.hasNext()) {
                RDBMSTypeMapping typeMapping = (RDBMSTypeMapping)collIter.next();
                if (typeMapping.getJdbcType().equals(jdbcType) && typeMapping.getSqlType().equals(sqlType)) {
                    mappingRequired = false;
                    if (typeMapping.isDefault() == dflt) continue;
                    typeMapping.setDefault(dflt);
                    continue;
                }
                if (!dflt) continue;
                typeMapping.setDefault(false);
            }
        }
        if (mappingRequired) {
            RDBMSTypeMapping mapping = new RDBMSTypeMapping(datastoreMappingType, dflt, javaTypeName, jdbcType, sqlType);
            this.datastoreMappingsByJDBCType.put(jdbcType, mapping);
            this.datastoreMappingsBySQLType.put(sqlType, mapping);
            this.datastoreMappingsByJavaType.put(javaTypeName, mapping);
        }
    }

    public void deregisterDatastoreMappingsForJDBCType(String jdbcTypeName) {
        Collection coll = (Collection)this.datastoreMappingsByJDBCType.get(jdbcTypeName);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet mappings = new HashSet(coll);
        Iterator iter = mappings.iterator();
        while (iter.hasNext()) {
            RDBMSTypeMapping mapping = (RDBMSTypeMapping)iter.next();
            this.datastoreMappingsByJavaType.remove(mapping.getJavaType(), mapping);
            this.datastoreMappingsBySQLType.remove(mapping.getSqlType(), mapping);
            this.datastoreMappingsByJDBCType.remove(mapping.getJdbcType(), mapping);
        }
    }

    protected Class getDatastoreMappingClass(String javaType, String jdbcType, String sqlType, ClassLoaderResolver clr) {
        AbstractMappingManager.TypeMapping datastoreMapping = null;
        if (sqlType != null) {
            if (this.datastoreMappingsBySQLType.get(sqlType.toUpperCase()) == null) {
                throw new JDOFatalException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownSQLTypeForJavaType", javaType, sqlType));
            }
            Iterator sqlTypeIter = ((Collection)this.datastoreMappingsBySQLType.get(sqlType.toUpperCase())).iterator();
            while (sqlTypeIter.hasNext()) {
                RDBMSTypeMapping sqlTypeMapping = (RDBMSTypeMapping)sqlTypeIter.next();
                if (!sqlTypeMapping.getJavaType().equals(javaType)) continue;
                datastoreMapping = sqlTypeMapping;
                break;
            }
        } else if (jdbcType != null) {
            if (this.datastoreMappingsByJDBCType.get(jdbcType.toUpperCase()) == null) {
                throw new JDOFatalException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownJDBCTypeForJavaType", javaType, jdbcType));
            }
            Iterator jdbcTypeIter = ((Collection)this.datastoreMappingsByJDBCType.get(jdbcType.toUpperCase())).iterator();
            while (jdbcTypeIter.hasNext()) {
                RDBMSTypeMapping jdbcTypeMapping = (RDBMSTypeMapping)jdbcTypeIter.next();
                if (!jdbcTypeMapping.getJavaType().equals(javaType)) continue;
                datastoreMapping = jdbcTypeMapping;
                break;
            }
        }
        if (datastoreMapping == null) {
            String type = ClassUtils.getWrapperTypeNameForPrimitiveTypeName(javaType);
            Collection mappings = (Collection)this.datastoreMappingsByJavaType.get(type);
            if (mappings == null) {
                Class javaTypeClass = clr.classForName(type);
                for (Class superClass = javaTypeClass.getSuperclass(); superClass != null && !superClass.getName().equals((class$java$lang$Object == null ? RDBMSMappingManager.class$("java.lang.Object") : class$java$lang$Object).getName()) && mappings == null; superClass = superClass.getSuperclass()) {
                    mappings = (Collection)this.datastoreMappingsByJavaType.get(superClass.getName());
                }
            }
            if (mappings != null) {
                if (mappings.size() == 1) {
                    datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                } else {
                    Iterator mappingsIter = mappings.iterator();
                    while (mappingsIter.hasNext()) {
                        RDBMSTypeMapping rdbmsMapping = (RDBMSTypeMapping)mappingsIter.next();
                        if (!rdbmsMapping.isDefault()) continue;
                        datastoreMapping = rdbmsMapping;
                        break;
                    }
                    if (datastoreMapping == null && mappings.size() > 0) {
                        datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                    }
                }
            }
        }
        if (datastoreMapping == null) {
            throw new JDOFatalException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnsupportedJavaType", javaType, jdbcType, sqlType));
        }
        return datastoreMapping.getMappingType();
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, AbstractPropertyMetaData fmd, int index, StoreManager storeMgr, DatastoreField column) {
        Class datastoreMappingClass = null;
        ClassLoaderResolver clr = storeMgr.getPMFContext().getClassLoaderResolver(null);
        if (fmd.getColumnMetaData().length > 0 && fmd.getColumnMetaData()[index].hasExtension("datastore-mapping-class")) {
            datastoreMappingClass = clr.classForName(fmd.getColumnMetaData()[index].getValueForExtension("datastore-mapping-class"));
        }
        if (datastoreMappingClass == null) {
            String javaType = mapping.getJavaTypeForDatastoreMapping(index);
            String jdbcType = null;
            String sqlType = null;
            if (fmd.getColumnMetaData().length > 0) {
                jdbcType = fmd.getColumnMetaData()[index].getJdbcType();
                sqlType = fmd.getColumnMetaData()[index].getSqlType();
            }
            if (fmd.isSerialized()) {
                javaType = (class$java$io$Serializable == null ? (class$java$io$Serializable = RDBMSMappingManager.class$("java.io.Serializable")) : class$java$io$Serializable).getName();
            }
            datastoreMappingClass = this.getDatastoreMappingClass(javaType, jdbcType, sqlType, clr);
        }
        return DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, storeMgr, column);
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField column, String javaType) {
        ClassLoaderResolver clr = storeMgr.getPMFContext().getClassLoaderResolver(null);
        Column col = (Column)column;
        String jdbcType = null;
        String sqlType = null;
        if (col != null && col.getColumnMetaData() != null) {
            jdbcType = col.getColumnMetaData().getJdbcType();
            sqlType = col.getColumnMetaData().getSqlType();
        }
        Class datastoreMappingClass = this.getDatastoreMappingClass(javaType, jdbcType, sqlType, clr);
        return DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, storeMgr, column);
    }

    public DatastoreField createDatastoreField(AbstractPropertyMetaData fmd, DatastoreContainerObject datastoreContainer, DatastoreAdapter dba, JavaTypeMapping mapping, String javaType, int datastoreFieldIndex) {
        ColumnMetaData colmd = null;
        if (fmd.getColumnMetaData().length > datastoreFieldIndex) {
            colmd = fmd.getColumnMetaData()[datastoreFieldIndex];
        } else {
            colmd = new ColumnMetaData((ExtendableMetaData)fmd, fmd.getColumn());
            fmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            identifier = idFactory.newIdentifier(1, fmd.getName());
            int i = 0;
            while (datastoreContainer.hasDatastoreField(identifier)) {
                identifier = idFactory.newIdentifier(1, fmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getIdentifier());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(fmd.getColumnMetaData()[datastoreFieldIndex].getName(), datastoreContainer.getStoreManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1);
        }
        Column col = (Column)datastoreContainer.addDatastoreField(javaType, identifier, mapping, colmd);
        if (fmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (datastoreContainer.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy()) && datastoreContainer instanceof DatastoreClass && (fmd.isPrimaryKey() && ((DatastoreClass)datastoreContainer).isBaseDatastoreClass() || !fmd.isPrimaryKey())) {
            col.setAutoIncrement(true);
        }
        if (fmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("select-function"), 0);
        }
        if (fmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("insert-function"), 1);
        }
        if (fmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("update-function"), 2);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    public DatastoreField createDatastoreField(AbstractPropertyMetaData fmd, DatastoreContainerObject datastoreContainer, DatastoreAdapter dba, JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        Column col;
        if (colmd == null) {
            colmd = new ColumnMetaData((ExtendableMetaData)fmd, fmd.getColumn());
            fmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        if (colmd.getName() == null) {
            DatastoreIdentifier identifier = idFactory.newIdentifier(1, fmd.getName());
            int i = 0;
            while (datastoreContainer.hasDatastoreField(identifier)) {
                identifier = idFactory.newIdentifier(1, fmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getIdentifier());
            col = (Column)datastoreContainer.addDatastoreField(javaType, identifier, mapping, colmd);
        } else {
            col = (Column)datastoreContainer.addDatastoreField(javaType, idFactory.newDatastoreFieldIdentifier(colmd.getName(), datastoreContainer.getStoreManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1), mapping, colmd);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    public DatastoreField createDatastoreField(AbstractPropertyMetaData fmd, DatastoreContainerObject datastoreContainer, DatastoreAdapter dba, JavaTypeMapping mapping, ColumnMetaData colmd, DatastoreField reference, ClassLoaderResolver clr) {
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            identifier = ((RDBMSIdentifierFactory)idFactory).newForeignKeyFieldIdentifier(fmd.getRelatedFieldMetaData(clr), fmd, reference.getIdentifier(), datastoreContainer.getStoreManager().getPMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), 1);
            colmd.setName(identifier.getIdentifier());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmd.getName(), false, -1);
        }
        Column col = (Column)datastoreContainer.addDatastoreField(fmd.getType().getName(), identifier, mapping, colmd);
        reference.copyConfigurationTo(col);
        if (fmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (datastoreContainer.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy()) && (fmd.isPrimaryKey() && ((DatastoreClass)datastoreContainer).isBaseDatastoreClass() || !fmd.isPrimaryKey())) {
            col.setAutoIncrement(true);
        }
        if (fmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("select-function"), 0);
        }
        if (fmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("insert-function"), 1);
        }
        if (fmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("update-function"), 2);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    private void setDatastoreFieldNullability(AbstractPropertyMetaData fmd, ColumnMetaData colmd, DatastoreField field) {
        if (colmd != null && !colmd.isAllowsNullSet()) {
            if (fmd.isPrimaryKey()) {
                colmd.setAllowsNull(new Boolean(false));
            } else if (!fmd.getType().isPrimitive() && fmd.getNullValue() != NullValue.EXCEPTION) {
                colmd.setAllowsNull(new Boolean(true));
            } else {
                colmd.setAllowsNull(new Boolean(false));
            }
            if (colmd.isAllowsNull()) {
                field.setNullable();
            }
        } else if (colmd != null && colmd.isAllowsNullSet()) {
            if (colmd.isAllowsNull()) {
                field.setNullable();
            }
        } else if (!fmd.isPrimaryKey() && !fmd.getType().isPrimitive() && fmd.getNullValue() != NullValue.EXCEPTION) {
            field.setNullable();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RDBMSTypeMapping
    extends AbstractMappingManager.TypeMapping {
        private String javaType;
        private String jdbcType;
        private String sqlType;

        public RDBMSTypeMapping(Class mappingType, boolean isDefault, String javaType, String jdbcType, String sqlType) {
            super(mappingType, isDefault);
            this.javaType = javaType;
            this.jdbcType = jdbcType;
            this.sqlType = sqlType;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getJdbcType() {
            return this.jdbcType;
        }

        public String getSqlType() {
            return this.sqlType;
        }
    }
}

