/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import javax.jdo.JDOFatalInternalException;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.Localiser;

public abstract class RDBMSMapping
implements DatastoreMapping {
    protected static final Localiser LOCALISER_STORE = Localiser.getInstance("org.jpox.store.Localisation");
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected final StoreManager storeMgr;
    protected final JavaTypeMapping mapping;

    protected RDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        this.storeMgr = storeMgr;
        this.mapping = mapping;
        mapping.addDataStoreMapping(this);
    }

    protected RDBMSAdapter getDatabaseAdapter() {
        return (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.mapping;
    }

    protected static void applyValidValuesToColumn(Column column, Object[] validValues) {
        StringBuffer constraints = new StringBuffer("CHECK (");
        constraints.append(column.getIdentifier());
        constraints.append(" IN (");
        for (int i = 0; i < validValues.length; ++i) {
            if (i > 0) {
                constraints.append(",");
            }
            constraints.append(validValues[i]);
        }
        constraints.append(")");
        if (column.isNullable()) {
            constraints.append(" OR " + column.getIdentifier() + " IS NULL");
        }
        constraints.append(")");
        column.setConstraints(constraints.toString());
    }

    public abstract TypeInfo getTypeInfo();

    public abstract boolean isNullable();

    public abstract boolean includeInFetchStatement();

    public abstract String getInsertionInputParameter();

    public abstract String getUpdateInputParameter();

    protected String failureMessage(String method) {
        return LOCALISER_STORE.msg("Mapping.FailureMessage", this.getClass().getName(), method);
    }

    public void setBoolean(Object preparedStatement, int exprIndex, boolean value) {
        throw new JDOFatalInternalException(this.failureMessage("setBoolean"));
    }

    public boolean getBoolean(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getBoolean"));
    }

    public void setChar(Object preparedStatement, int exprIndex, char value) {
        throw new JDOFatalInternalException(this.failureMessage("setChar"));
    }

    public char getChar(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getChar"));
    }

    public void setByte(Object preparedStatement, int exprIndex, byte value) {
        throw new JDOFatalInternalException(this.failureMessage("setByte"));
    }

    public byte getByte(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getByte"));
    }

    public void setShort(Object preparedStatement, int exprIndex, short value) {
        throw new JDOFatalInternalException(this.failureMessage("setShort"));
    }

    public short getShort(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getShort"));
    }

    public void setInt(Object preparedStatement, int exprIndex, int value) {
        throw new JDOFatalInternalException(this.failureMessage("setInt"));
    }

    public int getInt(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getInt"));
    }

    public void setLong(Object preparedStatement, int exprIndex, long value) {
        throw new JDOFatalInternalException(this.failureMessage("setLong"));
    }

    public long getLong(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getLong"));
    }

    public void setFloat(Object preparedStatement, int exprIndex, float value) {
        throw new JDOFatalInternalException(this.failureMessage("setFloat"));
    }

    public float getFloat(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getFloat"));
    }

    public void setDouble(Object preparedStatement, int exprIndex, double value) {
        throw new JDOFatalInternalException(this.failureMessage("setDouble"));
    }

    public double getDouble(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getDouble"));
    }

    public void setString(Object preparedStatement, int exprIndex, String value) {
        throw new JDOFatalInternalException(this.failureMessage("setString" + this.mapping.getFieldMetaData().getFullFieldName()));
    }

    public String getString(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getString"));
    }

    public void setObject(Object preparedStatement, int exprIndex, Object value) {
        throw new JDOFatalInternalException(this.failureMessage("setObject"));
    }

    public Object getObject(Object resultSet, int exprIndex) {
        throw new JDOFatalInternalException(this.failureMessage("getObject"));
    }
}

