/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class LongVarcharRDBMSMapping
extends ColumnMapping {
    protected LongVarcharRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public LongVarcharRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(-1);
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else {
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "String", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            value = ((ResultSet)rs).getString(param);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "String", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else {
                ((PreparedStatement)ps).setString(param, (String)value);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        String value;
        try {
            String s = ((ResultSet)rs).getString(param);
            value = ((ResultSet)rs).wasNull() ? null : s;
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

