/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jdo.JDODataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class DoubleRDBMSMapping
extends ColumnMapping {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;

    protected DoubleRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public DoubleRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(8);
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "int", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = (int)((ResultSet)rs).getDouble(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "int", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "long", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "long", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setDouble(Object ps, int param, double value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "double", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public double getDouble(Object rs, int param) {
        double value;
        try {
            value = ((ResultSet)rs).getDouble(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "double", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public float getFloat(Object rs, int param) {
        float value;
        try {
            value = (float)((ResultSet)rs).getDouble(param);
            if (((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "float", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setFloat(Object ps, int param, float value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "float", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Integer) {
                ((PreparedStatement)ps).setDouble(param, ((Integer)value).doubleValue());
            } else if (value instanceof Long) {
                ((PreparedStatement)ps).setDouble(param, ((Long)value).doubleValue());
            } else if (value instanceof Float) {
                ((PreparedStatement)ps).setDouble(param, ((Float)value).doubleValue());
            } else {
                ((PreparedStatement)ps).setDouble(param, (Double)value);
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        Number value;
        try {
            double d = ((ResultSet)rs).getDouble(param);
            value = this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Integer == null ? (class$java$lang$Integer = DoubleRDBMSMapping.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) ? (Number)(((ResultSet)rs).wasNull() ? null : new Integer((int)d)) : (Number)(this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Long == null ? (class$java$lang$Long = DoubleRDBMSMapping.class$("java.lang.Long")) : class$java$lang$Long).getName()) ? (Number)(((ResultSet)rs).wasNull() ? null : new Long((long)d)) : (Number)(this.getJavaTypeMapping().getJavaType().getName().equals((class$java$lang$Float == null ? (class$java$lang$Float = DoubleRDBMSMapping.class$("java.lang.Float")) : class$java$lang$Float).getName()) ? (Number)(((ResultSet)rs).wasNull() ? null : new Float(d)) : (Number)(((ResultSet)rs).wasNull() ? null : new Double(d))));
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), (Throwable)e);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

