/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.extent;

import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import org.jpox.PersistenceManager;
import org.jpox.store.DatastoreClass;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.exceptions.IncompatibleQueryElementTypeException;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.extent.AbstractExtent;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.query.TransientIDROF;
import org.jpox.util.Localiser;

public class ClassViewExtent
extends AbstractExtent
implements Queryable {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private final DatastoreClass view;
    private final int fieldCount;
    private final int[] prefetchFieldNumbers;
    private final StatementExpressionIndex[] statementExpressionIndex;

    public ClassViewExtent(PersistenceManager pm, DatastoreClass view, Class cls, boolean subclasses) {
        super(pm, cls, subclasses);
        this.view = view;
        this.fieldCount = this.cmd.getNoOfManagedFields();
        int[] fn = new int[this.fieldCount];
        this.statementExpressionIndex = new StatementExpressionIndex[this.fieldCount];
        int prefetchFieldCount = 0;
        for (int i = 0; i < this.fieldCount; ++i) {
            JavaTypeMapping m = view.getFieldMapping(this.cmd.getManagedFieldAbsolute(i));
            if (m == null) continue;
            if (!m.includeInFetchStatement() || m instanceof MappingCallbacks) {
                throw new JDOFatalInternalException(LOCALISER_RDBMS.msg("RDBMS.Extent.MappingInvalidForView", m, this.candidateClass.getName()));
            }
            this.statementExpressionIndex[i] = new StatementExpressionIndex();
            this.statementExpressionIndex[i].setMapping(m);
            fn[prefetchFieldCount++] = i;
        }
        if (prefetchFieldCount == 0) {
            throw new JDOFatalUserException(LOCALISER_RDBMS.msg("RDBMS.Extent.ClassHasNoPersistentFields", this.candidateClass.getName()));
        }
        this.prefetchFieldNumbers = new int[prefetchFieldCount];
        System.arraycopy(fn, 0, this.prefetchFieldNumbers, 0, prefetchFieldCount);
    }

    public QueryExpression newQueryStatement() {
        return this.storeMgr.getDatastoreAdapter().newQueryStatement(this.view, this.pm.getClassLoaderResolver());
    }

    public QueryExpression newQueryStatement(Class candidateClass) {
        String extentType = this.view.getType();
        if (!extentType.equals(candidateClass.getName())) {
            throw new IncompatibleQueryElementTypeException(extentType, candidateClass.getName());
        }
        return this.storeMgr.getDatastoreAdapter().newQueryStatement(this.view, this.pm.getClassLoaderResolver());
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        Mappings.selectMapping(stmt, this.statementExpressionIndex);
        return new TransientIDROF(this.getCandidateClass(), this.prefetchFieldNumbers, this.statementExpressionIndex);
    }

    public boolean isEmpty() {
        return false;
    }
}

