/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.extent;

import javax.jdo.JDOFatalUserException;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlanImpl;
import org.jpox.PersistenceManager;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.extent.AbstractExtent;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.DiscriminatorIteratorStatement;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.store.rdbms.query.ResultClassROF;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.util.Localiser;

public class ClassTableExtent
extends AbstractExtent
implements Queryable {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private final DatastoreClass[] tables;
    private final boolean multipleTableCase;
    private final DatastoreIdentifier elmIdentifier;
    private final DatastoreIdentifier thisIdentifier;

    public ClassTableExtent(PersistenceManager pm, DatastoreClass table, Class cls, boolean subclasses) {
        super(pm, cls, subclasses);
        this.tables = new DatastoreClass[1];
        this.tables[0] = table;
        this.multipleTableCase = false;
        this.elmIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "ELEMENT");
        this.thisIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "this");
    }

    public ClassTableExtent(PersistenceManager pm, DatastoreClass[] tables, Class cls, boolean subclasses) {
        super(pm, cls, subclasses);
        this.tables = tables;
        this.multipleTableCase = true;
        this.elmIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "ELEMENT");
        this.thisIdentifier = this.storeMgr.getIdentifierFactory().newIdentifier(0, "this");
    }

    public QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.getCandidateClass());
    }

    private boolean queryUsingDiscriminator() {
        boolean usingDiscriminator = true;
        if (this.tables.length == 1) {
            if (this.tables[0].getDiscriminatorMetaData() == null || this.tables[0].getDiscriminatorMapping() == null) {
                return false;
            }
            return usingDiscriminator;
        }
        return false;
    }

    public QueryExpression newQueryStatement(Class candidateClass) {
        final ClassLoaderResolver clr = this.pm.getClassLoaderResolver();
        QueryExpression query = null;
        if (this.tables == null) {
            return null;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            final int tableNo = i;
            Class cls = null;
            try {
                cls = clr.classForName(this.tables[tableNo].getType(), this.candidateClass.getClassLoader());
            }
            catch (ClassNotResolvedException cnfe) {
                throw new JDOFatalUserException(LOCALISER_RDBMS.msg("RDBMS.Extent.ClassNotFound", candidateClass.getName(), this.tables[tableNo].getType()));
            }
            if (this.queryUsingDiscriminator()) {
                if (this.storeMgr.getPMFContext().getTypeManager().isReferenceType(candidateClass)) {
                    String[] clsNames = this.storeMgr.getMetaDataManager().getClassesImplementingInterface(candidateClass.getName(), clr);
                    Class[] clss = new Class[clsNames.length];
                    for (int j = 0; j < clsNames.length; ++j) {
                        clss[j] = clr.classForName(clsNames[j]);
                    }
                    query = new DiscriminatorIteratorStatement(clr, clss, true, this.storeMgr, true).getQueryStatement();
                    continue;
                }
                query = new DiscriminatorIteratorStatement(clr, new Class[]{candidateClass}, this.subclasses, this.storeMgr, true).getQueryStatement();
                continue;
            }
            QueryExpression query_table = new UnionIteratorStatement(clr, this.multipleTableCase ? cls : candidateClass, this.subclasses, this.storeMgr, new UnionIteratorStatement.AssociationEnd(){

                public JavaTypeMapping getMapping() {
                    return ClassTableExtent.this.tables[tableNo].getIDMapping();
                }

                public Class getType() {
                    return clr.classForName(ClassTableExtent.this.tables[tableNo].getType());
                }

                public DatastoreContainerObject getDatastoreContainerObject() {
                    return ClassTableExtent.this.tables[tableNo];
                }

                public boolean useJoin() {
                    return false;
                }
            }, true).getQueryStatement();
            if (query != null) {
                query.union(query_table);
                continue;
            }
            query = query_table;
        }
        return query;
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        int[] prefetchFieldNumbers = null;
        StatementExpressionIndex[] statementExpressionIndex = null;
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        if (this.tables[0].getIdentityType() == IdentityType.DATASTORE) {
            datastoreIndex = this.multipleTableCase ? stmt.selectDatastoreIdentity("DATASTORE_ID", true) : (stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, this.tables[0].getDataStoreObjectIdMapping(), true) : stmt.select(this.thisIdentifier, this.tables[0].getDataStoreObjectIdMapping(), true));
        }
        if (this.tables[0].getVersionMapping() != null) {
            versionIndex = this.multipleTableCase ? stmt.selectVersion("VERSION", true) : (stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, this.tables[0].getVersionMapping(), true) : stmt.select(this.thisIdentifier, this.tables[0].getVersionMapping(), true));
        }
        if (this.multipleTableCase) {
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPrimaryKeyFieldNumbers().length];
                int fieldCount = cmd.getNoOfInheritedManagedFields() + cmd.getNoOfManagedFields();
                statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPrimaryKeyFieldNumbers()[i];
                    String fieldName = cmd.getManagedFieldAbsolute(prefetchFieldNumbers[i]).getName();
                    JavaTypeMapping m = this.tables[0].getFieldMapping(cmd.getManagedFieldAbsolute(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof MappingCallbacks) continue;
                    statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                    statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
                    statementExpressionIndex[prefetchFieldNumbers[i]].setExpressionIndex(stmt.selectField(fieldName, "APP_ID", true));
                }
            }
        } else if (useFetchPlan) {
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            ((FetchPlanImpl)this.getFetchPlan()).manageFetchPlanForClass(cmd);
            FetchPlanImpl.FetchPlanForClass fpc = ((FetchPlanImpl)this.getFetchPlan()).getFetchPlanForClass(cmd);
            int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
            int prefetchFieldCount = 0;
            int fieldCount = cmd.getNoOfInheritedManagedFields() + cmd.getNoOfManagedFields();
            int[] fn = new int[fieldNumbers.length];
            statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                JavaTypeMapping m = this.tables[0].getFieldMapping(cmd.getManagedFieldAbsolute(fieldNumbers[i]));
                if (m == null || !m.includeInFetchStatement() || m instanceof MappingCallbacks) continue;
                statementExpressionIndex[fieldNumbers[i]] = new StatementExpressionIndex();
                statementExpressionIndex[fieldNumbers[i]].setMapping(m);
                fn[prefetchFieldCount++] = fieldNumbers[i];
            }
            prefetchFieldNumbers = new int[prefetchFieldCount];
            System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
            if (stmt.getTableExpression(this.elmIdentifier) != null) {
                Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
            } else {
                Mappings.selectMapping(stmt, statementExpressionIndex);
            }
        } else {
            AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPrimaryKeyFieldNumbers().length];
                int fieldCount = cmd.getNoOfInheritedManagedFields() + cmd.getNoOfManagedFields();
                statementExpressionIndex = new StatementExpressionIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPrimaryKeyFieldNumbers()[i];
                    JavaTypeMapping m = this.tables[0].getFieldMapping(cmd.getManagedFieldAbsolute(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof MappingCallbacks) continue;
                    statementExpressionIndex[prefetchFieldNumbers[i]] = new StatementExpressionIndex();
                    statementExpressionIndex[prefetchFieldNumbers[i]].setMapping(m);
                }
                if (stmt.getTableExpression(this.elmIdentifier) != null) {
                    Mappings.selectMapping(stmt, this.elmIdentifier, statementExpressionIndex);
                } else {
                    Mappings.selectMapping(stmt, statementExpressionIndex);
                }
            }
        }
        if (resultClass == null) {
            return new PersistentIDROF(this.tables[0], prefetchFieldNumbers, this.cmd, statementExpressionIndex, datastoreIndex, versionIndex, ignoreCache, this.queryUsingDiscriminator(), stmt.hasMetaDataExpression(), (FetchPlanImpl)this.getFetchPlan());
        }
        return new ResultClassROF(resultClass, statementExpressionIndex);
    }

    public boolean isEmpty() {
        return false;
    }
}

