/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.columninfo;

import java.sql.ResultSet;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class OracleColumnInfo
extends ColumnInfo {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");

    public OracleColumnInfo(ResultSet rs) {
        super(rs);
        this.dataType = new Integer(OracleColumnInfo.getColumnType(this.typeName)).shortValue();
    }

    private static int getColumnType(String oracleDataType) {
        if (oracleDataType == null) {
            return 0;
        }
        if (oracleDataType.equals("ROWID")) {
            return 4;
        }
        if (oracleDataType.equals("NUMBER") || oracleDataType.equals("VARNUM")) {
            return 2;
        }
        if (oracleDataType.equals("VARCHAR2")) {
            return 12;
        }
        if (oracleDataType.equals("CHAR")) {
            return 1;
        }
        if (oracleDataType.equals("DATE")) {
            return 91;
        }
        if (oracleDataType.equals("CLOB") || oracleDataType.equals("NCLOB")) {
            return 2005;
        }
        if (oracleDataType.equals("BLOB")) {
            return 2004;
        }
        if (oracleDataType.equals("LONG")) {
            return -1;
        }
        if (oracleDataType.equals("LONG RAW")) {
            return -4;
        }
        if (oracleDataType.equals("RAW")) {
            return -3;
        }
        if (oracleDataType.startsWith("TIMESTAMP")) {
            return 93;
        }
        if (oracleDataType.equals("FLOAT")) {
            return 6;
        }
        JPOXLogger.RDBMS.warn(LOCALISER.msg("TypeInfo.UnrecognizedDatatype", oracleDataType));
        return 1111;
    }
}

