/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.SybaseColumnInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

class SybaseAdapter
extends DatabaseAdapter {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigInteger;

    public SybaseAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public String getVendorID() {
        return "sybase";
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean supportsBooleanComparison() {
        return false;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return false;
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        return new SybaseColumnInfo(rs);
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        TypeInfo ti = new TypeInfo(rs);
        if (ti.typeName.toLowerCase().startsWith("tinyint")) {
            return null;
        }
        if (ti.typeName.toLowerCase().startsWith("longsysname")) {
            return null;
        }
        return ti;
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$lang$Integer == null ? (class$java$lang$Integer = SybaseAdapter.class$("java.lang.Integer")) : class$java$lang$Integer, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(this.lengthMethod(str).sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SybaseAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTRING", args);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = SybaseAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        if (from != null) {
            args.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("CHARINDEX", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "SELECT @@IDENTITY";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public boolean supportsAutoIncrementKeysNullSpecification() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

