/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jdo.JDODataStoreException;
import org.jpox.ClassLoaderResolver;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.PluginManager;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class RDBMSAdapterFactory {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    HashMap adapters = new HashMap();
    HashSet secondaryAliases = new HashSet();
    static RDBMSAdapterFactory adapterMgr = new RDBMSAdapterFactory();
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;
    static /* synthetic */ Class class$org$jpox$store$rdbms$adapter$RDBMSAdapterFactory;

    public static RDBMSAdapterFactory getInstance() {
        return adapterMgr;
    }

    protected RDBMSAdapterFactory() {
    }

    public void addAdapter(String alias, String adapterClassName, boolean secondary) {
        if (alias == null || adapterClassName == null) {
            return;
        }
        this.adapters.put(alias, adapterClassName);
        if (secondary) {
            this.secondaryAliases.add(alias);
        }
    }

    public DatastoreAdapter getDatastoreAdapter(ClassLoaderResolver clr, Connection conn, String adapterClassName, PluginManager pluginMgr) throws SQLException {
        this.loadDatastoreAdapterExtension(pluginMgr);
        DatastoreAdapter adapter = null;
        DatabaseMetaData metadata = conn.getMetaData();
        adapter = this.getNewDatastoreAdapter(clr, metadata, adapterClassName);
        if (adapter == null) {
            JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Adapter.NoAdapterFound"));
            adapter = new DatabaseAdapter(metadata);
        }
        return adapter;
    }

    protected String getAdapterClassNameForProductName(String productName) {
        String adapterClassName = null;
        Set adapter_keys = this.adapters.keySet();
        if (adapter_keys != null) {
            Iterator keys_iter = adapter_keys.iterator();
            while (keys_iter.hasNext()) {
                String alias = (String)keys_iter.next();
                if (productName.toLowerCase().indexOf(alias.toLowerCase()) < 0) continue;
                if (adapterClassName == null) {
                    adapterClassName = (String)this.adapters.get(alias);
                    if (!this.secondaryAliases.contains(alias)) continue;
                    break;
                }
                if (!this.secondaryAliases.contains(alias)) continue;
                adapterClassName = (String)this.adapters.get(alias);
                break;
            }
        }
        return adapterClassName;
    }

    protected DatastoreAdapter getNewDatastoreAdapter(ClassLoaderResolver clr, DatabaseMetaData metadata, String adapterClassName) {
        if (metadata == null) {
            return null;
        }
        if (adapterClassName == null) {
            String productName = null;
            try {
                productName = metadata.getDatabaseProductName();
                if (productName == null) {
                    JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.JDBC.NoProductNameError"));
                    return null;
                }
            }
            catch (SQLException sqe) {
                JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.JDBC.ProductNameAccessError", sqe));
                return null;
            }
            adapterClassName = this.getAdapterClassNameForProductName(productName);
        }
        if (adapterClassName != null) {
            Object adapter_obj;
            Object[] ctr_args = new Object[]{metadata};
            Class[] ctr_args_classes = new Class[]{class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = RDBMSAdapterFactory.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData};
            try {
                Class<?> adapterClass;
                try {
                    adapterClass = Class.forName(adapterClassName, true, (class$org$jpox$store$rdbms$adapter$RDBMSAdapterFactory == null ? (class$org$jpox$store$rdbms$adapter$RDBMSAdapterFactory = RDBMSAdapterFactory.class$("org.jpox.store.rdbms.adapter.RDBMSAdapterFactory")) : class$org$jpox$store$rdbms$adapter$RDBMSAdapterFactory).getClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    adapterClass = clr.classForName(adapterClassName, true);
                }
                Constructor<?> ctr = adapterClass.getConstructor(ctr_args_classes);
                try {
                    ctr.setAccessible(true);
                    adapter_obj = ctr.newInstance(ctr_args);
                }
                catch (InvocationTargetException ite) {
                    if (ite.getTargetException() != null && ite.getTargetException() instanceof JDODataStoreException) {
                        throw (JDODataStoreException)ite.getTargetException();
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JPOXLogger.RDBMS.error(LOCALISER.msg("RDBMS.Adapter.InstantiationError", adapterClassName, e));
                    return null;
                }
            }
            catch (NoSuchMethodException nsme) {
                return null;
            }
            return (DatastoreAdapter)adapter_obj;
        }
        return null;
    }

    private void loadDatastoreAdapterExtension(PluginManager pluginMgr) {
        if (this.adapters.size() > 0) {
            return;
        }
        Extension[] ex = pluginMgr.getExtensionPoint("org.jpox.store_datastoreadapter").getExtensions();
        for (int i = 0; i < ex.length; ++i) {
            ConfigurationElement[] confElm = ex[i].getConfigurationElements();
            for (int c = 0; c < confElm.length; ++c) {
                adapterMgr.addAdapter(confElm[c].getAttribute("vendor-id"), confElm[c].getAttribute("class-name"), Boolean.valueOf(confElm[c].getAttribute("secondary")));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

