/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.typeinfo.H2TypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

class H2Adapter
extends DatabaseAdapter {
    private String schemaName;

    public H2Adapter(DatabaseMetaData metadata) {
        super(metadata);
        try {
            ResultSet rs = metadata.getSchemas();
            while (rs.next()) {
                if (!rs.getBoolean("IS_DEFAULT")) continue;
                this.schemaName = rs.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String getVendorID() {
        return "h2";
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        return new H2TypeInfo(rs);
    }

    public Connection getConnection(DataSource[] ds, String userName, String password, int isolationLevel) throws SQLException {
        Connection conn = super.getConnection(ds, userName, password, 8);
        if (isolationLevel == 0) {
            conn.setAutoCommit(true);
        }
        return conn;
    }

    public int getMaxTableNameLength() {
        return 128;
    }

    public int getMaxConstraintNameLength() {
        return 128;
    }

    public int getMaxIndexNameLength() {
        return 128;
    }

    public int getMaxColumnNameLength() {
        return 128;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getRangeByLimitSelectClause(long offset, long count) {
        if (offset >= 0L && count > 0L) {
            return " LIMIT " + offset + " " + count + " ";
        }
        if (offset <= 0L && count > 0L) {
            return " LIMIT 0 " + count + " ";
        }
        return "";
    }

    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return isolationLevel == 2 || isolationLevel == 8;
    }

    public boolean supportsPrimaryKeyInCreateStatements() {
        return true;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return this.schemaName;
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public boolean supportsAnalysisMethods() {
        return false;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "CALL IDENTITY()";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES(NULL)";
    }

    public boolean supportsUniqueConstraintsInEndCreateStatements() {
        return true;
    }

    public boolean supportsCheckConstraintsInEndCreateStatements() {
        return true;
    }

    public boolean isValidPrimaryKeyType(int datatype) {
        return true;
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }
}

