/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.jdo.JDODataStoreException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.expression.TableExprAsSubquery;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.typeinfo.DerbyTypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

class DerbyAdapter
extends DatabaseAdapter {
    private static final String CLOUDSCAPE_RESERVED_WORDS = "ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOOLEAN,BOTH,BY,CALL,CASCADE,CASCADED,CASE,CAST,CHAR,CHARACTER,CHARACTER_LENGTH,CHAR_LENGTH,CHECK,CLOSE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DIAGNOSTICS,DISCONNECT,DISTINCT,DOUBLE,DROP,ELSE,END,ENDEXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXPLAIN,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FOUND,FROM,FULL,FUNCTION,GET,GET_CURRENT_CONNECTION,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTO,IS,ISOLATION,JOIN,KEY,LAST,LEADING,LEFT,LIKE,LOCAL,LONGINT,LOWER,LTRIM,MATCH,MAX,MIN,MINUTE,NATIONAL,NATURAL,NCHAR,NVARCHAR,NEXT,NO,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUT,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,RTRIM,RUNTIMESTATISTICS,SCHEMA,SCROLL,SECOND,SELECT,SESSION_USER,SET,SMALLINT,SOME,SPACE,SQL,SQLCODE,SQLERROR,SQLSTATE,SUBSTR,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,TIMEZONE_HOUR,TIMEZONE_MINUTE,TINYINT,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USER,USING,VALUES,VARCHAR,VARYING,VIEW,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR";
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;

    public DerbyAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(CLOUDSCAPE_RESERVED_WORDS));
    }

    public void initialiseDatastore(Object conn) {
        try {
            Statement st = ((Connection)conn).createStatement();
            StringTokenizer tokens = new StringTokenizer(this.getASCIIFunction() + this.getMatchesFunction(), ";");
            while (tokens.hasMoreTokens()) {
                try {
                    st.execute(tokens.nextToken());
                }
                catch (SQLException e) {
                    JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Adapter.Derby.InitialisationError", e));
                }
            }
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new JDODataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return conn.getMetaData().getUserName().toUpperCase();
    }

    public String getCatalogName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        return catalog != null ? catalog : "";
    }

    public String getVendorID() {
        return "derby";
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        return new DerbyTypeInfo(rs);
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        if (this.datastoreMajorVersion >= 10) {
            return new TableExprAsJoins(qs, table, rangeVar);
        }
        return new TableExprAsSubquery(qs, table, rangeVar);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public boolean supportsNullsKeywordInColumnOptions() {
        return this.datastoreMajorVersion < 10;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public int getMaxConstraintNameLength() {
        if (this.datastoreMajorVersion >= 10) {
            return 18;
        }
        return this.maxConstraintNameLength;
    }

    public int getMaxIndexNameLength() {
        if (this.datastoreMajorVersion >= 10) {
            return 18;
        }
        return this.maxIndexNameLength;
    }

    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    public NumericExpression lengthMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new NumericExpression("LENGTH", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DerbyAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DerbyAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression trimMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new StringExpression("RTRIM", args);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        JavaTypeMapping m = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DerbyAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source);
        ScalarExpression integerLiteral = m.newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        return new BooleanExpression(new StringExpression("LOCATE", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    public String getAutoIncrementKeyword() {
        return "generated always as identity (start with 1)";
    }

    public boolean isAutoIncrementingDataType(String columnDef) {
        return columnDef != null && columnDef.toUpperCase().indexOf("AUTOINCREMENT") >= 0;
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    public boolean supportsDefaultKeywordWithNotNullInColumnOptions() {
        return false;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public boolean supportsNullsInCandidateKeys() {
        return false;
    }

    public boolean supportsAnalysisMethods() {
        return false;
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public NumericExpression toNumericExpression(CharacterExpression expr) {
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            JavaTypeMapping m = this.getMapping(value.getClass(), expr);
            return (NumericExpression)m.newLiteral(expr.getQueryExpression(), value);
        }
        if (expr instanceof Literal) {
            BigInteger value = new BigInteger((String)((Literal)((Object)expr)).getValue());
            JavaTypeMapping m = this.getMapping(value.getClass(), expr);
            return (NumericExpression)m.newLiteral(expr.getQueryExpression(), value);
        }
        ArrayList<CharacterExpression> args = new ArrayList<CharacterExpression>();
        args.add(expr);
        return new NumericExpression("JPOX_ASCII", args);
    }

    public StringExpression toStringExpression(NumericExpression expr) {
        if (expr instanceof Literal) {
            JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = DerbyAdapter.class$("java.lang.String")) : class$java$lang$String, expr);
            return new StringLiteral(expr.getQueryExpression(), m, ((Literal)((Object)expr)).getValue().toString());
        }
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        args.add(expr);
        ArrayList<StringExpression> argsRTRIM = new ArrayList<StringExpression>();
        argsRTRIM.add(new StringExpression("CHAR", args));
        return new StringExpression("RTRIM", argsRTRIM);
    }

    private String getASCIIFunction() {
        return "DROP FUNCTION JPOX_ASCII; CREATE FUNCTION JPOX_ASCII(C CHAR(1)) RETURNS INTEGER EXTERNAL NAME 'org.jpox.store.rdbms.adapter.DerbySQLFunction.ascii' CALLED ON NULL INPUT LANGUAGE JAVA PARAMETER STYLE JAVA;";
    }

    private String getMatchesFunction() {
        return "DROP FUNCTION JPOX_MATCHES; CREATE FUNCTION JPOX_MATCHES(TEXT VARCHAR(8000), PATTERN VARCHAR(8000)) RETURNS INTEGER EXTERNAL NAME 'org.jpox.store.rdbms.adapter.DerbySQLFunction.matches' CALLED ON NULL INPUT LANGUAGE JAVA PARAMETER STYLE JAVA;";
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(operand1);
        ArrayList<ScalarExpression> argsOp2 = new ArrayList<ScalarExpression>();
        argsOp2.add(operand2);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(super.concatOperator(new StringExpression("CAST", argsOp1, types), new StringExpression("CAST", argsOp2, types)));
        return new StringExpression("CAST", args, types);
    }

    public BooleanExpression matchesMethod(StringExpression text, StringExpression pattern) {
        JavaTypeMapping m = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DerbyAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, text);
        ScalarExpression integerLiteral = m.newLiteral(text.getQueryExpression(), BigInteger.ONE);
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(text);
        args.add(pattern);
        return new NumericExpression("JPOX_MATCHES", args).eq(integerLiteral);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

