/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jdo.JDODataStoreException;
import javax.sql.DataSource;
import org.jpox.ClassLoaderResolver;
import org.jpox.plugin.PluginManager;
import org.jpox.store.AbstractDatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.exceptions.UnsupportedDataTypeException;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.CharacterLiteral;
import org.jpox.store.expression.ConcatOperatorExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.SqlTemporalExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.StringLiteral;
import org.jpox.store.expression.SubstringExpression;
import org.jpox.store.expression.TableExprAsSubjoins;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.key.CandidateKey;
import org.jpox.store.rdbms.key.ForeignKey;
import org.jpox.store.rdbms.key.Index;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.mapping.RDBMSMappingManager;
import org.jpox.store.rdbms.query.QueryStatement;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.table.TableImpl;
import org.jpox.store.rdbms.table.ViewImpl;
import org.jpox.store.rdbms.typeinfo.ExportedKeyInfo;
import org.jpox.store.rdbms.typeinfo.ForeignKeyInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.FailoverUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class DatabaseAdapter
extends AbstractDatastoreAdapter
implements RDBMSAdapter {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected String driverName;
    protected String driverVersion;
    protected int driverMajorVersion;
    protected int driverMinorVersion;
    protected int maxTableNameLength;
    protected int maxConstraintNameLength;
    protected int maxIndexNameLength;
    protected int maxColumnNameLength;
    protected boolean supportsCatalogsInTableDefinitions;
    protected boolean supportsSchemasInTableDefinitions;
    protected String catalogSeparator;
    protected final HashMap typesByTypeNumber = new HashMap();
    protected boolean supportsStatementBatching = false;
    protected boolean storesLowerCaseIdentifiers = false;
    protected boolean storesMixedCaseIdentifiers = false;
    protected boolean storesUpperCaseIdentifiers = false;
    protected boolean storesLowerCaseQuotedIdentifiers = false;
    protected boolean storesMixedCaseQuotedIdentifiers = false;
    protected boolean storesUpperCaseQuotedIdentifiers = false;
    protected boolean storesMixedCaseSensitiveIdentifiers = false;
    protected boolean storesMixedCaseQuotedSensitiveIdentifiers = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigInteger;

    protected DatabaseAdapter(DatabaseMetaData metadata) {
        this.reservedKeywords.addAll(this.parseKeywordList("ABSOLUTE,ACTION,ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOTH,BY,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHAR_LENGTH,CHARACTER_LENGTH,CHECK,CLOSE,COALESCE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DESCRIPTOR,DIAGNOSTICS,DISCONNECT,DISTINCT,DOMAIN,DOUBLE,DROP,ELSE,END,END-EXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FOUND,FROM,FULL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,JOIN,KEY,LANGUAGE,LAST,LEADING,LEFT,LEVEL,LIKE,LOCAL,LOWER,MATCH,MAX,MIN,MINUTE,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NEXT,NO,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,POSITION,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,SCHEMA,SCROLL,SECOND,SECTION,SELECT,SESSION,SESSION_USER,SET,SIZE,SMALLINT,SOME,SPACE,SQL,SQLCODE,SQLERROR,SQLSTATE,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR,ZONE"));
        this.reservedKeywords.addAll(this.parseKeywordList("ABSOLUTE,ACTION,ADD,AFTER,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASC,ASENSITIVE,ASSERTION,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEFORE,BEGIN,BETWEEN,BINARY,BIT,BLOB,BOOLEAN,BOTH,BREADTH,BY,CALL,CALLED,CASCADE,CASCADED,CASE,CAST,CATALOG,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLLATION,COLUMN,COMMIT,CONDITION,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONSTRUCTOR,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATA,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DEFERRABLE,DEFERRED,DELETE,DEPTH,DEREF,DESC,DESCRIBE,DESCRIPTOR,DETERMINISTIC,DIAGNOSTICS,DISCONNECT,DISTINCT,DO,DOMAIN,DOUBLE,DROP,DYNAMIC,EACH,ELSE,ELSEIF,END,EQUALS,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FIRST,FLOAT,FOR,FOREIGN,FOUND,FREE,FROM,FULL,FUNCTION,GENERAL,GET,GLOBAL,GO,GOTO,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ISOLATION,ITERATE,JOIN,KEY,LANGUAGE,LARGE,LAST,LATERAL,LEADING,LEAVE,LEFT,LEVEL,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOCATOR,LOOP,MAP,MATCH,METHOD,MINUTE,MODIFIES,MODULE,MONTH,NAMES,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NEXT,NO,NONE,NOT,NULL,NUMERIC,OBJECT,OF,OLD,ON,ONLY,OPEN,OPTION,OR,ORDER,ORDINALITY,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PAD,PARAMETER,PARTIAL,PARTITION,PATH,PRECISION,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,RANGE,READ,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELATIVE,RELEASE,REPEAT,RESIGNAL,RESTRICT,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLE,ROLLBACK,ROLLUP,ROUTINE,ROW,ROWS,SAVEPOINT,SCHEMA,SCOPE,SCROLL,SEARCH,SECOND,SECTION,SELECT,SENSITIVE,SESSION,SESSION_USER,SET,SETS,SIGNAL,SIMILAR,SIZE,SMALLINT,SOME,SPACE,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATE,STATIC,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TEMPORARY,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSACTION,TRANSLATION,TREAT,TRIGGER,TRUE,UNDER,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USAGE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,VIEW,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,WORK,WRITE,YEAR,ZONE"));
        this.reservedKeywords.addAll(this.parseKeywordList("ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,ARRAY,AS,ASENSITIVE,ASYMMETRIC,AT,ATOMIC,AUTHORIZATION,BEGIN,BETWEEN,BIGINT,BINARY,BLOB,BOOLEAN,BOTH,BY,CALL,CALLED,CASCADED,CASE,CAST,CHAR,CHARACTER,CHECK,CLOB,CLOSE,COLLATE,COLUMN,COMMIT,CONDITION,CONNECT,CONSTRAINT,CONTINUE,CORRESPONDING,CREATE,CROSS,CUBE,CURRENT,CURRENT_DATE,CURRENT_DEFAULT_TRANSFORM_GROUP,CURRENT_PATH,CURRENT_ROLE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_TRANSFORM_GROUP_FOR_TYPE,CURRENT_USER,CURSOR,CYCLE,DATE,DAY,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFAULT,DELETE,DEREF,DESCRIBE,DETERMINISTIC,DISCONNECT,DISTINCT,DO,DOUBLE,DROP,DYNAMIC,EACH,ELEMENT,ELSE,ELSEIF,END,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,EXTERNAL,FALSE,FETCH,FILTER,FLOAT,FOR,FOREIGN,FREE,FROM,FULL,FUNCTION,GET,GLOBAL,GRANT,GROUP,GROUPING,HANDLER,HAVING,HOLD,HOUR,IDENTITY,IF,IMMEDIATE,IN,INDICATOR,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTERVAL,INTO,IS,ITERATE,JOIN,LANGUAGE,LARGE,LATERAL,LEADING,LEAVE,LEFT,LIKE,LOCAL,LOCALTIME,LOCALTIMESTAMP,LOOP,MATCH,MEMBER,MERGE,METHOD,MINUTE,MODIFIES,MODULE,MONTH,MULTISET,NATIONAL,NATURAL,NCHAR,NCLOB,NEW,NO,NONE,NOT,NULL,NUMERIC,OF,OLD,ON,ONLY,OPEN,OR,ORDER,OUT,OUTER,OUTPUT,OVER,OVERLAPS,PARAMETER,PARTITION,PRECISION,PREPARE,PRIMARY,PROCEDURE,RANGE,READS,REAL,RECURSIVE,REF,REFERENCES,REFERENCING,RELEASE,REPEAT,RESIGNAL,RESULT,RETURN,RETURNS,REVOKE,RIGHT,ROLLBACK,ROLLUP,ROW,ROWS,SAVEPOINT,SCOPE,SCROLL,SEARCH,SECOND,SELECT,SENSITIVE,SESSION_USER,SET,SIGNAL,SIMILAR,SMALLINT,SOME,SPECIFIC,SPECIFICTYPE,SQL,SQLEXCEPTION,SQLSTATE,SQLWARNING,START,STATIC,SUBMULTISET,SYMMETRIC,SYSTEM,SYSTEM_USER,TABLE,TABLESAMPLE,THEN,TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSLATION,TREAT,TRIGGER,TRUE,UNDO,UNION,UNIQUE,UNKNOWN,UNNEST,UNTIL,UPDATE,USER,USING,VALUE,VALUES,VARCHAR,VARYING,WHEN,WHENEVER,WHERE,WHILE,WINDOW,WITH,WITHIN,WITHOUT,YEAR"));
        this.reservedKeywords.addAll(this.parseKeywordList("ADA,C,CATALOG_NAME,CHARACTER_SET_CATALOG,CHARACTER_SET_NAME,CHARACTER_SET_SCHEMA,CLASS_ORIGIN,COBOL,COLLATION_CATALOG,COLLATION_NAME,COLLATION_SCHEMA,COLUMN_NAME,COMMAND_FUNCTION,COMMITTED,CONDITION_NUMBER,CONNECTION_NAME,CONSTRAINT_CATALOG,CONSTRAINT_NAME,CONSTRAINT_SCHEMA,CURSOR_NAME,DATA,DATETIME_INTERVAL_CODE,DATETIME_INTERVAL_PRECISION,DYNAMIC_FUNCTION,FORTRAN,LENGTH,MESSAGE_LENGTH,MESSAGE_OCTET_LENGTH,MESSAGE_TEXT,MORE,MUMPS,NAME,NULLABLE,NUMBER,PASCAL,PLI,REPEATABLE,RETURNED_LENGTH,RETURNED_OCTET_LENGTH,RETURNED_SQLSTATE,ROW_COUNT,SCALE,SCHEMA_NAME,SERIALIZABLE,SERVER_NAME,SUBCLASS_ORIGIN,TABLE_NAME,TYPE,UNCOMMITTED,UNNAMED"));
        try {
            block32: {
                this.reservedKeywords.addAll(this.parseKeywordList(metadata.getSQLKeywords()));
                this.driverMinorVersion = metadata.getDriverMinorVersion();
                this.driverMajorVersion = metadata.getDriverMajorVersion();
                this.driverName = metadata.getDriverName();
                this.driverVersion = metadata.getDriverVersion();
                this.datastoreProductName = metadata.getDatabaseProductName();
                this.datastoreProductVersion = metadata.getDatabaseProductVersion();
                StringBuffer strippedProductVersion = new StringBuffer();
                char previousChar = ' ';
                for (int i = 0; i < this.datastoreProductVersion.length(); ++i) {
                    char c = this.datastoreProductVersion.charAt(i);
                    if (Character.isDigit(c) || c == '.') {
                        if (previousChar != ' ') {
                            if (strippedProductVersion.length() == 0) {
                                strippedProductVersion.append(previousChar);
                            }
                            strippedProductVersion.append(c);
                        }
                        previousChar = c;
                        continue;
                    }
                    previousChar = ' ';
                }
                try {
                    StringTokenizer parts;
                    Class<?> mdc = metadata.getClass();
                    this.datastoreMajorVersion = (Integer)mdc.getMethod("getDatabaseMajorVersion", null).invoke((Object)metadata, null);
                    this.datastoreMinorVersion = (Integer)mdc.getMethod("getDatabaseMinorVersion", null).invoke((Object)metadata, null);
                    boolean noDBVersion = false;
                    if (this.datastoreMajorVersion <= 0 && this.datastoreMinorVersion <= 0) {
                        noDBVersion = true;
                    }
                    if ((parts = new StringTokenizer(strippedProductVersion.toString(), ".")).hasMoreTokens()) {
                        if (noDBVersion) {
                            try {
                                this.datastoreMajorVersion = Integer.parseInt(parts.nextToken());
                            }
                            catch (Exception e) {
                                this.datastoreMajorVersion = -1;
                            }
                        } else {
                            parts.nextToken();
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        if (noDBVersion) {
                            try {
                                this.datastoreMinorVersion = Integer.parseInt(parts.nextToken());
                            }
                            catch (Exception e) {
                                this.datastoreMajorVersion = -1;
                            }
                        } else {
                            parts.nextToken();
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreRevisionVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreRevisionVersion = -1;
                        }
                    }
                }
                catch (Throwable t) {
                    StringTokenizer parts = new StringTokenizer(strippedProductVersion.toString(), ".");
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreMajorVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreMajorVersion = -1;
                        }
                    }
                    if (parts.hasMoreTokens()) {
                        try {
                            this.datastoreMinorVersion = Integer.parseInt(parts.nextToken());
                        }
                        catch (Exception e) {
                            this.datastoreMajorVersion = -1;
                        }
                    }
                    if (!parts.hasMoreTokens()) break block32;
                    try {
                        this.datastoreRevisionVersion = Integer.parseInt(parts.nextToken());
                    }
                    catch (Exception e) {
                        this.datastoreRevisionVersion = -1;
                    }
                }
            }
            this.maxTableNameLength = metadata.getMaxTableNameLength();
            this.maxConstraintNameLength = metadata.getMaxTableNameLength();
            this.maxIndexNameLength = metadata.getMaxTableNameLength();
            this.maxColumnNameLength = metadata.getMaxColumnNameLength();
            this.supportsCatalogsInTableDefinitions = metadata.supportsCatalogsInTableDefinitions();
            this.supportsSchemasInTableDefinitions = metadata.supportsSchemasInTableDefinitions();
            this.supportsStatementBatching = metadata.supportsBatchUpdates();
            this.storesLowerCaseIdentifiers = metadata.storesLowerCaseIdentifiers();
            this.storesMixedCaseIdentifiers = metadata.storesMixedCaseIdentifiers();
            this.storesUpperCaseIdentifiers = metadata.storesUpperCaseIdentifiers();
            this.storesLowerCaseQuotedIdentifiers = metadata.storesLowerCaseQuotedIdentifiers();
            this.storesMixedCaseQuotedIdentifiers = metadata.storesMixedCaseQuotedIdentifiers();
            this.storesUpperCaseQuotedIdentifiers = metadata.storesUpperCaseQuotedIdentifiers();
            this.storesMixedCaseSensitiveIdentifiers = metadata.supportsMixedCaseIdentifiers();
            this.storesMixedCaseQuotedSensitiveIdentifiers = metadata.supportsMixedCaseQuotedIdentifiers();
            this.catalogSeparator = metadata.getCatalogSeparator();
            this.catalogSeparator = this.catalogSeparator == null || this.catalogSeparator.trim().length() < 1 ? "." : this.catalogSeparator;
            this.identifierQuoteString = metadata.getIdentifierQuoteString();
            this.identifierQuoteString = null == this.identifierQuoteString || this.identifierQuoteString.trim().length() < 1 ? "\"" : this.identifierQuoteString;
            this.createTypeInfo(metadata);
            JPOXLogger.RDBMS.info("================ DatabaseAdapter ==================");
            JPOXLogger.RDBMS.info("Adapter : " + this.getClass().getName());
            JPOXLogger.RDBMS.info("Datastore : name=\"" + this.datastoreProductName + "\" version=\"" + this.datastoreProductVersion + "\" (major=" + this.datastoreMajorVersion + ", minor=" + this.datastoreMinorVersion + ", revision=" + this.datastoreRevisionVersion + ")");
            JPOXLogger.RDBMS.info("Driver : name=\"" + this.driverName + "\" version=\"" + this.driverVersion + "\" (major=" + this.driverMajorVersion + ", minor=" + this.driverMinorVersion + ")");
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                JPOXLogger.RDBMS.debug("Identifier Cases : " + (this.storesLowerCaseIdentifiers ? "lowercase " : "") + (this.storesLowerCaseQuotedIdentifiers ? "\"lowercase\" " : "") + (this.storesMixedCaseIdentifiers ? "MixedCase " : "") + (this.storesMixedCaseQuotedIdentifiers ? "\"MixedCase\" " : "") + (this.storesUpperCaseIdentifiers ? "UPPERCASE " : "") + (this.storesUpperCaseQuotedIdentifiers ? "\"UPPERCASE\" " : "") + (this.storesMixedCaseSensitiveIdentifiers ? "MixedCase-Sensitive " : "") + (this.storesMixedCaseQuotedSensitiveIdentifiers ? "\"MixedCase-Sensitive\" " : ""));
                JPOXLogger.RDBMS.debug("Identifier Lengths : Table=" + this.getMaxTableNameLength() + " Column=" + this.getMaxColumnNameLength() + " Constraint=" + this.getMaxConstraintNameLength() + " Index=" + this.getMaxIndexNameLength() + " Delimeters=" + this.getIdentifierQuoteString());
                JPOXLogger.RDBMS.debug("Identifier Support in DDL : catalog=" + this.supportsCatalogsInTableDefinitions + "  schema=" + this.supportsSchemasInTableDefinitions);
                JPOXLogger.RDBMS.debug("Statement Batching : " + (this.supportsStatementBatching() ? "true" : "false"));
                StringBuffer typeStr = new StringBuffer();
                Collection types = this.typesByTypeNumber.values();
                Iterator typesIter = types.iterator();
                while (typesIter.hasNext()) {
                    JDBCTypeInfo info = (JDBCTypeInfo)typesIter.next();
                    typeStr.append(JDBCUtils.getNameForJDBCType(info.defaultTypeInfo.dataType));
                    if (!typesIter.hasNext()) continue;
                    typeStr.append(", ");
                }
                JPOXLogger.RDBMS.debug("JDBC Types supported : " + typeStr);
            }
            JPOXLogger.RDBMS.info("===================================================");
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("RDBMS.Adapter.MetaDataAccessError"), (Throwable)e);
        }
    }

    public void initialiseDatastore(Object conn) {
    }

    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr) {
        super.loadDatastoreMapping(mgr, clr);
        int[] jdbcTypes = JDBCUtils.getJDBCTypes();
        for (int i = 0; i < jdbcTypes.length; ++i) {
            if (this.typesByTypeNumber.get(new Integer(jdbcTypes[i])) != null) continue;
            ((RDBMSMappingManager)this.mappingManager).deregisterDatastoreMappingsForJDBCType(JDBCUtils.getNameForJDBCType(jdbcTypes[i]));
        }
    }

    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public int getMaxForeignKeys() {
        return 9999;
    }

    public int getMaxIndexes() {
        return 9999;
    }

    public int getMaxConstraintNameLength() {
        return this.maxConstraintNameLength;
    }

    public int getMaxIndexNameLength() {
        return this.maxIndexNameLength;
    }

    public int getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    public Iterator iteratorTypeInfo() {
        return this.typesByTypeNumber.values().iterator();
    }

    public Iterator iteratorReservedWords() {
        return this.reservedKeywords.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTypeInfo(DatabaseMetaData metadata) throws SQLException {
        ResultSet rs = metadata.getTypeInfo();
        try {
            while (rs.next()) {
                TypeInfo ti = this.newTypeInfo(rs);
                if (ti == null) continue;
                Integer key = new Integer(ti.dataType);
                JDBCTypeInfo jti = (JDBCTypeInfo)this.typesByTypeNumber.get(key);
                if (jti == null) {
                    jti = new JDBCTypeInfo(ti.dataType);
                    this.typesByTypeNumber.put(key, jti);
                }
                jti.addTypeInfo(ti);
            }
        }
        finally {
            rs.close();
        }
    }

    protected void addTypeInfo(short jdbcType, TypeInfo ti, boolean addIfNotPresent) {
        Integer key = new Integer(jdbcType);
        JDBCTypeInfo jti = (JDBCTypeInfo)this.typesByTypeNumber.get(key);
        if (jti != null && !addIfNotPresent) {
            return;
        }
        if (jti == null) {
            jti = new JDBCTypeInfo(jdbcType);
            this.typesByTypeNumber.put(key, jti);
        }
        jti.addTypeInfo(ti);
    }

    protected void setDefaultTypeInfoForJDBCType(int jdbcType, String defaultTypeName) {
        JDBCTypeInfo jti = (JDBCTypeInfo)this.typesByTypeNumber.get(new Integer(jdbcType));
        if (jti != null) {
            Iterator iter = jti.typeInfoByTypeName.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!((String)entry.getKey()).equalsIgnoreCase(defaultTypeName)) continue;
                jti.defaultTypeInfo = (TypeInfo)entry.getValue();
            }
        }
    }

    protected TypeInfo newTypeInfo(ResultSet rs) {
        return new TypeInfo(rs);
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        return new ColumnInfo(rs);
    }

    public ForeignKeyInfo newForeignKeyInfo(ResultSet rs) {
        return new ForeignKeyInfo(rs);
    }

    public ExportedKeyInfo newExportedKeyInfo(ResultSet rs) {
        return new ExportedKeyInfo(rs);
    }

    protected Set parseKeywordList(String list) {
        StringTokenizer tokens = new StringTokenizer(list, ",");
        HashSet<String> words = new HashSet<String>();
        while (tokens.hasMoreTokens()) {
            words.add(tokens.nextToken().trim().toUpperCase());
        }
        return words;
    }

    public boolean isSQLKeyword(String word) {
        return this.isReservedKeyword(word.toUpperCase());
    }

    public TypeInfo getTypeInfo(int dataType) throws UnsupportedDataTypeException {
        JDBCTypeInfo jti = (JDBCTypeInfo)this.typesByTypeNumber.get(new Integer(dataType));
        if (jti == null) {
            throw new UnsupportedDataTypeException(LOCALISER.msg("RDBMS.Adapter.JDBCTypeNotSupported", JDBCUtils.getNameForJDBCType(dataType)));
        }
        return jti.defaultTypeInfo;
    }

    public int getUnlimitedLengthPrecisionValue(TypeInfo typeInfo) {
        if (typeInfo.createParams != null && typeInfo.createParams.length() > 0) {
            return typeInfo.precision;
        }
        return -1;
    }

    public boolean isValidPrimaryKeyType(int datatype) {
        return datatype != 2004 && datatype != 2005 && datatype != -4;
    }

    public boolean isNullEqualsEmptyStrings() {
        return false;
    }

    public boolean isBitReallyBoolean() {
        return false;
    }

    public boolean supportsSettingBlobUsingSetString() {
        return false;
    }

    public boolean supportsSettingClobUsingSetString() {
        return false;
    }

    public String getSurrogateForEmptyStrings() {
        return null;
    }

    protected MappingManager getNewMappingManager() {
        return new RDBMSMappingManager();
    }

    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return true;
    }

    public int getTransactionIsolationForSchemaCreation() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(DataSource[] ds, String userName, String password, int isolationLevel) throws SQLException {
        Connection conn = userName == null ? FailoverUtils.getConnection(ds, false) : FailoverUtils.getConnection(ds, userName, password, false);
        boolean succeeded = false;
        try {
            if (isolationLevel == 0) {
                conn.setAutoCommit(true);
            } else {
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                if (this.supportsTransactionIsolationLevel(isolationLevel)) {
                    conn.setTransactionIsolation(isolationLevel);
                } else {
                    JPOXLogger.RDBMS.warn(LOCALISER.msg("RDBMS.Adapter.TransactionIsolationUnsupported", isolationLevel));
                }
            }
            succeeded = true;
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Connection.Opened", conn.toString(), JDBCUtils.getNameForJDBCIsolationLevel(isolationLevel)));
            }
        }
        finally {
            if (!succeeded) {
                conn.close();
            }
        }
        return conn;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            JPOXLogger.RDBMS.debug(LOCALISER.msg("RDBMS.Connection.Closed", conn.toString()));
        }
        conn.close();
    }

    public String getCatalogName(Connection conn) throws SQLException {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.CatalogNameError", this.datastoreProductName, this.datastoreProductVersion));
    }

    public String getSchemaName(Connection conn) throws SQLException {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.SchemaNameError", this.datastoreProductName, this.datastoreProductVersion));
    }

    public String getCatalogSeparator() {
        return this.catalogSeparator;
    }

    public boolean supportsEscapeExpressionInLikePredicate() {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return this.supportsCatalogsInTableDefinitions;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return this.supportsSchemasInTableDefinitions;
    }

    public boolean supportsStatementBatching() {
        return this.supportsStatementBatching;
    }

    public boolean supportsUnionSyntax() {
        return true;
    }

    public boolean supportsExistsSyntax() {
        return true;
    }

    public boolean supportsAnalysisMethods() {
        return true;
    }

    public ScalarExpression getEscapedPatternExpression(ScalarExpression patternExpression) {
        if (patternExpression instanceof StringLiteral) {
            String value = (String)((StringLiteral)patternExpression).getValue();
            value = StringUtils.replaceAll(value, "\\", "\\\\");
            value = StringUtils.replaceAll(value, "%", "\\%");
            value = StringUtils.replaceAll(value, "_", "\\_");
            JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = DatabaseAdapter.class$("java.lang.String")) : class$java$lang$String, patternExpression);
            return m.newLiteral(patternExpression.getQueryExpression(), value);
        }
        return patternExpression;
    }

    public String getPatternExpressionAnyCharacter() {
        return "_";
    }

    public String getPatternExpressionZeroMoreCharacters() {
        return "%";
    }

    public String getEscapePatternExpression() {
        return "ESCAPE '\\'";
    }

    public String getEscapeCharacter() {
        return "\\";
    }

    public String getContinuationString() {
        return "\n";
    }

    public boolean createIndexesBeforeForeignKeys() {
        return false;
    }

    public boolean includeOrderByColumnsInSelect() {
        return true;
    }

    public boolean includeOrderByColumnsInSelectUsingAlias() {
        return false;
    }

    public String cartersianProduct(LogicSetExpression Y) {
        StringBuffer sb = new StringBuffer();
        sb.append(" , ");
        sb.append(Y.toString());
        return sb.toString();
    }

    public boolean useUnionAll() {
        return false;
    }

    public boolean supportsAlterTableDropConstraint() {
        return true;
    }

    public boolean supportsAlterTableDropForeignKeyConstraint() {
        return false;
    }

    public boolean supportsDeferredConstraints() {
        return true;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return false;
    }

    public boolean supportsDistinctWithSelectForUpdate() {
        return true;
    }

    public String getSelectWithLockOption() {
        return null;
    }

    public boolean getPlaceWithOptionAfterFromClause() {
        return false;
    }

    public boolean getPlaceWithOptionWithinJoinClauses() {
        return false;
    }

    public String getSelectNewUUIDStmt() {
        return null;
    }

    public String getNewUUIDFunction() {
        return null;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return true;
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        return true;
    }

    public boolean supportsPrimaryKeyInCreateStatements() {
        return false;
    }

    public boolean supportsCheckInCreateStatements() {
        return true;
    }

    public boolean supportsCheckConstraintsInEndCreateStatements() {
        return false;
    }

    public boolean supportsUniqueConstraintsInEndCreateStatements() {
        return false;
    }

    public boolean supportsStatementGetGeneratedKeys() {
        return true;
    }

    public boolean supportsBooleanComparison() {
        return true;
    }

    public boolean supportsNullsInCandidateKeys() {
        return true;
    }

    public boolean supportsNullsKeywordInColumnOptions() {
        return true;
    }

    public boolean supportsDefaultKeywordInColumnOptions() {
        return true;
    }

    public boolean supportsDefaultKeywordWithNotNullInColumnOptions() {
        return true;
    }

    public boolean supportsDefaultBeforeNullInColumnOptions() {
        return true;
    }

    public boolean supportsAnsiJoinSyntax() {
        return true;
    }

    public String getNonAnsiInnerJoinWhereClause(String col1, String col2) {
        return null;
    }

    public String getNonAnsiLeftOuterJoinWhereClause(String col1, String col2) {
        return null;
    }

    public String getNonAnsiRightOuterJoinWhereClause(String col1, String col2) {
        return null;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.AutoIncrementNotSupported"));
    }

    public String getAutoIncrementKeyword() {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.AutoIncrementNotSupported"));
    }

    public boolean isAutoIncrementingDataType(String typeName) {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.AutoIncrementNotSupported"));
    }

    public boolean supportsAutoIncrementKeysNullSpecification() {
        return true;
    }

    public boolean supportsAutoIncrementColumnTypeSpecification() {
        return true;
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " () VALUES ()";
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.SequenceNotSupported"));
    }

    public String getSequenceNextStmt(String sequence_name) {
        throw new UnsupportedOperationException(LOCALISER.msg("RDBMS.Adapter.SequenceNotSupported"));
    }

    public ResultSet getExistingIndexes(Connection conn, DatabaseMetaData dmd, String catalog, String schema, String table) throws SQLException {
        return dmd.getIndexInfo(catalog, schema, table, false, true);
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, ClassLoaderResolver clr) {
        return new QueryStatement(table, clr);
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, DatastoreIdentifier rangeVar, ClassLoaderResolver clr) {
        return new QueryStatement(table, rangeVar, clr);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsSubjoins(qs, table, rangeVar);
    }

    public String getCreateTableStatement(TableImpl table, Column[] columns, Properties props) {
        int i;
        PrimaryKey pk;
        StringBuffer createStmt = new StringBuffer();
        createStmt.append("CREATE TABLE ").append(table.toString()).append(this.getContinuationString()).append("(").append(this.getContinuationString());
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (i2 > 0) {
                createStmt.append(",").append(this.getContinuationString());
            }
            createStmt.append("    ").append(columns[i2].getSQLDefinition());
        }
        if (this.supportsPrimaryKeyInCreateStatements() && (pk = table.getPrimaryKey()) != null && pk.size() > 0) {
            createStmt.append(",").append(this.getContinuationString());
            createStmt.append("    ").append(pk.toString());
        }
        if (this.supportsUniqueConstraintsInEndCreateStatements()) {
            StringBuffer uniqueConstraintStmt = new StringBuffer();
            for (i = 0; i < columns.length; ++i) {
                if (!columns[i].isUnique()) continue;
                if (uniqueConstraintStmt.length() < 1) {
                    uniqueConstraintStmt.append(",").append(this.getContinuationString());
                    uniqueConstraintStmt.append(" UNIQUE (");
                } else {
                    uniqueConstraintStmt.append(",");
                }
                uniqueConstraintStmt.append(((Object)columns[i].getIdentifier()).toString());
            }
            if (uniqueConstraintStmt.length() > 1) {
                uniqueConstraintStmt.append(")");
                createStmt.append(uniqueConstraintStmt.toString());
            }
        }
        if (this.supportsCheckConstraintsInEndCreateStatements()) {
            StringBuffer checkConstraintStmt = new StringBuffer();
            for (i = 0; i < columns.length; ++i) {
                if (columns[i].getConstraints() == null) continue;
                checkConstraintStmt.append(",").append(this.getContinuationString());
                checkConstraintStmt.append(columns[i].getConstraints());
            }
            if (checkConstraintStmt.length() > 1) {
                createStmt.append(checkConstraintStmt.toString());
            }
        }
        createStmt.append(this.getContinuationString()).append(")");
        return createStmt.toString();
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        if (pk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(pk.getName());
            return "ALTER TABLE " + pk.getDatastoreContainerObject().toString() + " ADD CONSTRAINT " + identifier + ' ' + pk;
        }
        return "ALTER TABLE " + pk.getDatastoreContainerObject().toString() + " ADD " + pk;
    }

    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        if (ck.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(ck.getName());
            return "ALTER TABLE " + ck.getDatastoreContainerObject().toString() + " ADD CONSTRAINT " + identifier + ' ' + ck;
        }
        return "ALTER TABLE " + ck.getDatastoreContainerObject().toString() + " ADD " + ck;
    }

    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        if (fk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(fk.getName());
            return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD CONSTRAINT " + identifier + ' ' + fk;
        }
        return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD " + fk;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD " + col.getSQLDefinition();
    }

    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String indexIdentifier = factory.getIdentifierInAdapterCase(idx.getName());
        return "CREATE " + (idx.getUnique() ? "UNIQUE " : "") + "INDEX " + indexIdentifier + " ON " + idx.getDatastoreContainerObject().toString() + ' ' + idx + (idx.getExtendedIndexSettings() == null ? "" : " " + idx.getExtendedIndexSettings());
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString() + " CASCADE";
    }

    public String getDropViewStatement(ViewImpl view) {
        return "DROP VIEW " + view.toString();
    }

    public String getRangeByLimitSelectClause(long offset, long count) {
        return "";
    }

    public String getRangeByLimitWhereClause(long offset, long count) {
        return "";
    }

    public String getRangeByRowNumberColumn() {
        return "";
    }

    public NumericExpression toNumericExpression(CharacterExpression expr) {
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            return (NumericExpression)this.getMapping(value.getClass(), expr).newLiteral(expr.getQueryExpression(), value);
        }
        if (expr instanceof Literal) {
            BigInteger value = new BigInteger((String)((Literal)((Object)expr)).getValue());
            return (NumericExpression)this.getMapping(value.getClass(), expr).newLiteral(expr.getQueryExpression(), value);
        }
        ArrayList<CharacterExpression> args = new ArrayList<CharacterExpression>();
        args.add(expr);
        return new NumericExpression("ASCII", args);
    }

    public NumericExpression absMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("ABS", args);
    }

    public NumericExpression sqrtMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("SQRT", args);
    }

    public NumericExpression cosMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("COS", args);
    }

    public NumericExpression sinMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("SIN", args);
    }

    public NumericExpression tanMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("TAN", args);
    }

    public NumericExpression acosMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("ACOS", args);
    }

    public NumericExpression asinMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("ASIN", args);
    }

    public NumericExpression atanMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("ATAN", args);
    }

    public BooleanExpression endsWithMethod(ScalarExpression leftOperand, ScalarExpression rightOperand) {
        if (!(rightOperand instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(rightOperand);
        }
        StringLiteral pct = new StringLiteral(leftOperand.getQueryExpression(), leftOperand.getMapping(), '%');
        return new BooleanExpression(leftOperand, ScalarExpression.OP_LIKE, pct.add(leftOperand.getQueryExpression().getStoreManager().getDatastoreAdapter().getEscapedPatternExpression(rightOperand)));
    }

    public NumericExpression expMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("EXP", args);
    }

    public NumericExpression logMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("LOG", args);
    }

    public NumericExpression floorMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("FLOOR", args);
    }

    public NumericExpression ceilMethod(ScalarExpression expr) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        return new NumericExpression("CEIL", args);
    }

    public NumericExpression lengthMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new NumericExpression("CHAR_LENGTH", args);
    }

    public BooleanExpression matchesMethod(StringExpression text, StringExpression pattern) {
        return new BooleanExpression(text, ScalarExpression.OP_LIKE, pattern);
    }

    public StringExpression toStringExpression(NumericExpression expr) {
        if (expr instanceof Literal) {
            JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = DatabaseAdapter.class$("java.lang.String")) : class$java$lang$String, expr);
            return new StringLiteral(expr.getQueryExpression(), m, ((Literal)((Object)expr)).getValue().toString());
        }
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        return new StringExpression("CAST", args, types);
    }

    public StringExpression toStringExpression(StringLiteral expr) {
        return expr;
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        return new SubstringExpression(str, begin);
    }

    public StringExpression trimMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new StringExpression("TRIM", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        return new SubstringExpression(str, begin, end);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression pct = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = DatabaseAdapter.class$("java.lang.String")) : class$java$lang$String, source).newLiteral(source.getQueryExpression(), "%");
        return new BooleanExpression(source, ScalarExpression.OP_LIKE, this.getEscapedPatternExpression(str).add(pct));
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        JavaTypeMapping m = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabaseAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source);
        ScalarExpression integerLiteral = m.newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        if (from != null) {
            args.add(from.add(integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("LOCATE", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public String getOperatorConcat() {
        return "||";
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        return new ConcatOperatorExpression(operand1, operand2);
    }

    public NumericExpression getDayMethod(SqlTemporalExpression date) {
        ArrayList<SqlTemporalExpression> args = new ArrayList<SqlTemporalExpression>();
        args.add(date);
        return new NumericExpression("DAY", args);
    }

    public NumericExpression getMonthMethod(SqlTemporalExpression date) {
        ArrayList<SqlTemporalExpression> args = new ArrayList<SqlTemporalExpression>();
        args.add(date);
        JavaTypeMapping m = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = DatabaseAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, date);
        ScalarExpression integerLiteral = m.newLiteral(date.getQueryExpression(), BigInteger.ONE);
        NumericExpression expr = new NumericExpression(new NumericExpression("MONTH", args), ScalarExpression.OP_SUB, integerLiteral);
        expr.encloseWithInParentheses();
        return expr;
    }

    public NumericExpression getYearMethod(SqlTemporalExpression date) {
        ArrayList<SqlTemporalExpression> args = new ArrayList<SqlTemporalExpression>();
        args.add(date);
        return new NumericExpression("YEAR", args);
    }

    public NumericExpression getHourMethod(SqlTemporalExpression time) {
        ArrayList<SqlTemporalExpression> args = new ArrayList<SqlTemporalExpression>();
        args.add(time);
        return new NumericExpression("HOUR", args);
    }

    public NumericExpression getMinuteMethod(SqlTemporalExpression time) {
        ArrayList<SqlTemporalExpression> args = new ArrayList<SqlTemporalExpression>();
        args.add(time);
        return new NumericExpression("MINUTE", args);
    }

    public NumericExpression getSecondMethod(SqlTemporalExpression time) {
        ArrayList<SqlTemporalExpression> args = new ArrayList<SqlTemporalExpression>();
        args.add(time);
        return new NumericExpression("SECOND", args);
    }

    public ResultSet getColumns(Connection conn, String catalog, String schema, String table) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        return dmd.getColumns(catalog, schema, table, null);
    }

    public ResultSet getTables(Connection conn, String catalog, String schema) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        return dmd.getTables(catalog, schema, null, null);
    }

    public ResultSet getColumns(Connection conn, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        return dmd.getColumns(catalog, schema, table, columnNamePattern);
    }

    public boolean requiresColumnDefaultsInitialising() {
        return true;
    }

    public boolean isStoresLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    public boolean isStoresLowerCaseQuotedIdentifiers() {
        return this.storesLowerCaseQuotedIdentifiers;
    }

    public boolean isStoresMixedCaseIdentifiers() {
        return this.storesMixedCaseIdentifiers || this.storesMixedCaseSensitiveIdentifiers;
    }

    public boolean isStoresMixedCaseQuotedIdentifiers() {
        return this.storesMixedCaseQuotedIdentifiers || this.storesMixedCaseQuotedSensitiveIdentifiers;
    }

    public boolean isStoresUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public boolean isStoresUpperCaseQuotedIdentifiers() {
        return this.storesUpperCaseQuotedIdentifiers;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("================ DatabaseAdapter ==================");
        sb.append("\n");
        sb.append("Adapter : " + this.getClass().getName());
        sb.append("\n");
        sb.append("Datastore : name=\"" + this.datastoreProductName + "\" version=\"" + this.datastoreProductVersion + "\" (major=" + this.datastoreMajorVersion + ", minor=" + this.datastoreMinorVersion + ", revision=" + this.datastoreRevisionVersion + ")");
        sb.append("\n");
        sb.append("Driver : name=\"" + this.driverName + "\" version=\"" + this.driverVersion + "\" (major=" + this.driverMajorVersion + ", minor=" + this.driverMinorVersion + ")");
        sb.append("\n");
        sb.append("===================================================");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class JDBCTypeInfo {
        short jdbcType;
        HashMap typeInfoByTypeName = new HashMap();
        TypeInfo defaultTypeInfo;

        public JDBCTypeInfo(short jdbcType) {
            this.jdbcType = jdbcType;
        }

        public void addTypeInfo(TypeInfo ti) {
            this.typeInfoByTypeName.put(ti.typeName, ti);
            if (this.typeInfoByTypeName.size() == 1) {
                this.defaultTypeInfo = ti;
            }
        }

        public void setDefault(TypeInfo ti) {
            this.defaultTypeInfo = ti;
        }

        public short getJdbcType() {
            return this.jdbcType;
        }

        public TypeInfo getDefault() {
            return this.defaultTypeInfo;
        }

        public String[] getTypeNames() {
            if (this.typeInfoByTypeName.size() == 0) {
                return null;
            }
            return this.typeInfoByTypeName.keySet().toArray(new String[this.typeInfoByTypeName.size()]);
        }
    }
}

