/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.jdo.JDODataStoreException;
import javax.jdo.datastore.Sequence;
import org.jpox.PersistenceManager;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.store.StoreManager;
import org.jpox.store.poid.PoidConnectionProvider;
import org.jpox.store.poid.PoidGenerator;
import org.jpox.store.poid.PoidManager;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class SequenceImpl
implements Sequence {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    protected final StoreManager storeManager;
    protected final SequenceMetaData seqMetaData;
    protected final PoidGenerator generator;
    protected final PersistenceManager pm;

    public SequenceImpl(PersistenceManager persistenceManager, StoreManager storeMgr, SequenceMetaData seqmd) {
        this.pm = persistenceManager;
        this.storeManager = storeMgr;
        this.seqMetaData = seqmd;
        String poidGeneratorName = null;
        poidGeneratorName = storeMgr.getDatastoreAdapter().supportsSequences() ? "org.jpox.store.rdbms.poid.SequencePoidGenerator" : "org.jpox.store.rdbms.poid.SequenceTablePoidGenerator";
        Properties props = new Properties();
        ExtensionMetaData[] seqExtensions = seqmd.getExtensions();
        if (seqExtensions != null && seqExtensions.length > 0) {
            for (int i = 0; i < seqExtensions.length; ++i) {
                props.put(seqExtensions[i].getKey(), seqExtensions[i].getValue());
            }
        }
        if (poidGeneratorName.equals("org.jpox.store.rdbms.poid.SequencePoidGenerator")) {
            props.put("sequence-name", this.seqMetaData.getDatastoreSequence());
        } else if (poidGeneratorName.equals("org.jpox.store.rdbms.poid.SequenceTablePoidGenerator")) {
            props.put("sequence-name", this.seqMetaData.getDatastoreSequence());
        }
        PoidManager mgr = new PoidManager();
        PoidConnectionProvider connProvider = new PoidConnectionProvider(){
            Connection conn;

            public Object retrieveConnection() {
                try {
                    this.conn = ((RDBMSManager)SequenceImpl.this.storeManager).getConnection(SequenceImpl.this.pm.getPMFContext().getPmfConfiguration().getPoidTransactionIsolationLevel());
                }
                catch (SQLException e) {
                    String msg = LOCALISER.msg("Sequence.POIDConnectionOpenError", e);
                    JPOXLogger.JDO.error(msg);
                    throw new JDODataStoreException(msg, (Throwable)e);
                }
                return this.conn;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void releaseConnection() {
                try {
                    boolean success = false;
                    try {
                        if (!this.conn.getAutoCommit()) {
                            this.conn.commit();
                        }
                        success = true;
                    }
                    finally {
                        if (!success && !this.conn.getAutoCommit()) {
                            this.conn.rollback();
                        }
                    }
                    ((RDBMSManager)SequenceImpl.this.storeManager).closeConnection(this.conn);
                }
                catch (SQLException e) {
                    String msg = LOCALISER.msg("Sequence.POIDConnectionCloseError", e);
                    JPOXLogger.JDO.error(msg);
                    throw new JDODataStoreException(msg);
                }
            }
        };
        this.generator = mgr.createPoidGenerator(this.pm.getClassLoaderResolver(), this.seqMetaData.getName(), poidGeneratorName, props, this.storeManager, connProvider);
        if (JPOXLogger.JDO.isDebugEnabled()) {
            JPOXLogger.JDO.debug(LOCALISER.msg("Sequence.Allocated", this.seqMetaData.getName(), poidGeneratorName));
        }
    }

    public String getName() {
        return this.seqMetaData.getName();
    }

    public void allocate(int additional) {
        this.generator.allocate(additional);
    }

    public Object next() {
        return this.generator.next();
    }

    public long nextValue() {
        return this.generator.nextValue();
    }

    public Object current() {
        return this.generator.current();
    }

    public long currentValue() {
        return this.generator.currentValue();
    }
}

